/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.util;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import javax.imageio.ImageIO;
import org.junit.Assert;
import org.junit.Test;

public class LandMaskRasterCreatorTest {
    @Test
    public void testMixedFile() throws Exception {
        BufferedImage image = ImageIO.read(this.getClass().getResource("156-12.png"));
        int sample = image.getData().getSample(220, 40, 0);
        Assert.assertEquals((long)0L, (long)sample);
        sample = image.getData().getSample(220, 41, 0);
        Assert.assertEquals((long)1L, (long)sample);
        sample = image.getData().getSample(187, 89, 0);
        Assert.assertEquals((long)0L, (long)sample);
        sample = image.getData().getSample(186, 89, 0);
        Assert.assertEquals((long)1L, (long)sample);
        sample = image.getData().getSample(188, 89, 0);
        Assert.assertEquals((long)1L, (long)sample);
    }

    @Test
    public void testAllWaterFile() throws Exception {
        BufferedImage image = ImageIO.read(this.getClass().getResource("195-10.png"));
        Raster imageData = image.getData();
        for (int x = 0; x < imageData.getWidth(); ++x) {
            for (int y = 0; y < imageData.getHeight(); ++y) {
                Assert.assertEquals((long)0L, (long)imageData.getSample(x, y, 0));
            }
        }
    }

    @Test
    public void testAllLandFile() throws Exception {
        BufferedImage image = ImageIO.read(this.getClass().getResource("92-10.png"));
        Raster imageData = image.getData();
        for (int x = 0; x < imageData.getWidth(); ++x) {
            for (int y = 0; y < imageData.getHeight(); ++y) {
                Assert.assertEquals((long)1L, (long)imageData.getSample(x, y, 0));
            }
        }
    }
}

