/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.operator;

import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.watermask.operator.WatermaskOp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class WatermaskOpTest {
    private Product sourceProduct;
    private Map<String, Object> parameters;

    @Before
    public void setUp() throws Exception {
        this.sourceProduct = new Product("dummy", "type", 1, 1);
        this.sourceProduct.setSceneGeoCoding((GeoCoding)new MyGeoCoding());
        this.parameters = new HashMap<String, Object>();
        GPF.getDefaultInstance().getOperatorSpiRegistry().loadOperatorSpis();
    }

    @Test
    public void testWithSubsampling() throws Exception {
        this.parameters.put("subSamplingFactorX", 10);
        this.parameters.put("subSamplingFactorY", 10);
        Product lwProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(WatermaskOp.class), this.parameters, (Product)this.sourceProduct);
        Band band = lwProduct.getBand("land_water_fraction");
        byte sample = (byte)band.getSourceImage().getData().getSample(0, 0, 0);
        Assert.assertEquals((long)25L, (long)sample);
    }

    @Test
    public void testWithoutSubsampling() throws Exception {
        Product lwProduct = GPF.createProduct((String)OperatorSpi.getOperatorAlias(WatermaskOp.class), this.parameters, (Product)this.sourceProduct);
        Band band = lwProduct.getBand("land_water_fraction");
        byte sample = (byte)band.getSourceImage().getData().getSample(0, 0, 0);
        Assert.assertEquals((long)0L, (long)sample);
    }

    private static class MyGeoCoding
    implements GeoCoding {
        private MyGeoCoding() {
        }

        public boolean isCrossingMeridianAt180() {
            return false;
        }

        public boolean canGetPixelPos() {
            return false;
        }

        public boolean canGetGeoPos() {
            return true;
        }

        public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
            return null;
        }

        public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
            double pixelSize = 0.002777777777777778;
            geoPos.setLocation((double)((float)(66.40278 + (pixelPos.y - 0.5) * pixelSize)), (double)((float)(28.063889 + (pixelPos.x - 0.5) * pixelSize)));
            return geoPos;
        }

        public Datum getDatum() {
            return null;
        }

        public void dispose() {
        }

        public CoordinateReferenceSystem getImageCRS() {
            return null;
        }

        public CoordinateReferenceSystem getMapCRS() {
            return null;
        }

        public CoordinateReferenceSystem getGeoCRS() {
            return null;
        }

        public MathTransform getImageToMapTransform() {
            return null;
        }
    }
}

