/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.PlainFeatureFactory;
import org.esa.snap.core.datamodel.SceneTransformProvider;
import org.esa.snap.core.transform.MathTransform2D;
import org.esa.snap.ui.product.SimpleFeatureShapeFigure;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SimpleFeatureShapeFigureTest
extends TestCase {
    private final GeometryFactory gf = new GeometryFactory();
    private SceneTransformProvider sceneTransformProvider;

    @Before
    public void setUp() {
        this.sceneTransformProvider = new SceneTransformProvider(){

            public MathTransform2D getModelToSceneTransform() {
                return MathTransform2D.IDENTITY;
            }

            public MathTransform2D getSceneToModelTransform() {
                return MathTransform2D.IDENTITY;
            }
        };
    }

    public void testSpecificGeometryType() {
        SimpleFeatureType sft = PlainFeatureFactory.createPlainFeatureType((String)"Polygon", Polygon.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Polygon polygon = this.createPolygon();
        SimpleFeature simpleFeature = PlainFeatureFactory.createPlainFeature((SimpleFeatureType)sft, (String)"_1", (Geometry)polygon, (String)"");
        SimpleFeatureShapeFigure shapeFigure = new SimpleFeatureShapeFigure(simpleFeature, this.sceneTransformProvider, (FigureStyle)new DefaultFigureStyle());
        SimpleFeatureShapeFigureTest.assertEquals((Object)polygon, (Object)shapeFigure.getGeometry());
        SimpleFeatureShapeFigureTest.assertNotNull((Object)shapeFigure.getShape());
        SimpleFeatureShapeFigureTest.assertEquals((Object)Figure.Rank.AREA, (Object)shapeFigure.getRank());
    }

    @Ignore
    @Test
    public void testMixedGeometries_2() {
    }

    public void testMixedGeometries_1() {
        SimpleFeatureType sft = PlainFeatureFactory.createPlainFeatureType((String)"Geometry", Geometry.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Polygon geometry = this.createPolygon();
        SimpleFeature feature = PlainFeatureFactory.createPlainFeature((SimpleFeatureType)sft, (String)"_1", (Geometry)geometry, (String)"");
        SimpleFeatureShapeFigure figure = new SimpleFeatureShapeFigure(feature, this.sceneTransformProvider, (FigureStyle)new DefaultFigureStyle());
        SimpleFeatureShapeFigureTest.assertEquals((Object)geometry, (Object)figure.getGeometry());
        SimpleFeatureShapeFigureTest.assertNotNull((Object)figure.getShape());
        SimpleFeatureShapeFigureTest.assertEquals((Object)Figure.Rank.AREA, (Object)figure.getRank());
        geometry = this.createLinearRing();
        feature = PlainFeatureFactory.createPlainFeature((SimpleFeatureType)sft, (String)"_2", (Geometry)geometry, (String)"");
        figure = new SimpleFeatureShapeFigure(feature, this.sceneTransformProvider, (FigureStyle)new DefaultFigureStyle());
        SimpleFeatureShapeFigureTest.assertEquals((Object)geometry, (Object)figure.getGeometry());
        SimpleFeatureShapeFigureTest.assertNotNull((Object)figure.getShape());
        SimpleFeatureShapeFigureTest.assertEquals((Object)Figure.Rank.LINE, (Object)figure.getRank());
        geometry = this.createLineString();
        feature = PlainFeatureFactory.createPlainFeature((SimpleFeatureType)sft, (String)"_3", (Geometry)geometry, (String)"");
        figure = new SimpleFeatureShapeFigure(feature, this.sceneTransformProvider, (FigureStyle)new DefaultFigureStyle());
        SimpleFeatureShapeFigureTest.assertEquals((Object)geometry, (Object)figure.getGeometry());
        SimpleFeatureShapeFigureTest.assertNotNull((Object)figure.getShape());
        SimpleFeatureShapeFigureTest.assertEquals((Object)Figure.Rank.LINE, (Object)figure.getRank());
    }

    public void testRank() {
        SimpleFeatureShapeFigureTest.assertEquals((Object)Figure.Rank.POINT, (Object)SimpleFeatureShapeFigure.getRank((Geometry)this.createPoint()));
        SimpleFeatureShapeFigureTest.assertEquals((Object)Figure.Rank.POINT, (Object)SimpleFeatureShapeFigure.getRank((Geometry)this.createMultiPoint()));
        SimpleFeatureShapeFigureTest.assertEquals((Object)Figure.Rank.LINE, (Object)SimpleFeatureShapeFigure.getRank((Geometry)this.createLineString()));
        SimpleFeatureShapeFigureTest.assertEquals((Object)Figure.Rank.LINE, (Object)SimpleFeatureShapeFigure.getRank((Geometry)this.createLinearRing()));
        SimpleFeatureShapeFigureTest.assertEquals((Object)Figure.Rank.LINE, (Object)SimpleFeatureShapeFigure.getRank((Geometry)this.createMultiLineString()));
        SimpleFeatureShapeFigureTest.assertEquals((Object)Figure.Rank.AREA, (Object)SimpleFeatureShapeFigure.getRank((Geometry)this.createPolygon()));
        SimpleFeatureShapeFigureTest.assertEquals((Object)Figure.Rank.AREA, (Object)SimpleFeatureShapeFigure.getRank((Geometry)this.createMultiPolygon()));
        SimpleFeatureShapeFigureTest.assertEquals((Object)Figure.Rank.NOT_SPECIFIED, (Object)SimpleFeatureShapeFigure.getRank((Geometry)this.createGeometryCollection()));
    }

    private Point createPoint() {
        return this.gf.createPoint(new Coordinate(0.0, 0.0));
    }

    private LineString createLineString() {
        return this.gf.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0)});
    }

    private LinearRing createLinearRing() {
        return this.gf.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)});
    }

    private Polygon createPolygon() {
        return this.gf.createPolygon(this.gf.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)}), null);
    }

    private MultiPoint createMultiPoint() {
        return this.gf.createMultiPoint(new Point[0]);
    }

    private MultiPolygon createMultiPolygon() {
        return this.gf.createMultiPolygon(new Polygon[0]);
    }

    private MultiLineString createMultiLineString() {
        return this.gf.createMultiLineString(new LineString[0]);
    }

    private GeometryCollection createGeometryCollection() {
        return this.gf.createGeometryCollection(new Geometry[0]);
    }
}

