/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.awt.geom.Rectangle2D;
import org.esa.snap.ui.RegionSelectableWorldMapPane;
import org.junit.Assert;
import org.junit.Test;

public class RegionSelectableWorldMapPane_BoundingValuesValidation {
    private final double validNorthBound = 75.0;
    private final double validEastBound = 30.0;
    private final double validSouthBound = 20.0;
    private final double validWestBound = 10.0;

    @Test
    public void testValidBounds() {
        Assert.assertTrue((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)30.0, (Double)20.0, (Double)10.0));
    }

    @Test
    public void testThatReturnValueIsFalseIfAllBoundingValuesAreNull() {
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid(null, null, null, null));
    }

    @Test
    public void testThatEachValueMustBeNotNull() {
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid(null, (Double)30.0, (Double)20.0, (Double)10.0));
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, null, (Double)20.0, (Double)10.0));
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)30.0, null, (Double)10.0));
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)30.0, (Double)20.0, null));
    }

    @Test
    public void testThatNorthValueMustBeBiggerThanSouthValue() {
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)10.0, (Double)30.0, (Double)10.0, (Double)10.0));
    }

    @Test
    public void testThatEastValueMustBeBiggerThanWestValue() {
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)10.0, (Double)20.0, (Double)10.0));
    }

    @Test
    public void testThatValuesAreInsideValidBounds() {
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)91.0, (Double)30.0, (Double)20.0, (Double)10.0));
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)181.0, (Double)20.0, (Double)10.0));
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)30.0, (Double)-91.0, (Double)10.0));
        Assert.assertFalse((boolean)RegionSelectableWorldMapPane.geoBoundsAreValid((Double)75.0, (Double)30.0, (Double)20.0, (Double)-181.0));
    }

    @Test
    public void testCorrectBoundsIfNecessary_noCorrection() {
        Rectangle2D.Double toCorrect = new Rectangle2D.Double(-175.0, -85.0, 140.0, 110.0);
        RegionSelectableWorldMapPane.correctBoundsIfNecessary((Rectangle2D)toCorrect);
        Assert.assertEquals((double)-175.0, (double)toCorrect.getMinX(), (double)1.0E-8);
        Assert.assertEquals((double)-85.0, (double)toCorrect.getMinY(), (double)1.0E-8);
        Assert.assertEquals((double)-35.0, (double)toCorrect.getMaxX(), (double)1.0E-8);
        Assert.assertEquals((double)25.0, (double)toCorrect.getMaxY(), (double)1.0E-8);
    }

    @Test
    public void testCorrectBoundsIfNecessary_correction_positive_x() {
        Rectangle2D.Double toCorrect = new Rectangle2D.Double(-175.499991, -90.0, 360.0, 180.0);
        RegionSelectableWorldMapPane.correctBoundsIfNecessary((Rectangle2D)toCorrect);
        Assert.assertEquals((double)-175.499991, (double)toCorrect.getMinX(), (double)1.0E-8);
        Assert.assertEquals((double)180.0, (double)toCorrect.getMaxX(), (double)1.0E-8);
        Assert.assertEquals((double)-90.0, (double)toCorrect.getMinY(), (double)1.0E-8);
        Assert.assertEquals((double)90.0, (double)toCorrect.getMaxY(), (double)1.0E-8);
        Assert.assertTrue((toCorrect.getMinX() + toCorrect.getWidth() <= 180.0 ? 1 : 0) != 0);
        Assert.assertTrue((toCorrect.getMinY() + toCorrect.getHeight() <= 90.0 ? 1 : 0) != 0);
    }

    @Test
    public void testCorrectBoundsIfNecessary_correction_negative_x() {
        Rectangle2D.Double toCorrect = new Rectangle2D.Double(-185.499991, -90.0, 360.0, 180.0);
        RegionSelectableWorldMapPane.correctBoundsIfNecessary((Rectangle2D)toCorrect);
        Assert.assertEquals((double)-180.0, (double)toCorrect.getMinX(), (double)1.0E-8);
        Assert.assertEquals((double)174.50000899999895, (double)toCorrect.getMaxX(), (double)1.0E-8);
        Assert.assertEquals((double)-90.0, (double)toCorrect.getMinY(), (double)1.0E-8);
        Assert.assertEquals((double)90.0, (double)toCorrect.getMaxY(), (double)1.0E-8);
        Assert.assertTrue((toCorrect.getMinX() + toCorrect.getWidth() <= 180.0 ? 1 : 0) != 0);
        Assert.assertTrue((toCorrect.getMinY() + toCorrect.getHeight() <= 90.0 ? 1 : 0) != 0);
    }
}

