/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.crs.projdef;

import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.ui.crs.projdef.UTMAutomaticCrsProvider;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.GeodeticDatum;

public class UTMAutomaticCrsProviderTest {
    @Test
    public void getCRS() throws Exception {
        UTMAutomaticCrsProvider autoUtmCrsProvider = new UTMAutomaticCrsProvider((GeodeticDatum)DefaultGeodeticDatum.WGS84);
        CoordinateReferenceSystem crs = autoUtmCrsProvider.getCRS(new GeoPos(31.0, 33.0), null, (GeodeticDatum)DefaultGeodeticDatum.WGS84);
        Assert.assertEquals((Object)"UTM Zone 36 / WGS84", (Object)crs.getName().getCode());
        crs = autoUtmCrsProvider.getCRS(new GeoPos(-31.0, 33.0), null, (GeodeticDatum)DefaultGeodeticDatum.WGS84);
        Assert.assertEquals((Object)"UTM Zone 36, South / WGS84", (Object)crs.getName().getCode());
        crs = autoUtmCrsProvider.getCRS(new GeoPos(54.0, 10.0), null, (GeodeticDatum)DefaultGeodeticDatum.WGS84);
        Assert.assertEquals((Object)"UTM Zone 32 / WGS84", (Object)crs.getName().getCode());
        crs = autoUtmCrsProvider.getCRS(new GeoPos(36.0, -100.0), null, (GeodeticDatum)DefaultGeodeticDatum.WGS84);
        Assert.assertEquals((Object)"UTM Zone 14 / WGS84", (Object)crs.getName().getCode());
    }
}

