/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JInternalFrame;
import javax.swing.JSpinner;
import org.esa.snap.core.param.ParamProperties;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.ui.UIUtils;
import org.junit.Assert;
import org.junit.Test;

public class UIUtilsTest {
    @Test
    public void testCenterComponent() {
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Panel comp = new Panel();
            Panel alignComp = new Panel();
            comp.setBounds(0, 0, 100, 100);
            UIUtils.centerComponent((Component)comp);
            Assert.assertEquals((Object)comp.getBounds(), (Object)new Rectangle(screenSize.width / 2 - 50, screenSize.height / 2 - 50, 100, 100));
            comp.setBounds(0, 0, 100, 100);
            alignComp.setBounds(100, 100, 200, 200);
            UIUtils.centerComponent((Component)comp, (Component)alignComp);
            Assert.assertEquals((Object)comp.getBounds(), (Object)new Rectangle(150, 150, 100, 100));
        }
        catch (HeadlessException e) {
            this.warnHeadless();
        }
    }

    @Test
    public void testGetScreenSize() {
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Assert.assertNotNull((Object)UIUtils.getScreenSize());
            Assert.assertEquals((Object)UIUtils.getScreenSize(), (Object)screenSize);
        }
        catch (HeadlessException e) {
            this.warnHeadless();
        }
    }

    @Test
    public void testGetScreenWidth() {
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Assert.assertEquals((long)UIUtils.getScreenWidth(), (long)screenSize.width);
        }
        catch (HeadlessException e) {
            this.warnHeadless();
        }
    }

    @Test
    public void testGetScreenHeight() {
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Assert.assertEquals((long)UIUtils.getScreenHeight(), (long)screenSize.height);
        }
        catch (HeadlessException e) {
            this.warnHeadless();
        }
    }

    @Test
    public void testGetUniqueFrameTitle() {
        String title = UIUtils.getUniqueFrameTitle((JInternalFrame[])new JInternalFrame[]{new JInternalFrame("Image1"), new JInternalFrame("Image2"), new JInternalFrame("Image3")}, (String)"Image");
        Assert.assertEquals((Object)"Image", (Object)title);
        title = UIUtils.getUniqueFrameTitle((JInternalFrame[])new JInternalFrame[]{new JInternalFrame("Image"), new JInternalFrame("Data"), new JInternalFrame("Raw")}, (String)"Image");
        Assert.assertEquals((Object)"Image (2)", (Object)title);
        title = UIUtils.getUniqueFrameTitle((JInternalFrame[])new JInternalFrame[]{new JInternalFrame("Image (3)"), new JInternalFrame("Data"), new JInternalFrame("Raw")}, (String)"Image");
        Assert.assertEquals((Object)"Image", (Object)title);
        title = UIUtils.getUniqueFrameTitle((JInternalFrame[])new JInternalFrame[]{new JInternalFrame("Image"), new JInternalFrame("Image (2)"), new JInternalFrame("Image (3)")}, (String)"Image");
        Assert.assertEquals((Object)"Image (4)", (Object)title);
        title = UIUtils.getUniqueFrameTitle((JInternalFrame[])new JInternalFrame[]{new JInternalFrame("Image"), new JInternalFrame("Image (2)"), new JInternalFrame("Image (4)")}, (String)"Image");
        Assert.assertEquals((Object)"Image (3)", (Object)title);
        title = UIUtils.getUniqueFrameTitle((JInternalFrame[])new JInternalFrame[]{new JInternalFrame("Image"), new JInternalFrame("Image (1)"), new JInternalFrame("Image (2)"), new JInternalFrame("Image (3)")}, (String)"Image");
        Assert.assertEquals((Object)"Image (4)", (Object)title);
    }

    @Test
    public void testCreateSpinner_WithParameter() {
        String labelname = "paramLabel";
        ParamProperties properties = new ParamProperties(Integer.class, (Object)3);
        properties.setLabel("paramLabel");
        Parameter parameter = new Parameter("paramName", properties);
        JSpinner spinner = UIUtils.createSpinner((Parameter)parameter, (Number)10, (String)"#0");
        Assert.assertEquals((Object)"paramLabel", (Object)spinner.getName());
    }

    private void warnHeadless() {
        System.out.println("A " + UIUtilsTest.class + " test has not been performed: HeadlessException");
    }
}

