/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product.spectrum;

import com.bc.ceres.core.Assert;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.ui.product.spectrum.Spectrum;
import org.esa.snap.ui.product.spectrum.SpectrumBand;
import org.esa.snap.ui.product.spectrum.SpectrumShapeProvider;
import org.esa.snap.ui.product.spectrum.SpectrumStrokeProvider;

public class DisplayableSpectrum
implements Spectrum {
    public static final String NO_UNIT = "";
    public static final String MIXED_UNITS = "mixed units";
    public static final String DEFAULT_SPECTRUM_NAME = "Bands";
    public static final String REMAINING_BANDS_NAME = "Other";
    private List<SpectrumBand> bands;
    private String name;
    private Stroke lineStyle;
    private int symbolIndex;
    private int symbolSize;
    private boolean isSelected;
    private String unit;

    public DisplayableSpectrum(String spectrumName, int symbolIndex) {
        this(spectrumName, new SpectrumBand[0], symbolIndex);
    }

    public DisplayableSpectrum(String spectrumName, SpectrumBand[] spectralBands, int symbolIndex) {
        this.name = spectrumName;
        this.bands = new ArrayList<SpectrumBand>(spectralBands.length);
        this.symbolIndex = symbolIndex;
        this.symbolSize = 3;
        this.unit = NO_UNIT;
        for (SpectrumBand spectralBand : spectralBands) {
            this.addBand(spectralBand);
        }
        this.setSelected(true);
    }

    public void addBand(SpectrumBand band) {
        Assert.notNull((Object)band);
        this.bands.add(band);
        if (band.isSelected()) {
            this.setSelected(true);
        }
        this.updateUnit();
    }

    public Shape getScaledShape() {
        return SpectrumShapeProvider.getScaledShape(this.getSymbolIndex(), this.getSymbolSize());
    }

    public boolean isDefaultOrRemainingBandsSpectrum() {
        return this.isRemainingBandsSpectrum() || this.name.equals(DEFAULT_SPECTRUM_NAME);
    }

    public boolean isRemainingBandsSpectrum() {
        return this.name.equals(REMAINING_BANDS_NAME);
    }

    @Override
    public boolean hasBands() {
        return !this.bands.isEmpty();
    }

    public boolean hasSelectedBands() {
        for (SpectrumBand band : this.bands) {
            if (!band.isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Band[] getSpectralBands() {
        Band[] spectralBands = new Band[this.bands.size()];
        for (int i = 0; i < this.bands.size(); ++i) {
            spectralBands[i] = this.bands.get(i).getOriginalBand();
        }
        return spectralBands;
    }

    public Band[] getSelectedBands() {
        ArrayList<Band> selectedBands = new ArrayList<Band>();
        for (SpectrumBand band : this.bands) {
            if (!band.isSelected()) continue;
            selectedBands.add(band.getOriginalBand());
        }
        return selectedBands.toArray(new Band[selectedBands.size()]);
    }

    public void setBandSelected(int index, boolean selected) {
        this.bands.get(index).setSelected(selected);
    }

    public boolean isBandSelected(int index) {
        return this.bands.get(index).isSelected();
    }

    public Stroke getLineStyle() {
        if (this.isRemainingBandsSpectrum()) {
            return SpectrumStrokeProvider.EMPTY_STROKE;
        }
        return this.lineStyle;
    }

    public void setLineStyle(Stroke lineStyle) {
        this.lineStyle = lineStyle;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public String getUnit() {
        return this.unit;
    }

    public int getSymbolSize() {
        return this.symbolSize;
    }

    public void setSymbolSize(int symbolSize) {
        this.symbolSize = symbolSize;
    }

    public int getSymbolIndex() {
        return this.symbolIndex;
    }

    public void setSymbolIndex(int symbolIndex) {
        this.symbolIndex = symbolIndex;
    }

    public void updateUnit() {
        if (this.bands.size() > 0) {
            this.unit = this.getUnit(this.bands.get(0));
        }
        if (this.bands.size() > 1) {
            for (int i = 1; i < this.bands.size(); ++i) {
                if (this.unit.equals(this.getUnit(this.bands.get(i)))) continue;
                this.unit = MIXED_UNITS;
                return;
            }
        }
    }

    private String getUnit(SpectrumBand band) {
        String bandUnit = band.getUnit();
        if (bandUnit == null) {
            bandUnit = NO_UNIT;
        }
        return bandUnit;
    }

    public void remove(int j) {
        this.bands.remove(j);
    }
}

