/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.binding.ValidationException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.product.InputListModel;

class AddFileAction
extends AbstractAction {
    public static final String ALL_FILES_FORMAT = "ALL_FILES";
    private final AppContext appContext;
    private final InputListModel listModel;
    private final String propertyNameLastOpenInputDir;
    private final String propertyNameLastOpenedFormat;
    private final String propertyNameFormatNames;

    AddFileAction(AppContext appContext, InputListModel listModel, String propertyNameLastOpenInputDir, String propertyNameLastOpenedFormat, String propertyNameFormatNames) {
        super("Add product file(s)...");
        this.appContext = appContext;
        this.listModel = listModel;
        this.propertyNameLastOpenInputDir = propertyNameLastOpenInputDir;
        this.propertyNameLastOpenedFormat = propertyNameLastOpenedFormat;
        this.propertyNameFormatNames = propertyNameFormatNames;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PropertyMap preferences = this.appContext.getPreferences();
        String lastDir = preferences.getPropertyString(this.propertyNameLastOpenInputDir, SystemUtils.getUserHomeDir().getPath());
        String lastFormat = preferences.getPropertyString(this.propertyNameLastOpenedFormat, ALL_FILES_FORMAT);
        String formatNames = preferences.getPropertyString(this.propertyNameFormatNames, null);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File(lastDir));
        fileChooser.setDialogTitle("Select product(s)");
        fileChooser.setMultiSelectionEnabled(true);
        FileFilter actualFileFilter = fileChooser.getAcceptAllFileFilter();
        ProductIOPlugInManager ioManager = ProductIOPlugInManager.getInstance();
        if (StringUtils.isNullOrEmpty((String)formatNames)) {
            Iterator allReaderPlugIns = ioManager.getAllReaderPlugIns();
            List sortedFileFilters = SnapFileFilter.getSortedFileFilters((Iterator)allReaderPlugIns);
            Iterator iterator = sortedFileFilters.iterator();
            while (iterator.hasNext()) {
                SnapFileFilter productFileFilter = (SnapFileFilter)iterator.next();
                fileChooser.addChoosableFileFilter((FileFilter)productFileFilter);
                String formatName = productFileFilter.getFormatName();
                if (ALL_FILES_FORMAT.equals(lastFormat) || formatName == null || !formatName.equals(lastFormat)) continue;
                actualFileFilter = productFileFilter;
            }
        } else {
            String[] formats = StringUtils.csvToArray((String)formatNames);
            for (String format : formats) {
                Iterator readerPlugIns = ioManager.getReaderPlugIns(format);
                while (readerPlugIns.hasNext()) {
                    ProductReaderPlugIn next = (ProductReaderPlugIn)readerPlugIns.next();
                    SnapFileFilter productFileFilter = next.getProductFileFilter();
                    fileChooser.addChoosableFileFilter((FileFilter)productFileFilter);
                    String formatName = productFileFilter.getFormatName();
                    if (formatName == null || !formatName.equals(lastFormat)) continue;
                    actualFileFilter = productFileFilter;
                }
            }
        }
        fileChooser.setFileFilter(actualFileFilter);
        int result = fileChooser.showDialog(this.appContext.getApplicationWindow(), "Select product(s)");
        if (result != 0) {
            return;
        }
        preferences.setPropertyString(this.propertyNameLastOpenInputDir, fileChooser.getCurrentDirectory().getAbsolutePath());
        Object[] selectedProducts = fileChooser.getSelectedFiles();
        try {
            this.listModel.addElements(selectedProducts);
        }
        catch (ValidationException ve) {
            this.appContext.handleError("Invalid input path", ve);
        }
        this.setLastOpenedFormat(preferences, fileChooser.getFileFilter());
    }

    private void setLastOpenedFormat(PropertyMap preferences, FileFilter fileFilter) {
        if (fileFilter instanceof SnapFileFilter) {
            String currentFormat = ((SnapFileFilter)fileFilter).getFormatName();
            if (currentFormat != null) {
                preferences.setPropertyString(this.propertyNameLastOpenedFormat, currentFormat);
            }
        } else {
            preferences.setPropertyString(this.propertyNameLastOpenedFormat, ALL_FILES_FORMAT);
        }
    }
}

