/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.geom.AffineTransform;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.DefaultPropertyMap;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.ui.product.ProductSceneImage;
import org.esa.snap.ui.product.ProductSceneView;

public class ProductSceneViewTest
extends TestCase {
    private VirtualBand r;
    private VirtualBand g;
    private VirtualBand b;

    protected void setUp() throws Exception {
        Product product = new Product("x", "y", 2, 3);
        this.r = new VirtualBand("r", 30, 2, 3, "0");
        this.g = new VirtualBand("g", 30, 2, 3, "0");
        this.b = new VirtualBand("b", 30, 2, 3, "0");
        product.addBand((Band)this.r);
        product.addBand((Band)this.g);
        product.addBand((Band)this.b);
        this.r.ensureRasterData();
        this.g.ensureRasterData();
        this.b.ensureRasterData();
    }

    protected void tearDown() throws Exception {
        this.r = null;
        this.g = null;
        this.b = null;
    }

    public void testIsRGB() {
        ProductSceneView view = new ProductSceneView(new ProductSceneImage((RasterDataNode)this.r, (PropertyMap)new DefaultPropertyMap(), ProgressMonitor.NULL));
        ProductSceneViewTest.assertFalse((boolean)view.isRGB());
        view = new ProductSceneView(new ProductSceneImage("RGB", (RasterDataNode)this.r, (RasterDataNode)this.g, (RasterDataNode)this.b, (PropertyMap)new DefaultPropertyMap(), ProgressMonitor.NULL));
        ProductSceneViewTest.assertTrue((boolean)view.isRGB());
    }

    public void testDispose() {
        ProductSceneView view = new ProductSceneView(new ProductSceneImage((RasterDataNode)this.r, (PropertyMap)new DefaultPropertyMap(), ProgressMonitor.NULL));
        view.dispose();
        ProductSceneViewTest.assertNull((Object)view.getSceneImage());
    }

    public void testAffineTransformReplacesManualCalculation() {
        double modelOffsetX = 37.8;
        double modelOffsetY = -54.1;
        double viewScale = 2.5;
        AffineTransform transform = new AffineTransform();
        transform.scale(viewScale, viewScale);
        transform.translate(-modelOffsetX, -modelOffsetY);
        double modelX = 10.4;
        double modelY = 2.9;
        double viewX = (modelX - modelOffsetX) * viewScale;
        double viewY = (modelY - modelOffsetY) * viewScale;
        double[] result = new double[2];
        transform.transform(new double[]{modelX, modelY}, 0, result, 0, 1);
        ProductSceneViewTest.assertEquals((double)viewX, (double)result[0], (double)1.0E-10);
        ProductSceneViewTest.assertEquals((double)viewY, (double)result[1], (double)1.0E-10);
    }
}

