/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.ValidationException;
import java.io.File;
import java.util.ArrayList;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.ui.product.InputListModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InputFilesListModelTest {
    private InputListModel listModel;
    private Property property;

    @Before
    public void setUp() {
        this.property = Property.create((String)"property", String[].class);
        this.property.setContainer(new PropertyContainer());
        this.listModel = new InputListModel();
        this.listModel.setProperty(this.property);
    }

    @Test
    public void testAddAndRemove() throws ValidationException {
        this.listModel.addElements(new Object[]{new File(".")});
        this.listModel.addElements(new Object[]{new File(".")});
        junit.framework.Assert.assertEquals((int)1, (int)this.listModel.getSize());
        this.listModel.removeElementsAt(new int[]{0});
        junit.framework.Assert.assertEquals((int)0, (int)this.listModel.getSize());
        ArrayList<File> files = new ArrayList<File>();
        files.add(new File("abc"));
        files.add(new File("def"));
        files.add(new File("ghi"));
        this.listModel.addElements(files.toArray());
        junit.framework.Assert.assertEquals((int)3, (int)this.listModel.getSize());
        junit.framework.Assert.assertEquals((int)3, (int)((String[])this.property.getValue()).length);
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(new Product("abc", "meris", 10, 120));
        products.add(new Product("def", "meris", 10, 120));
        products.add(new Product("ghi", "meris", 10, 120));
        this.listModel.addElements(products.toArray());
        junit.framework.Assert.assertEquals((int)6, (int)this.listModel.getSize());
        junit.framework.Assert.assertEquals((int)3, (int)this.listModel.getSourceProducts().length);
        this.listModel.removeElementsAt(new int[]{0, 5});
        junit.framework.Assert.assertEquals((int)4, (int)this.listModel.getSize());
        junit.framework.Assert.assertEquals((int)2, (int)((String[])this.property.getValue()).length);
        junit.framework.Assert.assertEquals((int)2, (int)this.listModel.getSourceProducts().length);
    }

    @Test(expected=IllegalStateException.class)
    public void testFailingWithIllegalStateException() throws Exception {
        this.listModel.addElements(new Object[]{""});
    }

    @Test
    public void testClear() throws Exception {
        this.listModel.addElements(new Object[]{new File("abc")});
        this.listModel.addElements(new Object[]{new File("def")});
        this.listModel.addElements(new Object[]{new Product("def", "producttype", 10, 10)});
        this.listModel.addElements(new Object[]{new Product("dummy", "producttype", 10, 10)});
        junit.framework.Assert.assertEquals((int)4, (int)this.listModel.getSize());
        this.listModel.clear();
        junit.framework.Assert.assertEquals((int)0, (int)this.listModel.getSize());
        junit.framework.Assert.assertEquals((int)0, (int)this.listModel.getSourceProducts().length);
        junit.framework.Assert.assertEquals((int)0, (int)((String[])this.property.getValue()).length);
    }

    @Test
    public void testSetElements() throws ValidationException {
        Object[] elements1 = new String[]{"a", "b", "c"};
        this.listModel.setPaths((String[])elements1);
        junit.framework.Assert.assertEquals((int)3, (int)this.listModel.getSize());
        Object[] values1 = (String[])this.property.getValue();
        Assert.assertArrayEquals((Object[])elements1, (Object[])values1);
        Object[] elements2 = new String[]{"f", "s", "g", "k"};
        this.listModel.setPaths((String[])elements2);
        junit.framework.Assert.assertEquals((int)4, (int)this.listModel.getSize());
        Object[] values2 = (String[])this.property.getValue();
        Assert.assertArrayEquals((Object[])elements2, (Object[])values2);
    }

    @Test
    public void testSetPropertyEmptyDoesNotDeleteSourceProducts() throws ValidationException {
        Product product = new Product("name", "type", 1, 1);
        this.listModel.addElements(new Object[]{product});
        junit.framework.Assert.assertEquals((int)1, (int)this.listModel.getSize());
        Object[] elements1 = new String[]{"a", "b", "c"};
        this.listModel.setPaths((String[])elements1);
        junit.framework.Assert.assertEquals((int)4, (int)this.listModel.getSize());
        Object[] values1 = (String[])this.property.getValue();
        Assert.assertArrayEquals((Object[])elements1, (Object[])values1);
        this.property.setValue(null);
        junit.framework.Assert.assertEquals((int)1, (int)this.listModel.getSize());
        Assert.assertSame((Object)product, (Object)this.listModel.getElementAt(0));
    }

    @Test
    public void testExternalPropertyValueChange() throws ValidationException {
        junit.framework.Assert.assertEquals((int)0, (int)this.listModel.getSize());
        String[] values = new String[]{"h", "i"};
        this.property.setValue((Object)values);
        junit.framework.Assert.assertEquals((int)2, (int)this.listModel.getSize());
        junit.framework.Assert.assertEquals((String)"h", (String)((File)this.listModel.getElementAt(0)).getPath());
        junit.framework.Assert.assertEquals((String)"i", (String)((File)this.listModel.getElementAt(1)).getPath());
    }
}

