/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.util.prefs.Preferences;
import junit.framework.TestCase;
import org.esa.snap.ui.DummyPreferences;
import org.esa.snap.ui.UserInputHistory;

public class UserInputHistoryTest
extends TestCase {
    public UserInputHistoryTest(String name) {
        super(name);
    }

    public void testFail() {
        String propertyKey = "test.prop";
        DummyPreferences preferences = new DummyPreferences();
        ((Preferences)preferences).putInt("test.prop.length", 4);
        ((Preferences)preferences).put("test.prop.0", "0");
        ((Preferences)preferences).put("test.prop.1", "1");
        ((Preferences)preferences).put("test.prop.2", "2");
        ((Preferences)preferences).put("test.prop.3", "3");
        ((Preferences)preferences).put("test.prop.4", "4");
        UserInputHistory history = new UserInputHistory(9, "test.prop");
        UserInputHistoryTest.assertEquals((int)9, (int)history.getMaxNumEntries());
        UserInputHistoryTest.assertEquals((int)0, (int)history.getNumEntries());
        UserInputHistoryTest.assertNull((Object)history.getEntries());
        history.initBy((Preferences)preferences);
        UserInputHistoryTest.assertEquals((int)4, (int)history.getMaxNumEntries());
        UserInputHistoryTest.assertEquals((int)4, (int)history.getNumEntries());
        String[] entries = history.getEntries();
        UserInputHistoryTest.assertEquals((int)4, (int)entries.length);
        UserInputHistoryTest.assertEquals((String)"0", (String)entries[0]);
        UserInputHistoryTest.assertEquals((String)"1", (String)entries[1]);
        UserInputHistoryTest.assertEquals((String)"2", (String)entries[2]);
        UserInputHistoryTest.assertEquals((String)"3", (String)entries[3]);
        history.push("4");
        UserInputHistoryTest.assertEquals((int)4, (int)history.getMaxNumEntries());
        UserInputHistoryTest.assertEquals((int)4, (int)history.getNumEntries());
        entries = history.getEntries();
        UserInputHistoryTest.assertEquals((int)4, (int)entries.length);
        UserInputHistoryTest.assertEquals((String)"4", (String)entries[0]);
        UserInputHistoryTest.assertEquals((String)"0", (String)entries[1]);
        UserInputHistoryTest.assertEquals((String)"1", (String)entries[2]);
        UserInputHistoryTest.assertEquals((String)"2", (String)entries[3]);
        history.setMaxNumEntries(2);
        UserInputHistoryTest.assertEquals((int)2, (int)history.getMaxNumEntries());
        UserInputHistoryTest.assertEquals((int)2, (int)history.getNumEntries());
        entries = history.getEntries();
        UserInputHistoryTest.assertEquals((int)2, (int)entries.length);
        UserInputHistoryTest.assertEquals((String)"4", (String)entries[0]);
        UserInputHistoryTest.assertEquals((String)"0", (String)entries[1]);
        history.copyInto((Preferences)preferences);
        UserInputHistoryTest.assertEquals((String)"4", (String)((Preferences)preferences).get("test.prop.0", null));
        UserInputHistoryTest.assertEquals((String)"0", (String)((Preferences)preferences).get("test.prop.1", null));
        UserInputHistoryTest.assertNull((Object)((Preferences)preferences).get("test.prop.2", null));
        UserInputHistoryTest.assertNull((Object)((Preferences)preferences).get("test.prop.3", null));
        UserInputHistoryTest.assertNull((Object)((Preferences)preferences).get("test.prop.4", null));
    }
}

