/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.binding.BindingContext;
import org.esa.snap.ui.RegionSelectableWorldMapPane;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RegionSelectableWorldMapPane_BindingContextValidationTest {
    private static final String NORTH_BOUND = "northBound";
    private static final String SOUTH_BOUND = "southBound";
    private static final String WEST_BOUND = "westBound";
    private static final String EAST_BOUND = "eastBound";
    private PropertiesObject propertiesObject;
    private BindingContext bindingContext;

    @Before
    public void setUp() throws Exception {
        this.propertiesObject = new PropertiesObject();
        this.bindingContext = new BindingContext((PropertySet)PropertyContainer.createObjectBacked((Object)this.propertiesObject));
    }

    @Test
    public void testThatBindingContextMustBeNotNull() {
        try {
            RegionSelectableWorldMapPane.ensureValidBindingContext(null);
            Assert.fail((String)"should not come here");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertEquals((Object)"bindingContext must be not null", (Object)expected.getMessage());
        }
        catch (Exception notExpected) {
            Assert.fail((String)("Exception '" + notExpected.getClass().getName() + "' is not expected"));
        }
    }

    @Test
    public void testThatPropertiesObjectAreFilledWithDefaultValuesIfAllPropertyValuesAreNull() {
        this.propertiesObject.northBound = null;
        this.propertiesObject.eastBound = null;
        this.propertiesObject.southBound = null;
        this.propertiesObject.westBound = null;
        RegionSelectableWorldMapPane.ensureValidBindingContext((BindingContext)this.bindingContext);
        Assert.assertEquals((Object)75.0, (Object)this.propertiesObject.northBound);
        Assert.assertEquals((Object)30.0, (Object)this.propertiesObject.eastBound);
        Assert.assertEquals((Object)35.0, (Object)this.propertiesObject.southBound);
        Assert.assertEquals((Object)-15.0, (Object)this.propertiesObject.westBound);
    }

    @Test
    public void testValidValuesAreNotChanged() {
        this.propertiesObject.northBound = 15.0;
        this.propertiesObject.eastBound = 15.0;
        this.propertiesObject.southBound = -15.0;
        this.propertiesObject.westBound = -15.0;
        PropertyContainer objectBacked = PropertyContainer.createObjectBacked((Object)this.propertiesObject);
        RegionSelectableWorldMapPane.ensureValidBindingContext((BindingContext)new BindingContext((PropertySet)objectBacked));
        Assert.assertEquals((Object)15.0, (Object)this.propertiesObject.northBound);
        Assert.assertEquals((Object)15.0, (Object)this.propertiesObject.eastBound);
        Assert.assertEquals((Object)-15.0, (Object)this.propertiesObject.southBound);
        Assert.assertEquals((Object)-15.0, (Object)this.propertiesObject.westBound);
    }

    @Test
    public void testThatBindingContextWithoutNorthBoundPropertyThrowsIllegalArgumentException() {
        this.assertIllegalArgumentExceptionIfPropertyIsMissing(NORTH_BOUND);
    }

    @Test
    public void testThatBindingContextWithoutSouthBoundPropertyThrowsIllegalArgumentException() {
        this.assertIllegalArgumentExceptionIfPropertyIsMissing(SOUTH_BOUND);
    }

    @Test
    public void testThatBindingContextWithoutEastBoundPropertyThrowsIllegalArgumentException() {
        this.assertIllegalArgumentExceptionIfPropertyIsMissing(EAST_BOUND);
    }

    @Test
    public void testThatBindingContextWithoutWestBoundPropertyThrowsIllegalArgumentException() {
        this.assertIllegalArgumentExceptionIfPropertyIsMissing(WEST_BOUND);
    }

    @Test
    public void testThatIllegalArgumentExceptionIsThrownIfAnyPropertyValueIsInvalid() {
        this.bindingContext.getPropertySet().setValue(NORTH_BOUND, null);
        try {
            RegionSelectableWorldMapPane.ensureValidBindingContext((BindingContext)this.bindingContext);
        }
        catch (IllegalArgumentException expected) {
            Assert.assertEquals((Object)("Given geo-bounds (" + null + ", " + EAST_BOUND + ", " + SOUTH_BOUND + ", " + WEST_BOUND + " are invalid."), (Object)expected.getMessage());
        }
        catch (Exception notExpected) {
            Assert.fail((String)("Exception '" + notExpected.getClass().getName() + "' not expected"));
        }
    }

    private void assertIllegalArgumentExceptionIfPropertyIsMissing(String propertyName) {
        this.bindingContext.getPropertySet().removeProperty(this.bindingContext.getPropertySet().getProperty(propertyName));
        try {
            RegionSelectableWorldMapPane.ensureValidBindingContext((BindingContext)this.bindingContext);
            Assert.fail((String)"should not come here");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertEquals((Object)("bindingContext must contain a property named " + propertyName), (Object)expected.getMessage());
        }
        catch (Exception notExpected) {
            Assert.fail((String)("Exception '" + notExpected.getClass().getName() + "' not expected"));
        }
    }

    private static class PropertiesObject {
        private Double northBound;
        private Double eastBound;
        private Double southBound;
        private Double westBound;

        private PropertiesObject() {
        }
    }
}

