/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.binding.ComponentAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductFilter;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.Debug;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.AddDirectoryAction;
import org.esa.snap.ui.product.AddFileAction;
import org.esa.snap.ui.product.AddProductAction;
import org.esa.snap.ui.product.InputListModel;
import org.esa.snap.ui.tool.ToolButtonFactory;

public class SourceProductList
extends ComponentAdapter {
    private final AppContext appContext;
    private final InputListModel listModel;
    private final JList inputPathsList;
    private String propertyNameLastOpenInputDir;
    private String propertyNameLastOpenedFormat;
    private boolean xAxis;
    private JComponent[] components;
    private ProductFilter productFilter;
    private String defaultPattern;

    public SourceProductList(AppContext appContext) {
        this.appContext = appContext;
        this.listModel = new InputListModel();
        this.inputPathsList = this.createInputPathsList(this.listModel);
        this.propertyNameLastOpenInputDir = "org.esa.snap.core.ui.product.lastOpenInputDir";
        this.propertyNameLastOpenedFormat = "org.esa.snap.core.ui.product.lastOpenedFormat";
        this.xAxis = true;
        this.defaultPattern = null;
        this.productFilter = product -> true;
    }

    public JComponent[] getComponents() {
        if (this.components == null) {
            this.components = this.createComponents();
        }
        return this.components;
    }

    private JComponent[] createComponents() {
        JPanel listPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.inputPathsList);
        scrollPane.setPreferredSize(new Dimension(100, 50));
        listPanel.add((Component)scrollPane, "Center");
        JPanel addRemoveButtonPanel = new JPanel();
        int axis = this.xAxis ? 0 : 1;
        BoxLayout buttonLayout = new BoxLayout(addRemoveButtonPanel, axis);
        addRemoveButtonPanel.setLayout(buttonLayout);
        addRemoveButtonPanel.add(this.createAddInputButton());
        addRemoveButtonPanel.add(this.createRemoveInputButton());
        JComponent[] panels = new JPanel[]{listPanel, addRemoveButtonPanel};
        return panels;
    }

    public void clear() {
        this.listModel.clear();
    }

    public void addProduct(Product product) {
        if (product != null) {
            try {
                this.listModel.addElements(product);
            }
            catch (ValidationException ve) {
                Debug.trace((Throwable)ve);
            }
        }
    }

    public Product[] getSourceProducts() {
        return this.listModel.getSourceProducts();
    }

    private JList<Object> createInputPathsList(InputListModel inputListModel) {
        JList<Object> list = new JList<Object>(inputListModel);
        list.setCellRenderer(new SourceProductListRenderer());
        list.setSelectionMode(2);
        return list;
    }

    public void setDefaultPattern(String pattern) {
        this.defaultPattern = pattern;
    }

    private AbstractButton createAddInputButton() {
        AbstractButton addButton = ToolButtonFactory.createButton(UIUtils.loadImageIcon("icons/Plus24.gif"), false);
        addButton.addActionListener(e -> {
            JPopupMenu popup = new JPopupMenu("Add");
            Rectangle buttonBounds = addButton.getBounds();
            AddProductAction addProductAction = new AddProductAction(this.appContext, this.listModel);
            addProductAction.setProductFilter(this.productFilter);
            popup.add(addProductAction);
            popup.add(new AddFileAction(this.appContext, this.listModel, this.propertyNameLastOpenInputDir, this.propertyNameLastOpenedFormat));
            popup.add(new AddDirectoryAction(this.appContext, this.listModel, false, this.propertyNameLastOpenInputDir, this.defaultPattern));
            popup.add(new AddDirectoryAction(this.appContext, this.listModel, true, this.propertyNameLastOpenInputDir, this.defaultPattern));
            popup.show(addButton, 1, buttonBounds.height + 1);
        });
        return addButton;
    }

    private AbstractButton createRemoveInputButton() {
        AbstractButton removeButton = ToolButtonFactory.createButton(UIUtils.loadImageIcon("icons/Minus24.gif"), false);
        removeButton.addActionListener(e -> this.listModel.removeElementsAt(this.inputPathsList.getSelectedIndices()));
        return removeButton;
    }

    public void bindComponents() {
        String propertyName = this.getBinding().getPropertyName();
        Property property = this.getBinding().getContext().getPropertySet().getProperty(propertyName);
        Assert.argument((boolean)property.getType().equals(String[].class), (String)("property '" + propertyName + "' must be of type String[].class"));
        this.listModel.setProperty(property);
    }

    public void unbindComponents() {
        this.listModel.setProperty(null);
    }

    public void adjustComponents() {
    }

    public void addChangeListener(ListDataListener changeListener) {
        this.listModel.addListDataListener(changeListener);
    }

    public void removeChangeListener(ListDataListener changeListener) {
        this.listModel.removeListDataListener(changeListener);
    }

    public void addSelectionListener(ListSelectionListener selectionListener) {
        this.inputPathsList.addListSelectionListener(selectionListener);
    }

    public void removeSelectionListener(ListSelectionListener selectionListener) {
        this.inputPathsList.removeListSelectionListener(selectionListener);
    }

    public boolean isSelected(Object object) {
        return this.inputPathsList.isSelectedIndex(this.listModel.getIndexOf(object));
    }

    public void setProductFilter(ProductFilter productFilter) {
        this.productFilter = productFilter;
    }

    public void setPropertyNameLastOpenedFormat(String propertyNameLastOpenedFormat) {
        this.propertyNameLastOpenedFormat = propertyNameLastOpenedFormat;
    }

    public void setPropertyNameLastOpenInputDir(String propertyNameLastOpenInputDir) {
        this.propertyNameLastOpenInputDir = propertyNameLastOpenInputDir;
    }

    public void setXAxis(boolean xAxis) {
        this.xAxis = xAxis;
    }

    private static class SourceProductListRenderer
    extends DefaultListCellRenderer {
        private SourceProductListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = value instanceof File ? ((File)value).getAbsolutePath() : ((ProductNode)value).getDisplayName();
            label.setText(text);
            label.setToolTipText(text);
            return label;
        }
    }
}

