/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.layer;

import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import org.esa.snap.ui.layer.LayerSource;
import org.esa.snap.ui.layer.LayerSourceDescriptor;
import org.esa.snap.ui.layer.SimpleLayerSource;

public class DefaultLayerSourceDescriptor
implements LayerSourceDescriptor {
    private final String id;
    private final String name;
    private final String description;
    private final Class<? extends LayerSource> layerSourceClass;
    private final String layerTypeClassName;
    private LayerType layerType;

    public DefaultLayerSourceDescriptor(String id, String name, String description, Class<? extends LayerSource> layerSourceClass) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.layerSourceClass = layerSourceClass;
        this.layerTypeClassName = null;
    }

    public DefaultLayerSourceDescriptor(String id, String name, String description, String layerTypeClassName) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.layerTypeClassName = layerTypeClassName;
        this.layerSourceClass = null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public LayerSource createLayerSource() {
        if (this.layerSourceClass == null) {
            return new SimpleLayerSource(this.getLayerType());
        }
        try {
            return this.layerSourceClass.newInstance();
        }
        catch (Exception e) {
            String message = String.format("Could not create instance of class [%s]", this.layerSourceClass.getName());
            throw new IllegalStateException(message, e);
        }
    }

    @Override
    public synchronized LayerType getLayerType() {
        if (this.layerTypeClassName == null) {
            return null;
        }
        if (this.layerType == null) {
            try {
                return LayerTypeRegistry.getLayerType((String)this.layerTypeClassName);
            }
            catch (Exception e) {
                String message = String.format("Could not create instance of class [%s]", this.layerTypeClassName);
                throw new IllegalStateException(message, e);
            }
        }
        return this.layerType;
    }
}

