/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.core.Assert;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.LayerListener;
import com.bc.ceres.glayer.support.AbstractLayerListener;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.glayer.swing.AdjustableViewScrollPane;
import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.ViewportAware;
import com.bc.ceres.grender.support.DefaultViewport;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureChangeListener;
import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.FigureEditorAware;
import com.bc.ceres.swing.figure.FigureSelection;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.Handle;
import com.bc.ceres.swing.figure.ShapeFigure;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionContext;
import com.bc.ceres.swing.undo.UndoContext;
import com.bc.ceres.swing.undo.support.DefaultUndoContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.undo.UndoManager;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.image.ColoredMaskImageMultiLevelSource;
import org.esa.snap.core.layer.GraticuleLayer;
import org.esa.snap.core.layer.MaskCollectionLayer;
import org.esa.snap.core.layer.ProductLayerContext;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.ui.BasicView;
import org.esa.snap.ui.PixelPositionListener;
import org.esa.snap.ui.PopupMenuHandler;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductNodeView;
import org.esa.snap.ui.product.ProductSceneImage;
import org.esa.snap.ui.product.SimpleFeatureFigure;
import org.esa.snap.ui.product.VectorDataCollectionLayer;
import org.esa.snap.ui.product.VectorDataFigureEditor;
import org.esa.snap.ui.product.VectorDataLayer;
import org.esa.snap.ui.product.VectorDataLayerFilterFactory;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.opengis.referencing.operation.TransformException;
import org.openide.util.Utilities;

public class ProductSceneView
extends BasicView
implements FigureEditorAware,
ProductNodeView,
PropertyChangeListener,
ProductLayerContext,
ViewportAware {
    public static final String BASE_IMAGE_LAYER_ID = "org.esa.snap.layers.baseImage";
    public static final String NO_DATA_LAYER_ID = "org.esa.snap.layers.noData";
    public static final String VECTOR_DATA_LAYER_ID = VectorDataCollectionLayer.ID;
    public static final String MASKS_LAYER_ID = MaskCollectionLayer.ID;
    public static final String GRATICULE_LAYER_ID = "org.esa.snap.layers.graticule";
    public static final String PREFERENCE_KEY_PIXEL_BORDER_SHOWN = "pixel.border.shown";
    public static final String PREFERENCE_KEY_IMAGE_NAV_CONTROL_SHOWN = "image.navControlShown";
    public static final String PREFERENCE_KEY_IMAGE_SCROLL_BARS_SHOWN = "image.scrollBarsShown";
    public static final String PROPERTY_NAME_IMAGE_INFO = "imageInfo";
    public static final String PROPERTY_NAME_SELECTED_LAYER = "selectedLayer";
    public static final String PROPERTY_NAME_SELECTED_PIN = "selectedPin";
    public static final Color DEFAULT_IMAGE_BACKGROUND_COLOR = new Color(51, 51, 51);
    private ProductSceneImage sceneImage;
    private LayerCanvas layerCanvas;
    private final ImageLayer baseImageLayer;
    private int currentLevel = 0;
    private int currentLevelPixelX = -1;
    private int currentLevelPixelY = -1;
    private int currentPixelX = -1;
    private int currentPixelY = -1;
    private boolean pixelBorderShown;
    private boolean pixelBorderDrawn;
    private double pixelBorderViewScale;
    private final Vector<PixelPositionListener> pixelPositionListeners;
    private Layer selectedLayer;
    private ComponentAdapter layerCanvasComponentHandler;
    private LayerCanvasMouseHandler layerCanvasMouseHandler;
    private RasterChangeHandler rasterChangeHandler;
    private boolean scrollBarsShown;
    private AdjustableViewScrollPane scrollPane;
    private UndoContext undoContext;
    private VectorDataFigureEditor figureEditor;

    public ProductSceneView(ProductSceneImage sceneImage) {
        this(sceneImage, new UndoManager());
    }

    public ProductSceneView(ProductSceneImage sceneImage, UndoManager undoManager) {
        Assert.notNull((Object)sceneImage, (String)"sceneImage");
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.setBackground(DEFAULT_IMAGE_BACKGROUND_COLOR);
        this.pixelBorderShown = sceneImage.getConfiguration().getPropertyBool(PREFERENCE_KEY_PIXEL_BORDER_SHOWN, Boolean.valueOf(true));
        this.sceneImage = sceneImage;
        this.baseImageLayer = sceneImage.getBaseImageLayer();
        this.pixelBorderViewScale = 2.0;
        this.pixelPositionListeners = new Vector();
        this.undoContext = new DefaultUndoContext((Object)this, undoManager);
        DefaultViewport viewport = new DefaultViewport(ProductSceneView.isModelYAxisDown(this.baseImageLayer));
        Layer rootLayer = sceneImage.getRootLayer();
        this.layerCanvas = new LayerCanvas(rootLayer, (Viewport)viewport);
        rootLayer.addListener((LayerListener)new AbstractLayerListener(){

            public void handleLayersRemoved(Layer parentLayer, Layer[] childLayers) {
                for (Layer childLayer : childLayers) {
                    if (childLayer != ProductSceneView.this.selectedLayer) continue;
                    ProductSceneView.this.setSelectedLayer(null);
                    return;
                }
            }
        });
        boolean navControlShown = sceneImage.getConfiguration().getPropertyBool(PREFERENCE_KEY_IMAGE_NAV_CONTROL_SHOWN, Boolean.valueOf(true));
        this.layerCanvas.setNavControlShown(navControlShown);
        this.layerCanvas.setAntialiasing(true);
        this.layerCanvas.setPreferredSize(new Dimension(400, 400));
        this.layerCanvas.addOverlay((canvas, rendering) -> {
            this.figureEditor.drawFigureSelection(rendering);
            this.figureEditor.drawSelectionRectangle(rendering);
        });
        this.figureEditor = new VectorDataFigureEditor(this);
        this.figureEditor.addSelectionChangeListener((SelectionChangeListener)new PinSelectionChangeListener());
        this.scrollBarsShown = sceneImage.getConfiguration().getPropertyBool(PREFERENCE_KEY_IMAGE_SCROLL_BARS_SHOWN, Boolean.valueOf(false));
        if (this.scrollBarsShown) {
            this.scrollPane = this.createScrollPane();
            this.add((Component)this.scrollPane, "Center");
        } else {
            this.add((Component)this.layerCanvas, "Center");
        }
        this.registerLayerCanvasListeners();
        this.rasterChangeHandler = new RasterChangeHandler();
        this.getRaster().getProduct().addProductNodeListener((ProductNodeListener)this.rasterChangeHandler);
        this.setMaskOverlayEnabled(true);
        this.setName(sceneImage.getName());
        this.appyLayerProperties(sceneImage.getConfiguration());
        sceneImage.getConfiguration().addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.appyLayerProperties(this.sceneImage.getConfiguration());
    }

    public UndoContext getUndoContext() {
        return this.undoContext;
    }

    public FigureEditor getFigureEditor() {
        return this.figureEditor;
    }

    public Viewport getViewport() {
        return this.layerCanvas.getViewport();
    }

    public int getCurrentPixelX() {
        return this.currentPixelX;
    }

    public int getCurrentPixelY() {
        return this.currentPixelY;
    }

    public boolean isCurrentPixelPosValid() {
        return this.isPixelPosValid(this.currentLevelPixelX, this.currentLevelPixelY, this.currentLevel);
    }

    private AdjustableViewScrollPane createScrollPane() {
        AbstractButton zoomAllButton = ToolButtonFactory.createButton(UIUtils.loadImageIcon("icons/ZoomAll13.gif"), false);
        zoomAllButton.setFocusable(false);
        zoomAllButton.setFocusPainted(false);
        zoomAllButton.addActionListener(e -> this.getLayerCanvas().zoomAll());
        AdjustableViewScrollPane scrollPane = new AdjustableViewScrollPane((JComponent)this.layerCanvas);
        scrollPane.setBackground(DEFAULT_IMAGE_BACKGROUND_COLOR);
        scrollPane.setCornerComponent((JComponent)zoomAllButton);
        return scrollPane;
    }

    ProductSceneImage getSceneImage() {
        return this.sceneImage;
    }

    @Override
    public SelectionContext getSelectionContext() {
        return this.getFigureEditor().getSelectionContext();
    }

    public Layer getRootLayer() {
        return this.sceneImage.getRootLayer();
    }

    public Object getCoordinateReferenceSystem() {
        return this.sceneImage.getCoordinateReferenceSystem();
    }

    @Deprecated
    public LayerContext getLayerContext() {
        return this.sceneImage;
    }

    public LayerCanvas getLayerCanvas() {
        return this.layerCanvas;
    }

    @Override
    public ProductNode getVisibleProductNode() {
        if (this.isRGB()) {
            return this.getProduct();
        }
        return this.getRaster();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (this.getLayerCanvas() != null) {
            return this.getLayerCanvas().getPreferredSize();
        }
        return super.getPreferredSize();
    }

    @Override
    public JPopupMenu createPopupMenu(Component component) {
        return null;
    }

    @Override
    public JPopupMenu createPopupMenu(MouseEvent event) {
        JPopupMenu popupMenu = new JPopupMenu();
        List viewActions = Utilities.actionsForPath((String)"Context/ProductSceneView");
        for (Action action : viewActions) {
            JMenuItem menuItem = popupMenu.add(action);
            String popupText = (String)action.getValue("popupText");
            if (!StringUtils.isNotNullAndNotEmpty((String)popupText)) continue;
            menuItem.setText(popupText);
        }
        return popupMenu;
    }

    @Override
    public synchronized void dispose() {
        if (this.pixelPositionListeners != null) {
            this.pixelPositionListeners.clear();
        }
        this.deregisterLayerCanvasListeners();
        if (this.sceneImage != null) {
            this.sceneImage.getConfiguration().removePropertyChangeListener((PropertyChangeListener)this);
        }
        for (int i = 0; i < this.getSceneImage().getRasters().length; ++i) {
            RasterDataNode raster = this.getSceneImage().getRasters()[i];
            if (raster instanceof RGBChannel) {
                RGBChannel rgbChannel = (RGBChannel)raster;
                rgbChannel.dispose();
            }
            this.sceneImage.getRasters()[i] = null;
        }
        this.sceneImage = null;
        if (this.getLayerCanvas() != null) {
            SwingUtilities.invokeLater(this::disposeImageDisplayComponent);
        }
        super.dispose();
    }

    public Product getProduct() {
        return this.getRaster().getProduct();
    }

    public ProductNode getProductNode() {
        return this.getRaster();
    }

    public String getSceneName() {
        return this.getSceneImage().getName();
    }

    public ImageInfo getImageInfo() {
        return this.getSceneImage().getImageInfo();
    }

    public void setImageInfo(ImageInfo imageInfo) {
        ImageInfo oldImageInfo = this.getImageInfo();
        this.getSceneImage().setImageInfo(imageInfo);
        this.updateImage();
        this.firePropertyChange(PROPERTY_NAME_IMAGE_INFO, oldImageInfo, imageInfo);
    }

    public int getNumRasters() {
        return this.getSceneImage().getRasters().length;
    }

    public RasterDataNode getRaster(int index) {
        return this.getSceneImage().getRasters()[index];
    }

    public RasterDataNode getRaster() {
        return this.getSceneImage().getRasters()[0];
    }

    public RasterDataNode[] getRasters() {
        return this.getSceneImage().getRasters();
    }

    public void setRasters(RasterDataNode[] rasters) {
        this.getSceneImage().setRasters(rasters);
    }

    public boolean isRGB() {
        return this.getSceneImage().getRasters().length >= 3;
    }

    public boolean isNoDataOverlayEnabled() {
        Layer noDataLayer = this.getNoDataLayer(false);
        return noDataLayer != null && noDataLayer.isVisible();
    }

    public void setNoDataOverlayEnabled(boolean enabled) {
        if (this.isNoDataOverlayEnabled() != enabled) {
            this.getNoDataLayer(true).setVisible(enabled);
        }
    }

    public ImageLayer getBaseImageLayer() {
        return this.getSceneImage().getBaseImageLayer();
    }

    public boolean isGraticuleOverlayEnabled() {
        GraticuleLayer graticuleLayer = this.getGraticuleLayer(false);
        return graticuleLayer != null && graticuleLayer.isVisible();
    }

    public void setGraticuleOverlayEnabled(boolean enabled) {
        if (this.isGraticuleOverlayEnabled() != enabled) {
            this.getGraticuleLayer(true).setVisible(enabled);
        }
    }

    public boolean isPinOverlayEnabled() {
        Layer pinLayer = this.getPinLayer(false);
        return pinLayer != null && pinLayer.isVisible();
    }

    public void setPinOverlayEnabled(boolean enabled) {
        if (this.isPinOverlayEnabled() != enabled) {
            Layer layer = this.getPinLayer(true);
            layer.setVisible(enabled);
            this.setSelectedLayer(layer);
        }
    }

    public boolean isGcpOverlayEnabled() {
        Layer gcpLayer = this.getGcpLayer(false);
        return gcpLayer != null && gcpLayer.isVisible();
    }

    public void setGcpOverlayEnabled(boolean enabled) {
        if (this.isGcpOverlayEnabled() != enabled) {
            Layer layer = this.getGcpLayer(true);
            layer.setVisible(enabled);
            this.setSelectedLayer(layer);
        }
    }

    public boolean isMaskOverlayEnabled() {
        Layer layer = this.getMaskCollectionLayer(false);
        return layer != null && layer.isVisible();
    }

    public void setMaskOverlayEnabled(boolean enabled) {
        if (this.isMaskOverlayEnabled() != enabled) {
            this.getMaskCollectionLayer(true).setVisible(enabled);
        }
    }

    public void setLayersVisible(VectorDataNode ... vectorDataNodes) {
        for (VectorDataNode vectorDataNode : vectorDataNodes) {
            LayerFilter nodeFilter = VectorDataLayerFilterFactory.createNodeFilter(vectorDataNode);
            Layer vectorDataLayer = LayerUtils.getChildLayer((Layer)this.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)nodeFilter);
            if (vectorDataLayer == null) continue;
            vectorDataLayer.setVisible(true);
        }
    }

    public ShapeFigure getCurrentShapeFigure() {
        FigureSelection figureSelection = this.getFigureEditor().getFigureSelection();
        if (figureSelection.getFigureCount() > 0) {
            Figure figure = figureSelection.getFigure(0);
            if (figure instanceof ShapeFigure) {
                return (ShapeFigure)figure;
            }
        } else {
            Figure figure;
            VectorDataLayer vectorDataLayer;
            String typeName;
            VectorDataLayer vectorLayer;
            Layer layer = null;
            Layer selLayer = this.getSelectedLayer();
            if (selLayer instanceof VectorDataLayer && (vectorLayer = (VectorDataLayer)selLayer).getVectorDataNode() != null && "org.esa.snap.Geometry".equals(typeName = vectorLayer.getVectorDataNode().getFeatureType().getTypeName())) {
                layer = vectorLayer;
            }
            if (layer == null) {
                layer = LayerUtils.getChildLayer((Layer)this.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (LayerFilter)VectorDataLayerFilterFactory.createGeometryFilter());
            }
            if (layer != null && (vectorDataLayer = (VectorDataLayer)layer).getFigureCollection().getFigureCount() > 0 && (figure = vectorDataLayer.getFigureCollection().getFigure(0)) instanceof ShapeFigure) {
                return (ShapeFigure)figure;
            }
        }
        return null;
    }

    public void setScrollBarsShown(boolean scrollBarsShown) {
        if (scrollBarsShown != this.scrollBarsShown) {
            this.scrollBarsShown = scrollBarsShown;
            if (scrollBarsShown) {
                this.remove((Component)this.layerCanvas);
                this.scrollPane = this.createScrollPane();
                this.add((Component)this.scrollPane, "Center");
            } else {
                this.remove((Component)this.scrollPane);
                this.scrollPane = null;
                this.add((Component)this.layerCanvas, "Center");
            }
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void appyLayerProperties(PropertyMap configuration) {
        GraticuleLayer graticuleLayer;
        Layer collectionLayer;
        Layer noDataLayer;
        this.setScrollBarsShown(configuration.getPropertyBool(PREFERENCE_KEY_IMAGE_SCROLL_BARS_SHOWN, Boolean.valueOf(false)));
        this.layerCanvas.setAntialiasing(true);
        this.layerCanvas.setNavControlShown(configuration.getPropertyBool(PREFERENCE_KEY_IMAGE_NAV_CONTROL_SHOWN, Boolean.valueOf(true)).booleanValue());
        this.layerCanvas.setBackground(configuration.getPropertyColor("image.background.color", DEFAULT_IMAGE_BACKGROUND_COLOR));
        ImageLayer imageLayer = this.getBaseImageLayer();
        if (imageLayer != null) {
            ProductSceneImage.applyBaseImageLayerStyle(configuration, (Layer)imageLayer);
        }
        if ((noDataLayer = this.getNoDataLayer(false)) != null) {
            ProductSceneImage.applyNoDataLayerStyle(configuration, noDataLayer);
        }
        if ((collectionLayer = this.getVectorDataCollectionLayer(false)) != null) {
            ProductSceneImage.applyFigureLayerStyle(configuration, collectionLayer);
        }
        if ((graticuleLayer = this.getGraticuleLayer(false)) != null) {
            ProductSceneImage.applyGraticuleLayerStyle(configuration, (Layer)graticuleLayer);
        }
    }

    public final void addPixelPositionListener(PixelPositionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.pixelPositionListeners.contains(listener)) {
            return;
        }
        this.pixelPositionListeners.add(listener);
    }

    public final void removePixelPositionListener(PixelPositionListener listener) {
        if (listener == null || this.pixelPositionListeners.isEmpty()) {
            return;
        }
        this.pixelPositionListeners.remove(listener);
    }

    public Layer getSelectedLayer() {
        return this.selectedLayer;
    }

    public void setSelectedLayer(Layer layer) {
        Layer oldLayer = this.selectedLayer;
        if (oldLayer != layer) {
            this.selectedLayer = layer;
            this.firePropertyChange(PROPERTY_NAME_SELECTED_LAYER, oldLayer, this.selectedLayer);
            this.maybeUpdateFigureEditor();
        }
    }

    public VectorDataLayer selectVectorDataLayer(VectorDataNode vectorDataNode) {
        VectorDataLayerFilter layerFilter = new VectorDataLayerFilter(vectorDataNode);
        VectorDataLayer layer = (VectorDataLayer)LayerUtils.getChildLayer((Layer)this.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)layerFilter);
        if (layer != null) {
            this.setSelectedLayer(layer);
        }
        return layer;
    }

    public boolean isPinSelected(Placemark pin) {
        return this.isPlacemarkSelected(this.getProduct().getPinGroup(), pin);
    }

    public boolean isGcpSelected(Placemark gcp) {
        return this.isPlacemarkSelected(this.getProduct().getGcpGroup(), gcp);
    }

    public Placemark getSelectedPin() {
        return this.getSelectedPlacemark(this.getProduct().getPinGroup());
    }

    public Placemark[] getSelectedPins() {
        return this.getSelectedPlacemarks(this.getProduct().getPinGroup());
    }

    public Placemark[] getSelectedGcps() {
        return this.getSelectedPlacemarks(this.getProduct().getGcpGroup());
    }

    public void selectPins(Placemark[] pins) {
        this.selectPlacemarks(this.getProduct().getPinGroup(), pins);
    }

    public void selectGcps(Placemark[] gpcs) {
        this.selectPlacemarks(this.getProduct().getGcpGroup(), gpcs);
    }

    public SimpleFeatureFigure getSelectedFeatureFigure() {
        Figure[] figures;
        for (Figure figure : figures = this.figureEditor.getFigureSelection().getFigures()) {
            if (!(figure instanceof SimpleFeatureFigure)) continue;
            return (SimpleFeatureFigure)figure;
        }
        return null;
    }

    public SimpleFeatureFigure[] getSelectedFeatureFigures() {
        ArrayList<SimpleFeatureFigure> selectedFigures = new ArrayList<SimpleFeatureFigure>();
        this.collectFeatureFigures((FigureCollection)this.figureEditor.getFigureSelection(), selectedFigures);
        return selectedFigures.toArray(new SimpleFeatureFigure[selectedFigures.size()]);
    }

    public SimpleFeatureFigure[] getFeatureFigures(boolean selectedOnly) {
        ArrayList<SimpleFeatureFigure> selectedFigures = new ArrayList<SimpleFeatureFigure>();
        this.collectFeatureFigures((FigureCollection)this.figureEditor.getFigureSelection(), selectedFigures);
        if (selectedFigures.isEmpty() && !selectedOnly && this.getSelectedLayer() instanceof VectorDataLayer) {
            VectorDataLayer vectorDataLayer = (VectorDataLayer)this.getSelectedLayer();
            this.collectFeatureFigures(vectorDataLayer.getFigureCollection(), selectedFigures);
        }
        return selectedFigures.toArray(new SimpleFeatureFigure[selectedFigures.size()]);
    }

    private void collectFeatureFigures(FigureCollection figureCollection, List<SimpleFeatureFigure> selectedFigures) {
        Figure[] figures;
        for (Figure figure : figures = figureCollection.getFigures()) {
            if (!(figure instanceof SimpleFeatureFigure)) continue;
            selectedFigures.add((SimpleFeatureFigure)figure);
        }
    }

    public boolean selectPlacemarks(PlacemarkGroup placemarkGroup, Placemark[] placemarks) {
        VectorDataLayer layer = this.selectVectorDataLayer(placemarkGroup.getVectorDataNode());
        if (layer != null) {
            FigureCollection figureCollection = layer.getFigureCollection();
            Figure[] figures = figureCollection.getFigures();
            ArrayList<SimpleFeatureFigure> selectedFigures = new ArrayList<SimpleFeatureFigure>(figures.length);
            HashSet<Placemark> placemarkSet = new HashSet<Placemark>(Arrays.asList(placemarks));
            for (Figure figure : figures) {
                SimpleFeatureFigure featureFigure;
                Placemark placemark;
                if (!(figure instanceof SimpleFeatureFigure) || !placemarkSet.contains(placemark = placemarkGroup.getPlacemark((featureFigure = (SimpleFeatureFigure)figure).getSimpleFeature()))) continue;
                selectedFigures.add(featureFigure);
            }
            this.figureEditor.getFigureSelection().removeAllFigures();
            this.figureEditor.getFigureSelection().addFigures(selectedFigures.toArray(new Figure[selectedFigures.size()]));
            int selectionStage = Math.min(selectedFigures.size(), 2);
            this.figureEditor.getFigureSelection().setSelectionStage(selectionStage);
            return true;
        }
        return false;
    }

    private boolean isPlacemarkSelected(PlacemarkGroup placemarkGroup, Placemark placemark) {
        Figure[] figures;
        for (Figure figure : figures = this.figureEditor.getFigureSelection().getFigures()) {
            SimpleFeatureFigure featureFigure;
            Placemark pin;
            if (!(figure instanceof SimpleFeatureFigure) || (pin = placemarkGroup.getPlacemark((featureFigure = (SimpleFeatureFigure)figure).getSimpleFeature())) != placemark) continue;
            return true;
        }
        return false;
    }

    private Placemark getSelectedPlacemark(PlacemarkGroup placemarkGroup) {
        Figure[] figures;
        for (Figure figure : figures = this.figureEditor.getFigureSelection().getFigures()) {
            SimpleFeatureFigure featureFigure;
            Placemark placemark;
            if (!(figure instanceof SimpleFeatureFigure) || (placemark = placemarkGroup.getPlacemark((featureFigure = (SimpleFeatureFigure)figure).getSimpleFeature())) == null) continue;
            return placemark;
        }
        return null;
    }

    private Placemark[] getSelectedPlacemarks(PlacemarkGroup placemarkGroup) {
        Figure[] figures = this.figureEditor.getFigureSelection().getFigures();
        ArrayList<Placemark> selectedPlacemarks = new ArrayList<Placemark>(figures.length);
        for (Figure figure : figures) {
            SimpleFeatureFigure featureFigure;
            Placemark placemark;
            if (!(figure instanceof SimpleFeatureFigure) || (placemark = placemarkGroup.getPlacemark((featureFigure = (SimpleFeatureFigure)figure).getSimpleFeature())) == null) continue;
            selectedPlacemarks.add(placemark);
        }
        return selectedPlacemarks.toArray(new Placemark[selectedPlacemarks.size()]);
    }

    private void maybeUpdateFigureEditor() {
        if (this.selectedLayer instanceof VectorDataLayer) {
            VectorDataLayer vectorDataLayer = (VectorDataLayer)this.selectedLayer;
            this.figureEditor.vectorDataLayerSelected(vectorDataLayer);
        }
    }

    public void disposeLayers() {
        this.getSceneImage().getRootLayer().dispose();
    }

    public AffineTransform getBaseImageToViewTransform() {
        AffineTransform viewToModelTransform = this.layerCanvas.getViewport().getViewToModelTransform();
        AffineTransform modelToImageTransform = this.getBaseImageLayer().getModelToImageTransform();
        viewToModelTransform.concatenate(modelToImageTransform);
        try {
            return viewToModelTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
    }

    public Rectangle getVisibleImageBounds() {
        ImageLayer imageLayer = this.getBaseImageLayer();
        if (imageLayer != null) {
            RenderedImage image = imageLayer.getImage();
            Area imageArea = new Area(new Rectangle(0, 0, image.getWidth(), image.getHeight()));
            Area visibleImageArea = new Area(imageLayer.getModelToImageTransform().createTransformedShape(this.getVisibleModelBounds()));
            imageArea.intersect(visibleImageArea);
            return imageArea.getBounds();
        }
        return null;
    }

    public Rectangle2D getVisibleModelBounds() {
        Viewport viewport = this.layerCanvas.getViewport();
        return viewport.getViewToModelTransform().createTransformedShape(viewport.getViewBounds()).getBounds2D();
    }

    public Rectangle2D getModelBounds() {
        return this.layerCanvas.getLayer().getModelBounds();
    }

    public double getOrientation() {
        return this.layerCanvas.getViewport().getOrientation();
    }

    public double getZoomFactor() {
        return this.layerCanvas.getViewport().getZoomFactor();
    }

    public void zoom(Rectangle2D modelRect) {
        this.layerCanvas.getViewport().zoom(modelRect);
    }

    public void zoom(double x, double y, double viewScale) {
        if (viewScale > 0.0) {
            this.layerCanvas.getViewport().setZoomFactor(viewScale, x, y);
        }
    }

    public boolean synchronizeViewportIfPossible(ProductSceneView thatView) {
        RasterDataNode thisRaster = this.getRaster();
        RasterDataNode thatRaster = thatView.getRaster();
        Product thisProduct = thisRaster.getProduct();
        if (thisProduct.isSceneCrsEqualToModelCrsOf(thatRaster)) {
            Viewport thisViewport = this.layerCanvas.getViewport();
            Viewport thatViewport = thatView.layerCanvas.getViewport();
            thatViewport.setTransform(thisViewport);
            return true;
        }
        if (thisProduct == thatRaster.getProduct()) {
            Viewport thisViewport = this.layerCanvas.getViewport();
            Viewport thatViewport = thatView.layerCanvas.getViewport();
            Rectangle thisViewBounds = thisViewport.getViewBounds();
            Rectangle thisModelBounds = thisViewport.getViewToModelTransform().createTransformedShape(thisViewBounds).getBounds();
            try {
                Rectangle sceneBounds = thisRaster.getModelToSceneTransform().createTransformedShape((Shape)thisModelBounds).getBounds();
                Rectangle thatModelBounds = thatRaster.getSceneToModelTransform().createTransformedShape((Shape)sceneBounds).getBounds();
                thatViewport.zoom((Rectangle2D)thatModelBounds);
                return true;
            }
            catch (TransformException sceneBounds) {
                // empty catch block
            }
        }
        GeoCoding thisGeoCoding = thisRaster.getGeoCoding();
        GeoCoding thatGeoCoding = thatRaster.getGeoCoding();
        if (thisGeoCoding != null && thatGeoCoding != null && thisGeoCoding.canGetGeoPos() && thatGeoCoding.canGetPixelPos()) {
            Viewport thisViewport = this.layerCanvas.getViewport();
            Viewport thatViewport = thatView.layerCanvas.getViewport();
            double viewCenterX = thisViewport.getViewBounds().getCenterX();
            double viewCenterY = thisViewport.getViewBounds().getCenterY();
            Point2D.Double viewCenter = new Point2D.Double(viewCenterX, viewCenterY);
            Point2D modelCenter = thisViewport.getViewToModelTransform().transform(viewCenter, null);
            PixelPos imageCenter = new PixelPos();
            this.getBaseImageLayer().getModelToImageTransform().transform(modelCenter, (Point2D)imageCenter);
            GeoPos geoCenter = new GeoPos();
            thisGeoCoding.getGeoPos(imageCenter, geoCenter);
            thatGeoCoding.getPixelPos(geoCenter, imageCenter);
            if (imageCenter.isValid()) {
                thatView.getBaseImageLayer().getImageToModelTransform().transform((Point2D)imageCenter, modelCenter);
                thatViewport.setZoomFactor(thisViewport.getZoomFactor(), modelCenter.getX(), modelCenter.getY());
                return true;
            }
        }
        return false;
    }

    protected void disposeImageDisplayComponent() {
        this.layerCanvas.dispose();
    }

    public void updateImage() {
        this.getBaseImageLayer().regenerate();
    }

    public void updateNoDataImage() {
        String expression = this.getRaster().getValidMaskExpression();
        ImageLayer noDataLayer = (ImageLayer)this.getNoDataLayer(false);
        if (noDataLayer != null) {
            if (expression != null) {
                Color color = (Color)noDataLayer.getConfiguration().getValue("color");
                MultiLevelSource multiLevelSource = ColoredMaskImageMultiLevelSource.create((Product)this.getRaster().getProduct(), (Color)color, (String)expression, (boolean)true, (AffineTransform)this.getBaseImageLayer().getImageToModelTransform());
                noDataLayer.setMultiLevelSource(multiLevelSource);
            } else {
                noDataLayer.setMultiLevelSource(MultiLevelSource.NULL);
            }
        }
    }

    public int getFirstImageLayerIndex() {
        return this.sceneImage.getFirstImageLayerIndex();
    }

    private Layer getNoDataLayer(boolean create) {
        return this.getSceneImage().getNoDataLayer(create);
    }

    public Layer getVectorDataCollectionLayer(boolean create) {
        return this.getSceneImage().getVectorDataCollectionLayer(create);
    }

    private Layer getMaskCollectionLayer(boolean create) {
        return this.getSceneImage().getMaskCollectionLayer(create);
    }

    private GraticuleLayer getGraticuleLayer(boolean create) {
        return this.getSceneImage().getGraticuleLayer(create);
    }

    private Layer getPinLayer(boolean create) {
        return this.getSceneImage().getPinLayer(create);
    }

    private Layer getGcpLayer(boolean create) {
        return this.getSceneImage().getGcpLayer(create);
    }

    private static boolean isModelYAxisDown(ImageLayer baseImageLayer) {
        return baseImageLayer.getImageToModelTransform().getDeterminant() > 0.0;
    }

    private void registerLayerCanvasListeners() {
        this.layerCanvasComponentHandler = new LayerCanvasComponentHandler();
        this.layerCanvasMouseHandler = new LayerCanvasMouseHandler();
        this.layerCanvas.addComponentListener((ComponentListener)this.layerCanvasComponentHandler);
        this.layerCanvas.addMouseListener((MouseListener)this.layerCanvasMouseHandler);
        this.layerCanvas.addMouseMotionListener((MouseMotionListener)this.layerCanvasMouseHandler);
        this.layerCanvas.addMouseWheelListener((MouseWheelListener)this.layerCanvasMouseHandler);
        PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this);
        this.layerCanvas.addMouseListener((MouseListener)popupMenuHandler);
        this.layerCanvas.addKeyListener((KeyListener)popupMenuHandler);
    }

    private void deregisterLayerCanvasListeners() {
        this.getRaster().getProduct().removeProductNodeListener((ProductNodeListener)this.rasterChangeHandler);
        this.layerCanvas.removeComponentListener((ComponentListener)this.layerCanvasComponentHandler);
        this.layerCanvas.removeMouseListener((MouseListener)this.layerCanvasMouseHandler);
        this.layerCanvas.removeMouseMotionListener((MouseMotionListener)this.layerCanvasMouseHandler);
    }

    private boolean isPixelPosValid(int currentPixelX, int currentPixelY, int currentLevel) {
        return currentPixelX >= 0 && currentPixelX < this.baseImageLayer.getImage(currentLevel).getWidth() && currentPixelY >= 0 && currentPixelY < this.baseImageLayer.getImage(currentLevel).getHeight();
    }

    private void firePixelPosChanged(MouseEvent e, int currentPixelX, int currentPixelY, int currentLevel) {
        boolean pixelPosValid = this.isPixelPosValid(currentPixelX, currentPixelY, currentLevel);
        for (PixelPositionListener listener : this.pixelPositionListeners) {
            listener.pixelPosChanged(this.baseImageLayer, currentPixelX, currentPixelY, currentLevel, pixelPosValid, e);
        }
    }

    private void firePixelPosNotAvailable() {
        for (PixelPositionListener listener : this.pixelPositionListeners) {
            listener.pixelPosNotAvailable();
        }
    }

    private void setPixelPos(MouseEvent e, boolean showBorder) {
        if (e.getID() == 505) {
            this.currentLevelPixelX = -1;
            this.firePixelPosNotAvailable();
        } else {
            Point2D.Double p = new Point2D.Double((double)e.getX() + 0.5, (double)e.getY() + 0.5);
            Viewport viewport = this.getLayerCanvas().getViewport();
            AffineTransform v2mTransform = viewport.getViewToModelTransform();
            Point2D modelP = v2mTransform.transform(p, null);
            AffineTransform m2iTransform = this.baseImageLayer.getModelToImageTransform();
            Point2D imageP = m2iTransform.transform(modelP, null);
            this.currentPixelX = (int)Math.floor(imageP.getX());
            this.currentPixelY = (int)Math.floor(imageP.getY());
            int currentLevel = this.baseImageLayer.getLevel(viewport);
            AffineTransform m2iLevelTransform = this.baseImageLayer.getModelToImageTransform(currentLevel);
            Point2D imageLevelP = m2iLevelTransform.transform(modelP, null);
            int currentPixelX = (int)Math.floor(imageLevelP.getX());
            int currentPixelY = (int)Math.floor(imageLevelP.getY());
            if (currentPixelX != this.currentLevelPixelX || currentPixelY != this.currentLevelPixelY || currentLevel != this.currentLevel) {
                if (this.isPixelBorderDisplayEnabled() && (showBorder || this.pixelBorderDrawn)) {
                    this.drawPixelBorder(currentPixelX, currentPixelY, currentLevel, showBorder);
                }
                this.currentLevelPixelX = currentPixelX;
                this.currentLevelPixelY = currentPixelY;
                this.currentLevel = currentLevel;
                this.firePixelPosChanged(e, this.currentLevelPixelX, this.currentLevelPixelY, this.currentLevel);
            }
        }
    }

    private boolean isPixelBorderDisplayEnabled() {
        return this.pixelBorderShown && this.getLayerCanvas().getViewport().getZoomFactor() >= this.pixelBorderViewScale;
    }

    private void drawPixelBorder(int currentPixelX, int currentPixelY, int currentLevel, boolean showBorder) {
        Graphics g = this.getGraphics();
        g.setXORMode(Color.white);
        if (this.pixelBorderDrawn) {
            this.drawPixelBorder(g, this.currentLevelPixelX, this.currentLevelPixelY, this.currentLevel);
            this.pixelBorderDrawn = false;
        }
        if (showBorder) {
            this.drawPixelBorder(g, currentPixelX, currentPixelY, currentLevel);
            this.pixelBorderDrawn = true;
        }
        g.setPaintMode();
        g.dispose();
    }

    private void drawPixelBorder(Graphics g, int x, int y, int l) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform i2m = this.getBaseImageLayer().getImageToModelTransform(l);
            AffineTransform m2v = this.getLayerCanvas().getViewport().getModelToViewTransform();
            Rectangle imageRect = new Rectangle(x, y, 1, 1);
            Shape modelRect = i2m.createTransformedShape(imageRect);
            Shape transformedShape = m2v.createTransformedShape(modelRect);
            g2d.draw(transformedShape);
        }
    }

    private class PinSelectionChangeListener
    extends AbstractSelectionChangeListener {
        private boolean firedNoPinSelected = false;

        private PinSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangeEvent event) {
            Selection selection = event.getSelection();
            if (selection.isEmpty()) {
                if (!this.firedNoPinSelected) {
                    ProductSceneView.this.firePropertyChange(ProductSceneView.PROPERTY_NAME_SELECTED_PIN, null, null);
                    this.firedNoPinSelected = true;
                }
            } else {
                Object selectedValue = selection.getSelectedValue();
                if (selectedValue instanceof SimpleFeatureFigure) {
                    SimpleFeatureFigure featureFigure = (SimpleFeatureFigure)selectedValue;
                    PlacemarkGroup pinGroup = ProductSceneView.this.getProduct().getPinGroup();
                    Placemark pin = pinGroup.getPlacemark(featureFigure.getSimpleFeature());
                    if (pin != null) {
                        ProductSceneView.this.firePropertyChange(ProductSceneView.PROPERTY_NAME_SELECTED_PIN, null, pin);
                        this.firedNoPinSelected = false;
                    }
                }
            }
        }
    }

    private static class VectorDataLayerFilter
    implements LayerFilter {
        private final VectorDataNode vectorDataNode;

        public VectorDataLayerFilter(VectorDataNode vectorDataNode) {
            this.vectorDataNode = vectorDataNode;
        }

        public boolean accept(Layer layer) {
            return layer instanceof VectorDataLayer && ((VectorDataLayer)layer).getVectorDataNode() == this.vectorDataNode;
        }
    }

    static class NullFigureCollection
    implements FigureCollection {
        static final FigureCollection INSTANCE = new NullFigureCollection();

        private NullFigureCollection() {
        }

        public boolean isCollection() {
            return false;
        }

        public boolean contains(Figure figure) {
            return false;
        }

        public boolean isCloseTo(Point2D point, AffineTransform m2v) {
            return false;
        }

        public Rectangle2D getBounds() {
            return new Rectangle();
        }

        public Figure.Rank getRank() {
            return Figure.Rank.NOT_SPECIFIED;
        }

        public void move(double dx, double dy) {
        }

        public void scale(Point2D point, double sx, double sy) {
        }

        public void rotate(Point2D point, double theta) {
        }

        public double[] getSegment(int index) {
            return null;
        }

        public void setSegment(int index, double[] segment) {
        }

        public void addSegment(int index, double[] segment) {
        }

        public void removeSegment(int index) {
        }

        public boolean isSelectable() {
            return false;
        }

        public boolean isSelected() {
            return false;
        }

        public void setSelected(boolean selected) {
        }

        public void draw(Rendering rendering) {
        }

        public int getFigureCount() {
            return 0;
        }

        public int getFigureIndex(Figure figure) {
            return 0;
        }

        public Figure getFigure(int index) {
            return null;
        }

        public Figure getFigure(Point2D point, AffineTransform m2v) {
            return null;
        }

        public Figure[] getFigures() {
            return new Figure[0];
        }

        public Figure[] getFigures(Shape shape) {
            return new Figure[0];
        }

        public boolean addFigure(Figure figure) {
            return false;
        }

        public boolean addFigure(int index, Figure figure) {
            return false;
        }

        public Figure[] addFigures(Figure ... figures) {
            return new Figure[0];
        }

        public boolean removeFigure(Figure figure) {
            return false;
        }

        public Figure[] removeFigures(Figure ... figures) {
            return new Figure[0];
        }

        public Figure[] removeAllFigures() {
            return new Figure[0];
        }

        public int getMaxSelectionStage() {
            return 0;
        }

        public Handle[] createHandles(int selectionStage) {
            return new Handle[0];
        }

        public void addChangeListener(FigureChangeListener listener) {
        }

        public void removeChangeListener(FigureChangeListener listener) {
        }

        public FigureChangeListener[] getChangeListeners() {
            return new FigureChangeListener[0];
        }

        public void dispose() {
        }

        public Object createMemento() {
            return null;
        }

        public void setMemento(Object memento) {
        }

        public FigureStyle getNormalStyle() {
            return null;
        }

        public void setNormalStyle(FigureStyle normalStyle) {
        }

        public FigureStyle getSelectedStyle() {
            return null;
        }

        public void setSelectedStyle(FigureStyle selectedStyle) {
        }

        public FigureStyle getEffectiveStyle() {
            return null;
        }

        public Object clone() {
            return INSTANCE;
        }
    }

    private class LayerCanvasComponentHandler
    extends ComponentAdapter {
        private LayerCanvasComponentHandler() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            ProductSceneView.this.firePixelPosNotAvailable();
        }
    }

    private final class LayerCanvasMouseHandler
    implements MouseInputListener,
    MouseWheelListener {
        private LayerCanvasMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.updatePixelPos(e, false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.updatePixelPos(e, false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.updatePixelPos(e, false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.updatePixelPos(e, false);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.updatePixelPos(e, false);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.updatePixelPos(e, true);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.updatePixelPos(e, true);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.isAltDown() || e.isAltGraphDown() || e.isControlDown() || e.isShiftDown()) {
                return;
            }
            Viewport viewport = ProductSceneView.this.layerCanvas.getViewport();
            int wheelRotation = e.getWheelRotation();
            double oldZoomFactor = viewport.getZoomFactor();
            double newZoomFactor = oldZoomFactor * Math.pow(1.1, wheelRotation);
            viewport.setZoomFactor(newZoomFactor);
        }

        private void updatePixelPos(MouseEvent e, boolean showBorder) {
            ProductSceneView.this.setPixelPos(e, showBorder);
        }
    }

    private final class RasterChangeHandler
    implements ProductNodeListener {
        private RasterChangeHandler() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            this.repaintView();
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            this.repaintView();
        }

        public void nodeAdded(ProductNodeEvent event) {
            this.repaintView();
        }

        public void nodeRemoved(ProductNodeEvent event) {
            this.repaintView();
        }

        private void repaintView() {
            ProductSceneView.this.repaint(100L);
        }
    }

    public static class RGBChannel
    extends VirtualBand {
        public RGBChannel(Product product, int width, int height, String name, String expression) {
            super(name, 30, width, height, expression);
            this.setOwner((ProductNode)product);
            this.setModified(false);
        }

        public RGBChannel(Product product, String name, String expression) {
            this(product, product.getSceneRasterWidth(), product.getSceneRasterHeight(), name, expression);
        }
    }
}

