/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.io;

import java.io.IOException;
import java.io.Writer;
import javax.swing.table.TableModel;
import org.esa.snap.core.util.io.CsvWriter;
import org.esa.snap.ui.io.CsvEncoder;

public class TableModelCsvEncoder
implements CsvEncoder {
    private final TableModel model;

    public TableModelCsvEncoder(TableModel model) {
        this.model = model;
    }

    @Override
    public void encodeCsv(Writer writer) throws IOException {
        CsvWriter csv = new CsvWriter(writer, "\t");
        this.encodeHeadline(csv);
        this.encodeData(csv);
    }

    private void encodeHeadline(CsvWriter csv) throws IOException {
        int count = this.model.getColumnCount();
        String[] colNames = new String[count];
        for (int col = 0; col < count; ++col) {
            colNames[col] = this.model.getColumnName(col);
        }
        csv.writeRecord(colNames);
    }

    private void encodeData(CsvWriter csv) throws IOException {
        int columnCount = this.model.getColumnCount();
        int rowCount = this.model.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            String[] record = new String[columnCount];
            for (int column = 0; column < columnCount; ++column) {
                Object value = this.model.getValueAt(row, column);
                record[column] = value != null ? value.toString() : "";
            }
            csv.writeRecord(record);
        }
    }
}

