/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;

public class FileArrayEditor {
    private static final Dimension LIST_PREFERRED_SIZE = new Dimension(500, 200);
    private JPanel basePanel;
    private JFileChooser fileDialog;
    private FileArrayEditorListener listener;
    private final JList<File> listComponent;
    private final List<File> fileList;
    private final EditorParent parent;
    private final String label;

    public FileArrayEditor(EditorParent parent, String label) {
        Guardian.assertNotNullOrEmpty((String)"label", (String)label);
        this.parent = parent;
        this.label = label;
        this.fileList = new ArrayList<File>();
        this.listComponent = new JList();
        this.setName(this.listComponent, this.label);
    }

    protected final EditorParent getParent() {
        return this.parent;
    }

    public JComponent getUI() {
        if (this.basePanel == null) {
            this.createUI();
        }
        return this.basePanel;
    }

    public void setFiles(List<File> files) {
        Guardian.assertNotNull((String)"files", files);
        this.fileList.clear();
        this.fileList.addAll(files);
        this.listComponent.setListData((File[])this.fileList.toArray(new File[this.fileList.size()]));
        this.notifyListener();
    }

    public List<File> getFiles() {
        return this.fileList;
    }

    public void setListener(FileArrayEditorListener listener) {
        this.listener = listener;
    }

    private void createUI() {
        JLabel label = new JLabel(this.label + ":");
        this.setName(label, this.label);
        JComponent scrollPane = this.createFileArrayComponent();
        JButton addButton = this.createAddFileButton();
        JButton removeButton = this.createRemoveFileButton();
        JPanel buttonPanel = new JPanel();
        this.setName(buttonPanel, this.label);
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        this.basePanel = GridBagUtils.createDefaultEmptyBorderPanel();
        this.setName(this.basePanel, this.label);
        GridBagConstraints gbc = GridBagUtils.createConstraints(null);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        ++gbc.gridy;
        this.basePanel.add((Component)label, gbc);
        gbc.anchor = 13;
        this.basePanel.add((Component)buttonPanel, gbc);
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.basePanel.add((Component)scrollPane, gbc);
    }

    public JButton createRemoveFileButton() {
        JButton removeButton = (JButton)ToolButtonFactory.createButton(UIUtils.loadImageIcon("icons/Minus16.gif"), false);
        this.setName(removeButton, "removeButton");
        removeButton.addActionListener(e -> this.onRemoveButton());
        return removeButton;
    }

    public JButton createAddFileButton() {
        JButton addButton = (JButton)ToolButtonFactory.createButton(UIUtils.loadImageIcon("icons/Plus16.gif"), false);
        this.setName(addButton, "addButton");
        addButton.addActionListener(e -> this.onAddButton());
        return addButton;
    }

    public JComponent createFileArrayComponent() {
        JScrollPane scrollPane = new JScrollPane(this.listComponent);
        this.setName(scrollPane, this.label);
        scrollPane.setPreferredSize(LIST_PREFERRED_SIZE);
        return scrollPane;
    }

    private void setName(Component comp, String name) {
        comp.setName(name);
    }

    private void onAddButton() {
        this.fileDialog = this.getFileDialogSafe();
        File userInputDir = this.parent.getUserInputDir();
        this.fileDialog.setCurrentDirectory(userInputDir);
        int retVal = this.fileDialog.showOpenDialog(this.basePanel);
        if (retVal == 0) {
            File[] selected = this.fileDialog.getSelectedFiles();
            this.fileList.addAll(Arrays.asList(selected));
            this.listComponent.setListData((File[])this.fileList.toArray(new File[this.fileList.size()]));
            this.notifyListener();
            this.parent.setUserInputDir(this.fileDialog.getCurrentDirectory());
        }
    }

    private void onRemoveButton() {
        List<File> selectedFiles = this.listComponent.getSelectedValuesList();
        selectedFiles.forEach(this.fileList::remove);
        this.listComponent.setListData((File[])this.fileList.toArray(new File[this.fileList.size()]));
        this.notifyListener();
    }

    private JFileChooser getFileDialogSafe() {
        if (this.fileDialog == null) {
            this.fileDialog = this.createFileChooserDialog();
        }
        return this.fileDialog;
    }

    protected JFileChooser createFileChooserDialog() {
        SnapFileChooser chooser = new SnapFileChooser();
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setMultiSelectionEnabled(true);
        Iterator iterator = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
        List sortedFileFilters = SnapFileFilter.getSortedFileFilters((Iterator)iterator);
        sortedFileFilters.forEach(chooser::addChoosableFileFilter);
        chooser.setFileFilter(chooser.getAcceptAllFileFilter());
        return chooser;
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.updatedList(this.fileList.toArray(new File[this.fileList.size()]));
        }
    }

    public static interface FileArrayEditorListener {
        public void updatedList(File[] var1);
    }

    public static interface EditorParent {
        public File getUserInputDir();

        public void setUserInputDir(File var1);
    }
}

