/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.crs.projdef;

import javax.measure.unit.Unit;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.ui.crs.projdef.AbstractUTMCrsProvider;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.operation.projection.TransverseMercator;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.OperationMethod;

class UTMZonesCrsProvider
extends AbstractUTMCrsProvider {
    private static final String NAME = "UTM Zone";
    private static final Citation BEAM = Citations.fromName((String)"BEAM");
    private static final String NORTH_HEMISPHERE = "North";
    private static final String SOUTH_HEMISPHERE = "South";
    private static final String ZONE_NAME = "zone";
    private static final String HEMISPHERE_NAME = "hemisphere";
    private static final ParameterDescriptor[] DESCRIPTORS = new ParameterDescriptor[]{new DefaultParameterDescriptor(BEAM, "zone", Integer.class, null, (Object)1, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(60), Unit.ONE, true), new DefaultParameterDescriptor("hemisphere", String.class, (Object[])new String[]{"North", "South"}, (Object)"North")};
    private static final ParameterDescriptorGroup UTM_PARAMETERS = new DefaultParameterDescriptorGroup("UTM Zone", (GeneralParameterDescriptor[])DESCRIPTORS);

    UTMZonesCrsProvider(GeodeticDatum wgs84Datum) {
        super(NAME, true, true, wgs84Datum);
    }

    @Override
    public ParameterValueGroup getParameter() {
        return UTM_PARAMETERS.createValue();
    }

    @Override
    public CoordinateReferenceSystem getCRS(GeoPos referencePos, ParameterValueGroup parameters, GeodeticDatum datum) throws FactoryException {
        int zoneIndex = parameters.parameter(ZONE_NAME).intValue();
        String hemisphere1 = parameters.parameter(HEMISPHERE_NAME).stringValue();
        boolean south = SOUTH_HEMISPHERE.equals(hemisphere1);
        ParameterValueGroup tmParameters = this.createTransverseMercatorParameters(zoneIndex, south, datum);
        return this.createCrs(UTMZonesCrsProvider.getProjectionName(zoneIndex, south), (OperationMethod)new TransverseMercator.Provider(), tmParameters, datum);
    }
}

