/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product.metadata;

import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.ui.product.metadata.MetadataElementInnerNode;
import org.esa.snap.ui.product.metadata.MetadataTableElement;
import org.esa.snap.ui.product.metadata.MetadataTableLeaf;
import org.openide.nodes.AbstractNode;

public class MetadataTableInnerElement
implements MetadataTableElement {
    private final MetadataElement metadataElement;
    private final MetadataTableElement[] metadataTableElements;

    public MetadataTableInnerElement(MetadataElement metadataElement) {
        this.metadataElement = metadataElement;
        this.metadataTableElements = MetadataTableInnerElement.getChildrenElementsFromElement(metadataElement);
    }

    @Override
    public MetadataTableElement[] getMetadataTableElements() {
        return this.metadataTableElements;
    }

    @Override
    public String getName() {
        return this.metadataElement.getName();
    }

    @Override
    public AbstractNode createNode() {
        return new MetadataElementInnerNode(this);
    }

    private static MetadataTableElement[] getChildrenElementsFromElement(MetadataElement metadataElement) {
        MetadataElement[] elements = metadataElement.getElements();
        MetadataAttribute[] attributes = metadataElement.getAttributes();
        ArrayList<MetadataTableElement> metadataTableElementList = new ArrayList<MetadataTableElement>();
        for (MetadataElement metadataElement2 : elements) {
            metadataTableElementList.add(new MetadataTableInnerElement(metadataElement2));
        }
        for (MetadataElement metadataElement3 : attributes) {
            long dataElemSize = metadataElement3.getNumDataElems();
            if (dataElemSize > 1L) {
                Object dataElems = metadataElement3.getDataElems();
                int dataType = metadataElement3.getDataType();
                if (ProductData.isFloatingPointType((int)dataType)) {
                    if (dataElems instanceof float[]) {
                        MetadataTableInnerElement.addFloatMetadataAttributes((MetadataAttribute)metadataElement3, (float[])dataElems, metadataTableElementList);
                        continue;
                    }
                    MetadataTableInnerElement.addDoubleMetadataAttributes((MetadataAttribute)metadataElement3, (double[])dataElems, metadataTableElementList);
                    continue;
                }
                if (ProductData.isIntType((int)dataType)) {
                    if (dataElems instanceof byte[]) {
                        MetadataTableInnerElement.addByteMetadataAttributes((MetadataAttribute)metadataElement3, (byte[])dataElems, metadataTableElementList);
                        continue;
                    }
                    if (dataElems instanceof short[]) {
                        MetadataTableInnerElement.addShortMetadataAttributes((MetadataAttribute)metadataElement3, (short[])dataElems, metadataTableElementList);
                        continue;
                    }
                    MetadataTableInnerElement.addIntMetadataAttributes((MetadataAttribute)metadataElement3, (int[])dataElems, metadataTableElementList);
                    continue;
                }
                metadataTableElementList.add(new MetadataTableLeaf((MetadataAttribute)metadataElement3));
                continue;
            }
            metadataTableElementList.add(new MetadataTableLeaf((MetadataAttribute)metadataElement3));
        }
        return metadataTableElementList.toArray(new MetadataTableElement[metadataTableElementList.size()]);
    }

    private static void addFloatMetadataAttributes(MetadataAttribute attribute, float[] elems, List<MetadataTableElement> metadataTableElementList) {
        String name = attribute.getName();
        String unit = attribute.getUnit();
        int dataType = attribute.getDataType();
        String description = attribute.getDescription();
        for (int j = 0; j < elems.length; ++j) {
            MetadataAttribute partAttribute = new MetadataAttribute(name + "." + (j + 1), dataType);
            partAttribute.setDataElems((Object)new float[]{elems[j]});
            partAttribute.setUnit(unit);
            partAttribute.setDescription(description);
            metadataTableElementList.add(new MetadataTableLeaf(partAttribute));
        }
    }

    private static void addDoubleMetadataAttributes(MetadataAttribute attribute, double[] elems, List<MetadataTableElement> metadataTableElementList) {
        String name = attribute.getName();
        String unit = attribute.getUnit();
        int dataType = attribute.getDataType();
        String description = attribute.getDescription();
        for (int j = 0; j < elems.length; ++j) {
            MetadataAttribute partAttribute = new MetadataAttribute(name + "." + (j + 1), dataType);
            partAttribute.setDataElems((Object)new double[]{elems[j]});
            partAttribute.setUnit(unit);
            partAttribute.setDescription(description);
            metadataTableElementList.add(new MetadataTableLeaf(partAttribute));
        }
    }

    private static void addByteMetadataAttributes(MetadataAttribute attribute, byte[] elems, List<MetadataTableElement> metadataTableElementList) {
        String name = attribute.getName();
        int dataType = attribute.getDataType();
        String unit = attribute.getUnit();
        String description = attribute.getDescription();
        for (int j = 0; j < elems.length; ++j) {
            MetadataAttribute partAttribute = new MetadataAttribute(name + "." + (j + 1), dataType);
            partAttribute.setDataElems((Object)new byte[]{elems[j]});
            partAttribute.setUnit(unit);
            partAttribute.setDescription(description);
            metadataTableElementList.add(new MetadataTableLeaf(partAttribute));
        }
    }

    private static void addShortMetadataAttributes(MetadataAttribute attribute, short[] elems, List<MetadataTableElement> metadataTableElementList) {
        String name = attribute.getName();
        int dataType = attribute.getDataType();
        String unit = attribute.getUnit();
        String description = attribute.getDescription();
        for (int j = 0; j < elems.length; ++j) {
            MetadataAttribute partAttribute = new MetadataAttribute(name + "." + (j + 1), dataType);
            partAttribute.setDataElems((Object)new short[]{elems[j]});
            partAttribute.setUnit(unit);
            partAttribute.setDescription(description);
            metadataTableElementList.add(new MetadataTableLeaf(partAttribute));
        }
    }

    private static void addIntMetadataAttributes(MetadataAttribute attribute, int[] elems, List<MetadataTableElement> metadataTableElementList) {
        String name = attribute.getName();
        int dataType = attribute.getDataType();
        String unit = attribute.getUnit();
        String description = attribute.getDescription();
        for (int j = 0; j < elems.length; ++j) {
            MetadataAttribute partAttribute = new MetadataAttribute(name + "." + (j + 1), dataType);
            partAttribute.setDataElems((Object)new int[]{elems[j]});
            partAttribute.setUnit(unit);
            partAttribute.setDescription(description);
            metadataTableElementList.add(new MetadataTableLeaf(partAttribute));
        }
    }
}

