/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product.metadata;

import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.ui.product.metadata.EmptyImage;
import org.esa.snap.ui.product.metadata.MetadataTableLeaf;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class MetadataElementLeafNode
extends AbstractNode {
    private MetadataTableLeaf leaf;

    public MetadataElementLeafNode(MetadataTableLeaf leaf) {
        this(leaf, new InstanceContent());
    }

    private MetadataElementLeafNode(MetadataTableLeaf leaf, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.leaf = leaf;
        content.add((Object)leaf);
        this.setName(leaf.getName());
        this.createSheet();
    }

    public Image getIcon(int type) {
        return new EmptyImage();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    protected final Sheet createSheet() {
        PropertySupport[] properties;
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        for (PropertySupport attributeProperty : properties = this.createAttributeProperties()) {
            set.put((Node.Property)attributeProperty);
        }
        sheet.put(set);
        return sheet;
    }

    private PropertySupport[] createAttributeProperties() {
        String description;
        ArrayList<PropertySupport.ReadOnly> attributePropertyList = new ArrayList<PropertySupport.ReadOnly>();
        int type = this.leaf.getDataType();
        switch (type) {
            case 12: {
                attributePropertyList.add(new IntegerProperty("Value"));
                break;
            }
            case 22: {
                attributePropertyList.add(new IntegerProperty("Value"));
                break;
            }
            case 31: {
                attributePropertyList.add(new DoubleProperty("Value"));
                break;
            }
            default: {
                attributePropertyList.add(new StringProperty("Value"));
            }
        }
        PropertySupport.ReadOnly<String> typeProperty = new PropertySupport.ReadOnly<String>("Type", String.class, "Type", null){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return ProductData.getTypeString((int)MetadataElementLeafNode.this.leaf.getDataType());
            }
        };
        attributePropertyList.add(typeProperty);
        String unit = this.leaf.getUnit();
        if (StringUtils.isNotNullAndNotEmpty((String)unit)) {
            PropertySupport.ReadOnly<String> unitProperty = new PropertySupport.ReadOnly<String>("Unit", String.class, "Unit", null){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return MetadataElementLeafNode.this.leaf.getUnit();
                }
            };
            attributePropertyList.add(unitProperty);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)(description = this.leaf.getDescription()))) {
            PropertySupport.ReadOnly<String> descriptionProperty = new PropertySupport.ReadOnly<String>("Description", String.class, "Description", null){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    return MetadataElementLeafNode.this.leaf.getDescription();
                }
            };
            attributePropertyList.add(descriptionProperty);
        }
        return attributePropertyList.toArray(new PropertySupport[attributePropertyList.size()]);
    }

    public class StringProperty
    extends PropertySupport.ReadOnly<String> {
        public StringProperty(String name) {
            super(name, String.class, name, null);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return MetadataElementLeafNode.this.leaf.getData().getElemString();
        }
    }

    public class DoubleProperty
    extends PropertySupport.ReadOnly<Double> {
        public DoubleProperty(String name) {
            super(name, Double.class, name, null);
        }

        public Double getValue() throws IllegalAccessException, InvocationTargetException {
            return MetadataElementLeafNode.this.leaf.getData().getElemDouble();
        }
    }

    public class IntegerProperty
    extends PropertySupport.ReadOnly<Integer> {
        public IntegerProperty(String name) {
            super(name, Integer.class, name, null);
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            return MetadataElementLeafNode.this.leaf.getData().getElemInt();
        }
    }
}

