/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.crs.projdef;

import java.util.HashMap;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.ui.crs.projdef.AbstractCrsProvider;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.TransverseMercator;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationMethod;

abstract class AbstractUTMCrsProvider
extends AbstractCrsProvider {
    static final int MIN_UTM_ZONE = 1;
    static final int MAX_UTM_ZONE = 60;

    AbstractUTMCrsProvider(String name, boolean hasParameters, boolean datumChangable, GeodeticDatum defaultDatum) {
        super(name, hasParameters, datumChangable, defaultDatum);
    }

    static String getProjectionName(int zoneIndex, boolean south) {
        return "UTM Zone " + zoneIndex + (south ? ", South" : "");
    }

    static int getZoneIndex(double longitude) {
        double zoneIndex = (longitude + 180.0) / 6.0 - 0.5 + 1.0;
        return (int)MathUtils.roundAndCrop((double)zoneIndex, (long)1L, (long)60L);
    }

    private static void setValue(ParameterValueGroup values, ParameterDescriptor<Double> descriptor, double value) {
        values.parameter(descriptor.getName().getCode()).setValue(value);
    }

    protected static double getCentralMeridian(int zoneIndex) {
        return ((double)zoneIndex - 0.5) * 6.0 - 180.0;
    }

    ParameterValueGroup createTransverseMercatorParameters(int zoneIndex, boolean south, GeodeticDatum datum) {
        ParameterDescriptorGroup tmParameters = new TransverseMercator.Provider().getParameters();
        ParameterValueGroup tmValues = tmParameters.createValue();
        AbstractUTMCrsProvider.setValue(tmValues, (ParameterDescriptor<Double>)MapProjection.AbstractProvider.SEMI_MAJOR, datum.getEllipsoid().getSemiMajorAxis());
        AbstractUTMCrsProvider.setValue(tmValues, (ParameterDescriptor<Double>)MapProjection.AbstractProvider.SEMI_MINOR, datum.getEllipsoid().getSemiMinorAxis());
        AbstractUTMCrsProvider.setValue(tmValues, (ParameterDescriptor<Double>)MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN, 0.0);
        AbstractUTMCrsProvider.setValue(tmValues, (ParameterDescriptor<Double>)MapProjection.AbstractProvider.CENTRAL_MERIDIAN, AbstractUTMCrsProvider.getCentralMeridian(zoneIndex));
        AbstractUTMCrsProvider.setValue(tmValues, (ParameterDescriptor<Double>)MapProjection.AbstractProvider.SCALE_FACTOR, 0.9996);
        AbstractUTMCrsProvider.setValue(tmValues, (ParameterDescriptor<Double>)MapProjection.AbstractProvider.FALSE_EASTING, 500000.0);
        AbstractUTMCrsProvider.setValue(tmValues, (ParameterDescriptor<Double>)MapProjection.AbstractProvider.FALSE_NORTHING, south ? 1.0E7 : 0.0);
        return tmValues;
    }

    CoordinateReferenceSystem createCrs(String crsName, OperationMethod method, ParameterValueGroup parameters, GeodeticDatum datum) throws FactoryException {
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        CoordinateOperationFactory coFactory = ReferencingFactoryFinder.getCoordinateOperationFactory(null);
        HashMap<String, String> projProperties = new HashMap<String, String>();
        projProperties.put("name", crsName + " / " + datum.getName().getCode());
        Conversion conversion = coFactory.createDefiningConversion(projProperties, method, parameters);
        HashMap<String, String> baseCrsProperties = new HashMap<String, String>();
        baseCrsProperties.put("name", datum.getName().getCode());
        GeographicCRS baseCrs = crsFactory.createGeographicCRS(baseCrsProperties, datum, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
        return crsFactory.createProjectedCRS(projProperties, baseCrs, conversion, (CartesianCS)DefaultCartesianCS.PROJECTED);
    }
}

