/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.crs;

import com.bc.ceres.swing.TableLayout;
import com.jidesoft.swing.LabeledTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.esa.snap.ui.crs.CrsInfo;
import org.esa.snap.ui.crs.CrsInfoListModel;
import org.esa.snap.ui.util.FilteredListModel;

class PredefinedCrsPanel
extends JPanel {
    public static final Logger LOG = Logger.getLogger(PredefinedCrsPanel.class.getName());
    private final CrsInfoListModel crsListModel;
    private JTextArea infoArea;
    private JList<CrsInfo> crsList;
    private LabeledTextField filterField;
    private CrsInfo selectedCrsInfo;
    private FilteredListModel<CrsInfo> filteredListModel;

    public static void main(String[] args) {
        JFrame frame = new JFrame("CRS Selection Panel");
        Container contentPane = frame.getContentPane();
        CrsInfoListModel listModel = new CrsInfoListModel(CrsInfo.generateCRSList());
        PredefinedCrsPanel predefinedCrsForm = new PredefinedCrsPanel(listModel);
        contentPane.add(predefinedCrsForm);
        frame.setSize(600, 400);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        SwingUtilities.invokeLater(() -> frame.setVisible(true));
    }

    PredefinedCrsPanel(CrsInfoListModel model) {
        this.crsListModel = model;
        this.createUI();
    }

    private void createUI() {
        this.filterField = new LabeledTextField();
        this.filterField.setHintText("Type here to filter CRS");
        this.filterField.getTextField().getDocument().addDocumentListener(new FilterDocumentListener());
        this.filteredListModel = new FilteredListModel<CrsInfo>(this.crsListModel);
        this.crsList = new JList<CrsInfo>(this.filteredListModel);
        this.crsList.setVisibleRowCount(15);
        this.crsList.setSelectionMode(0);
        this.crsList.setSelectedValue(this.crsListModel.getElementAt(0), true);
        JLabel filterLabel = new JLabel("Filter:");
        JLabel infoLabel = new JLabel("Well-Known Text (WKT):");
        JScrollPane crsListScrollPane = new JScrollPane(this.crsList);
        crsListScrollPane.setPreferredSize(new Dimension(200, 150));
        this.infoArea = new JTextArea(15, 30);
        this.infoArea.setEditable(false);
        this.crsList.addListSelectionListener(new CrsListSelectionListener());
        JScrollPane infoAreaScrollPane = new JScrollPane(this.infoArea);
        TableLayout tableLayout = new TableLayout(3);
        this.setLayout((LayoutManager)tableLayout);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTablePadding(4, 4);
        tableLayout.setRowWeightY(0, Double.valueOf(0.0));
        tableLayout.setCellWeightX(0, 0, Double.valueOf(0.0));
        tableLayout.setRowWeightY(1, Double.valueOf(1.0));
        tableLayout.setCellColspan(1, 0, Integer.valueOf(2));
        tableLayout.setCellRowspan(1, 2, Integer.valueOf(2));
        tableLayout.setCellColspan(2, 0, Integer.valueOf(2));
        this.add(filterLabel);
        this.add((Component)this.filterField);
        this.add(infoLabel);
        this.add(crsListScrollPane);
        this.add(infoAreaScrollPane);
        this.addPropertyChangeListener("enabled", evt -> {
            filterLabel.setEnabled((Boolean)evt.getNewValue());
            this.filterField.setEnabled(((Boolean)evt.getNewValue()).booleanValue());
            infoLabel.setEnabled((Boolean)evt.getNewValue());
            this.crsList.setEnabled((Boolean)evt.getNewValue());
            crsListScrollPane.setEnabled((Boolean)evt.getNewValue());
            this.infoArea.setEnabled((Boolean)evt.getNewValue());
            infoAreaScrollPane.setEnabled((Boolean)evt.getNewValue());
        });
        this.crsList.getSelectionModel().setSelectionInterval(0, 0);
    }

    CrsInfo getSelectedCrsInfo() {
        return this.selectedCrsInfo;
    }

    private void setInfoText(String infoText) {
        this.infoArea.setText(infoText);
        this.infoArea.setCaretPosition(0);
    }

    private class CrsListSelectionListener
    implements ListSelectionListener {
        private CrsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            block3: {
                JList list = (JList)e.getSource();
                PredefinedCrsPanel.this.selectedCrsInfo = (CrsInfo)list.getSelectedValue();
                if (PredefinedCrsPanel.this.selectedCrsInfo != null) {
                    try {
                        PredefinedCrsPanel.this.setInfoText(PredefinedCrsPanel.this.selectedCrsInfo.getDescription());
                    }
                    catch (Exception e1) {
                        String message = e1.getMessage();
                        if (message == null) break block3;
                        PredefinedCrsPanel.this.setInfoText("Error while creating CRS:\n\n" + message);
                    }
                }
            }
        }
    }

    private class FilterDocumentListener
    implements DocumentListener {
        private FilterDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateFilter(this.getFilterText(e));
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateFilter(this.getFilterText(e));
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void updateFilter(String text) {
            PredefinedCrsPanel.this.filteredListModel.setFilter(crsInfo -> {
                String description = crsInfo.toString().toLowerCase();
                return description.contains(text.trim().toLowerCase());
            });
        }

        private String getFilterText(DocumentEvent e) {
            Document document = e.getDocument();
            String text = null;
            try {
                text = document.getText(0, document.getLength());
            }
            catch (BadLocationException e1) {
                LOG.severe(e1.getMessage());
            }
            return text;
        }
    }
}

