/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product.spectrum;

import com.jidesoft.utils.Lm;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.ui.product.spectrum.DisplayableSpectrum;
import org.esa.snap.ui.product.spectrum.SpectrumBand;
import org.esa.snap.ui.product.spectrum.SpectrumChooser;
import org.esa.snap.ui.product.spectrum.SpectrumStrokeProvider;

public class SpectrumChooserMainForManualTesting {
    public static void main(String[] args) {
        Lm.verifyLicense((String)"Brockmann Consult", (String)"BEAM", (String)"lCzfhklpZ9ryjomwWxfdupxIcuIoCxg2");
        DisplayableSpectrum[] spectra = new DisplayableSpectrum[]{SpectrumChooserMainForManualTesting.createSpectrum(0), SpectrumChooserMainForManualTesting.createSpectrum(1), new DisplayableSpectrum("Other", 3)};
        spectra[2].addBand(SpectrumChooserMainForManualTesting.createBand(11));
        SpectrumChooser chooser = new SpectrumChooser(null, spectra);
        chooser.show();
        System.exit(0);
    }

    private static DisplayableSpectrum createSpectrum(int offset) {
        int numBands = 5;
        String name = "Radiances";
        DisplayableSpectrum spectrum = new DisplayableSpectrum(name + " " + (offset + 1), offset + 1);
        boolean selected = offset % 2 == 1;
        spectrum.setSelected(selected);
        spectrum.setLineStyle(SpectrumStrokeProvider.getStroke((int)offset));
        int bandOffset = numBands * offset;
        for (int i = 0; i < numBands; ++i) {
            spectrum.addBand(SpectrumChooserMainForManualTesting.createBand(i + bandOffset));
        }
        return spectrum;
    }

    private static SpectrumBand createBand(int index) {
        Band band = new Band("Radiance_" + (index + 1), 11, 100, 100);
        band.setDescription("Radiance for band " + (index + 1));
        band.setSpectralWavelength((float)Math.random());
        band.setSpectralBandwidth((float)Math.random());
        band.setUnit("sr^-1");
        if (index == 7) {
            band.setUnit("dl");
        }
        return new SpectrumBand(band, true);
    }
}

