/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.esa.snap.core.datamodel.SceneTransformProvider;
import org.esa.snap.core.transform.MathTransform2D;
import org.esa.snap.ui.product.SimpleFeaturePointFigure;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SimpleFeaturePointFigureTest {
    private SceneTransformProvider sceneTransformProvider;

    @Test
    public void testScaling() throws Exception {
        SimpleFeatureType type = SimpleFeaturePointFigureTest.createShipTrackFeatureType();
        SimpleFeature feature = SimpleFeaturePointFigureTest.createFeature(type, 1, 53.1f, 13.2f, 0.5);
        this.sceneTransformProvider = new SceneTransformProvider(){

            public MathTransform2D getModelToSceneTransform() {
                return MathTransform2D.IDENTITY;
            }

            public MathTransform2D getSceneToModelTransform() {
                return MathTransform2D.IDENTITY;
            }
        };
        SimpleFeaturePointFigure figure = new SimpleFeaturePointFigure(feature, this.sceneTransformProvider, (FigureStyle)new DefaultFigureStyle());
        Coordinate coordinate = figure.getGeometry().getCoordinate();
        Assert.assertEquals((double)13.2f, (double)coordinate.x, (double)1.0E-10);
        Assert.assertEquals((double)53.1f, (double)coordinate.y, (double)1.0E-10);
        boolean closeTo = figure.isCloseTo((Point2D)new Point2D.Double(13.2f, 53.1f), new AffineTransform());
        Assert.assertEquals((Object)true, (Object)closeTo);
    }

    private static SimpleFeatureType createShipTrackFeatureType() {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        ftb.setCRS((CoordinateReferenceSystem)crs);
        ftb.setName("ShipTrack");
        ftb.add("index", Integer.class);
        ftb.add("point", Point.class, (CoordinateReferenceSystem)crs);
        ftb.add("data", Double.class);
        ftb.setDefaultGeometry("point");
        return ftb.buildFeatureType();
    }

    private static SimpleFeature createFeature(SimpleFeatureType type, int index, float lat, float lon, double data) {
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(type);
        GeometryFactory gf = new GeometryFactory();
        fb.add((Object)index);
        fb.add((Object)gf.createPoint(new Coordinate((double)lon, (double)lat)));
        fb.add((Object)data);
        return fb.buildFeature(Long.toHexString(System.nanoTime()));
    }
}

