/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.diagram;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.esa.snap.ui.diagram.DefaultDiagramGraph;
import org.esa.snap.ui.diagram.DiagramGraph;
import org.esa.snap.ui.diagram.DiagramGraphIO;

public class DiagramGraphIOTest
extends TestCase {
    public void testIOWithEqualXValues() throws IOException {
        double[] expectedXValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        double[] expectedY1Values = new double[]{0.0, 1.0, 4.0, 9.0, 16.0, 25.0};
        double[] expectedY2Values = new double[]{0.0, 1.0, 2.0, 3.0, 5.0, 8.0};
        double[] expectedY3Values = new double[]{0.5, 0.4, 0.3, 0.2, 0.1, 0.0};
        DefaultDiagramGraph[] expectedGraphs = new DefaultDiagramGraph[]{new DefaultDiagramGraph("x", expectedXValues, "y1", expectedY1Values), new DefaultDiagramGraph("x", expectedXValues, "y2", expectedY2Values), new DefaultDiagramGraph("x", expectedXValues, "y3", expectedY3Values)};
        this.testIO((DiagramGraph[])expectedGraphs);
    }

    public void testIOWithDifferentXValues() throws IOException {
        double[] expectedX1Values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        double[] expectedY1Values = new double[]{0.0, 1.0, 2.0, 3.0, 5.0, 8.0};
        double[] expectedX2Values = new double[]{4.0, 9.0, 16.0, 25.0};
        double[] expectedY2Values = new double[]{0.3, 0.2, 0.1, 0.0};
        DefaultDiagramGraph[] expectedGraphs = new DefaultDiagramGraph[]{new DefaultDiagramGraph("x1", expectedX1Values, "y1", expectedY1Values), new DefaultDiagramGraph("x2", expectedX2Values, "y2", expectedY2Values)};
        this.testIO((DiagramGraph[])expectedGraphs);
    }

    private void testIO(DiagramGraph[] expectedGraphs) throws IOException {
        StringWriter writer1 = new StringWriter();
        DiagramGraphIO.writeGraphs((DiagramGraph[])expectedGraphs, (Writer)writer1);
        DiagramGraph[] actualGraphs = DiagramGraphIO.readGraphs((Reader)new StringReader(writer1.toString()));
        this.assertEqualGraphs(actualGraphs, expectedGraphs);
        StringWriter writer2 = new StringWriter();
        DiagramGraphIO.writeGraphs((DiagramGraph[])expectedGraphs, (Writer)writer2);
        DiagramGraphIOTest.assertEquals((String)writer1.toString(), (String)writer2.toString());
    }

    private void assertEqualGraphs(DiagramGraph[] actualGraphs, DiagramGraph[] expectedGraphs) {
        DiagramGraphIOTest.assertNotNull((Object)actualGraphs.length);
        DiagramGraphIOTest.assertEquals((int)expectedGraphs.length, (int)actualGraphs.length);
        for (int i = 0; i < expectedGraphs.length; ++i) {
            this.assertEqualGraphs(expectedGraphs[i], actualGraphs[i]);
        }
    }

    private void assertEqualGraphs(DiagramGraph expectedGraph, DiagramGraph actualGraph) {
        DiagramGraphIOTest.assertNotNull((Object)actualGraph);
        DiagramGraphIOTest.assertEquals((String)expectedGraph.getXName(), (String)actualGraph.getXName());
        DiagramGraphIOTest.assertEquals((String)expectedGraph.getYName(), (String)actualGraph.getYName());
        DiagramGraphIOTest.assertEquals((int)expectedGraph.getNumValues(), (int)actualGraph.getNumValues());
        for (int i = 0; i < expectedGraph.getNumValues(); ++i) {
            DiagramGraphIOTest.assertEquals((double)expectedGraph.getXValueAt(i), (double)actualGraph.getXValueAt(i), (double)1.0E-10);
            DiagramGraphIOTest.assertEquals((double)expectedGraph.getYValueAt(i), (double)actualGraph.getYValueAt(i), (double)1.0E-10);
        }
    }
}

