/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.esa.snap.ui.color.ColorChooserPanel;
import org.esa.snap.ui.color.ColorCodes;
import org.esa.snap.ui.color.ColorComboBox;
import org.esa.snap.ui.color.ColorTableCellEditor;
import org.esa.snap.ui.color.ColorTableCellRenderer;
import org.junit.Ignore;

@Ignore
public class ColorSelectionTest {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e2) {
            e2.printStackTrace();
        }
        DefaultTableModel dm = new DefaultTableModel(new Object[][]{{"C1", Color.RED}, {"C2", Color.GREEN}, {"C3", Color.BLUE}}, new String[]{"Name", "Color"}){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return columnIndex == 0 ? String.class : Color.class;
            }
        };
        JTable table = new JTable(dm);
        ColorTableCellEditor editor = new ColorTableCellEditor();
        ColorTableCellRenderer renderer = new ColorTableCellRenderer();
        table.setDefaultEditor(Color.class, (TableCellEditor)editor);
        table.setDefaultRenderer(Color.class, (TableCellRenderer)renderer);
        table.getModel().addTableModelListener(e -> System.out.println("e = " + e));
        ColorComboBox colorComboBox1 = new ColorComboBox(Color.YELLOW);
        ColorComboBox colorComboBox2 = new ColorComboBox(Color.GREEN);
        colorComboBox2.setColorChooserPanelFactory(CustomColorChooserPanel::new);
        JFrame frame = new JFrame("Color Selection Test");
        frame.setLocation(200, 100);
        frame.add((Component)colorComboBox1, "North");
        frame.add((Component)new JScrollPane(table), "Center");
        frame.add((Component)colorComboBox2, "South");
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private static List<ColorItem> getColorItems() {
        ArrayList<ColorItem> colors = new ArrayList<ColorItem>();
        List names = ColorCodes.getNames();
        colors.addAll(names.stream().map(name -> new ColorItem((String)name, ColorCodes.getColor((String)name))).collect(Collectors.toList()));
        return colors;
    }

    private static class CustomColorChooserPanel
    extends ColorChooserPanel {
        public CustomColorChooserPanel(Color selectedColor) {
            super(selectedColor);
        }

        protected JComponent createColorPicker() {
            final List colors = ColorSelectionTest.getColorItems();
            JList<ColorItem> view = new JList<ColorItem>(new AbstractListModel<ColorItem>(){

                @Override
                public int getSize() {
                    return colors.size();
                }

                @Override
                public ColorItem getElementAt(int index) {
                    return (ColorItem)colors.get(index);
                }
            });
            view.setCellRenderer(new ColorItemListCellRenderer());
            view.addListSelectionListener(e -> this.setSelectedColor(((ColorItem)view.getSelectedValue()).color));
            return new JScrollPane(view);
        }
    }

    private static class ColorItemListCellRenderer
    extends JLabel
    implements ListCellRenderer<ColorItem> {
        private ColorItemListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ColorItem> list, ColorItem value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setIcon(new ColorItemIcon(value));
            this.setText(value.name);
            this.setBorder(isSelected ? new LineBorder(Color.ORANGE, 2) : new LineBorder(Color.WHITE, 2));
            return this;
        }

        private static class ColorItemIcon
        implements Icon {
            private final ColorItem value;

            public ColorItemIcon(ColorItem value) {
                this.value = value;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(this.value.color);
                g.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
            }

            @Override
            public int getIconWidth() {
                return 32;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        }
    }

    static class ColorItem {
        String name;
        Color color;

        public ColorItem(String name, Color color) {
            this.name = name;
            this.color = color;
        }
    }
}

