/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import junit.framework.TestCase;
import org.esa.snap.core.param.ParamChangeEvent;
import org.esa.snap.core.param.ParamChangeListener;
import org.esa.snap.core.param.ParamValidateException;
import org.esa.snap.ui.DemSelector;

public class DemSelectorTest
extends TestCase {
    private DemSelector _demSelector;
    private MyParamChangeListener _paramChangeListener;

    protected void setUp() throws Exception {
        this._paramChangeListener = new MyParamChangeListener();
        this._demSelector = new DemSelector((ParamChangeListener)this._paramChangeListener);
    }

    public void test_UsingExternalDEM_IsDefault() {
        DemSelectorTest.assertTrue((boolean)this._demSelector.isUsingExternalDem());
    }

    public void test_SetUsingExternalDem() throws ParamValidateException {
        this._demSelector.setUsingExternalDem(true);
        DemSelectorTest.assertTrue((boolean)this._demSelector.isUsingExternalDem());
        DemSelectorTest.assertFalse((boolean)this._demSelector.isUsingProductDem());
        DemSelectorTest.assertEquals((String)"", (String)this._paramChangeListener.getCallString());
    }

    public void test_SetUsingProductDem() throws ParamValidateException {
        this._demSelector.setUsingProductDem(true);
        DemSelectorTest.assertTrue((boolean)this._demSelector.isUsingProductDem());
        DemSelectorTest.assertFalse((boolean)this._demSelector.isUsingExternalDem());
        DemSelectorTest.assertEquals((String)"useProductDem|useExternalDem|", (String)this._paramChangeListener.getCallString());
    }

    public void test_ToggleUsingDem() throws ParamValidateException {
        this._demSelector.setUsingProductDem(true);
        this._demSelector.setUsingExternalDem(true);
        DemSelectorTest.assertTrue((boolean)this._demSelector.isUsingExternalDem());
        DemSelectorTest.assertFalse((boolean)this._demSelector.isUsingProductDem());
        DemSelectorTest.assertEquals((String)"useProductDem|useExternalDem|useExternalDem|useProductDem|", (String)this._paramChangeListener.getCallString());
    }

    private static class MyParamChangeListener
    implements ParamChangeListener {
        StringBuilder callString = new StringBuilder();

        private MyParamChangeListener() {
        }

        public String getCallString() {
            return this.callString.toString();
        }

        public void parameterValueChanged(ParamChangeEvent event) {
            this.callString.append(event.getParameter().getName());
            this.callString.append("|");
        }
    }
}

