/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product.tree;

import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.PinDescriptor;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.PlainFeatureFactory;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductManager;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.framework.ui.product.tree.AbstractTN;
import org.esa.beam.framework.ui.product.tree.ProductManagerTN;
import org.esa.beam.framework.ui.product.tree.ProductNodeTN;
import org.esa.beam.framework.ui.product.tree.ProductTN;
import org.esa.beam.framework.ui.product.tree.ProductTreeModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProductTreeModelTest {
    private ProductManager productManager;
    private ProductTreeModel treeModel;

    @Before
    public void setupTest() {
        this.productManager = new ProductManager();
        this.treeModel = new ProductTreeModel(this.productManager);
    }

    @Test
    public void testAutoGrouping() {
        Product product = new Product("A", "B", 10, 10);
        product.addBand("chl_20100412T152322", 30);
        product.addBand("chl_20100412T152443", 30);
        product.addBand("chl_20100412T152512", 30);
        product.addBand("chl_20100412T152615", 30);
        product.addBand("chl_20100412T152715", 30);
        product.addBand("tsm_20100412T152322", 30);
        product.addBand("tsm_20100412T152443", 30);
        product.addBand("tsm_20100412T152512", 30);
        product.addBand("tsm_20100412T152615", 30);
        product.addBand("tsm_20100412T152715", 30);
        product.addBand("a_flags", 11);
        product.addBand("b_flags", 11);
        product.setAutoGrouping("");
        this.productManager.addProduct(product);
        Assert.assertEquals((long)1L, (long)this.treeModel.getRoot().getChildCount());
        Assert.assertEquals((long)1L, (long)this.treeModel.getRoot().getChildAt(0).getChildCount());
        Assert.assertEquals((long)12L, (long)this.treeModel.getRoot().getChildAt(0).getChildAt(0).getChildCount());
        this.productManager.removeProduct(product);
        product.setAutoGrouping("chl:tsm");
        this.productManager.addProduct(product);
        Assert.assertEquals((long)1L, (long)this.treeModel.getRoot().getChildCount());
        Assert.assertEquals((long)1L, (long)this.treeModel.getRoot().getChildAt(0).getChildCount());
        Assert.assertEquals((long)4L, (long)this.treeModel.getRoot().getChildAt(0).getChildAt(0).getChildCount());
        Assert.assertEquals((Object)"chl", (Object)this.treeModel.getRoot().getChildAt(0).getChildAt(0).getChildAt(0).getName());
        Assert.assertEquals((long)5L, (long)this.treeModel.getRoot().getChildAt(0).getChildAt(0).getChildAt(0).getChildCount());
        Assert.assertEquals((Object)"tsm", (Object)this.treeModel.getRoot().getChildAt(0).getChildAt(0).getChildAt(1).getName());
        Assert.assertEquals((long)5L, (long)this.treeModel.getRoot().getChildAt(0).getChildAt(0).getChildAt(1).getChildCount());
        Assert.assertEquals((Object)"a_flags", (Object)this.treeModel.getRoot().getChildAt(0).getChildAt(0).getChildAt(2).getName());
        Assert.assertEquals((Object)"b_flags", (Object)this.treeModel.getRoot().getChildAt(0).getChildAt(0).getChildAt(3).getName());
    }

    @Test
    public void testEmptyManager() {
        Assert.assertSame((Object)this.productManager, (Object)this.treeModel.getProductManager());
        ProductManagerTN treeRoot = (ProductManagerTN)this.treeModel.getRoot();
        Assert.assertSame((Object)this.productManager, (Object)treeRoot.getContent());
        Assert.assertTrue((String)"Root is not a leaf", (boolean)this.treeModel.isLeaf((Object)treeRoot));
        Assert.assertEquals((long)0L, (long)this.treeModel.getChildCount((Object)treeRoot));
    }

    @Test
    public void testAddingRemovingProducts() {
        AbstractTN treeRoot = this.treeModel.getRoot();
        Product product1 = this.createDummyProduct("x1");
        this.productManager.addProduct(product1);
        Assert.assertEquals((long)1L, (long)this.treeModel.getChildCount((Object)treeRoot));
        ProductTN child1 = (ProductTN)this.treeModel.getChild((Object)treeRoot, 0);
        Assert.assertSame((Object)product1, (Object)child1.getProduct());
        Product product2 = this.createDummyProduct("x2");
        this.productManager.addProduct(product2);
        Assert.assertEquals((long)2L, (long)this.treeModel.getChildCount((Object)treeRoot));
        ProductTN child2 = (ProductTN)this.treeModel.getChild((Object)treeRoot, 1);
        Assert.assertSame((Object)product2, (Object)child2.getProduct());
        this.productManager.removeProduct(product1);
        Assert.assertEquals((long)1L, (long)this.treeModel.getChildCount((Object)treeRoot));
        ProductTN child3 = (ProductTN)this.treeModel.getChild((Object)treeRoot, 0);
        Assert.assertSame((Object)product2, (Object)child3.getProduct());
    }

    @Test
    public void testAddingRemovingProductNodeGroups() {
        Product product = this.createDummyProduct("x1");
        this.productManager.addProduct(product);
        AbstractTN rootNode = this.treeModel.getRoot();
        ProductTN productTN = (ProductTN)this.treeModel.getChild((Object)rootNode, 0);
        Assert.assertEquals((long)0L, (long)this.treeModel.getChildCount((Object)productTN));
        product.addBand("b1", 10);
        Assert.assertEquals((long)1L, (long)this.treeModel.getChildCount((Object)productTN));
        product.addBand("b2", 10);
        Assert.assertEquals((long)1L, (long)this.treeModel.getChildCount((Object)productTN));
        Placemark pin1 = this.createDummyPin("p1");
        product.getPinGroup().add(pin1);
        Assert.assertEquals((long)2L, (long)this.treeModel.getChildCount((Object)productTN));
        VectorDataNode vec1 = new VectorDataNode("v1", PlainFeatureFactory.createDefaultFeatureType());
        product.getVectorDataGroup().add((ProductNode)vec1);
        Assert.assertEquals((long)2L, (long)this.treeModel.getChildCount((Object)productTN));
        product.getPinGroup().remove(pin1);
        Assert.assertEquals((long)2L, (long)this.treeModel.getChildCount((Object)productTN));
        product.getVectorDataGroup().remove((ProductNode)vec1);
        Assert.assertEquals((long)1L, (long)this.treeModel.getChildCount((Object)productTN));
    }

    @Test
    public void testAddingRemovingProductNodes() {
        Product product = this.createDummyProduct("x1");
        this.productManager.addProduct(product);
        AbstractTN rootNode = this.treeModel.getRoot();
        ProductTN productTN = (ProductTN)this.treeModel.getChild((Object)rootNode, 0);
        Assert.assertEquals((long)0L, (long)this.treeModel.getChildCount((Object)productTN));
        Band band1 = product.addBand("b1", 10);
        Assert.assertEquals((long)1L, (long)this.treeModel.getChildCount((Object)productTN));
        AbstractTN bandGroup = this.treeModel.getChild((Object)productTN, 0);
        Assert.assertNotNull((Object)bandGroup);
        Assert.assertEquals((long)1L, (long)this.treeModel.getChildCount((Object)bandGroup));
        Assert.assertSame((Object)band1, (Object)((ProductNodeTN)this.treeModel.getChild((Object)bandGroup, 0)).getProductNode());
        product.addBand("b2", 10);
        Assert.assertEquals((long)2L, (long)this.treeModel.getChildCount((Object)bandGroup));
        product.removeBand(product.getBand("b2"));
        product.removeBand(product.getBand("b1"));
        Assert.assertEquals((long)0L, (long)this.treeModel.getChildCount((Object)productTN));
    }

    private Placemark createDummyPin(String name) {
        return Placemark.createPointPlacemark((PlacemarkDescriptor)PinDescriptor.getInstance(), (String)name, (String)"", (String)"", (PixelPos)new PixelPos(0.5f, 0.5f), null, null);
    }

    private Product createDummyProduct(String name) {
        return new Product(name, "t", 1, 1);
    }
}

