/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product.spectrum;

import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.ui.product.spectrum.SpectrumBand;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpectrumBandTest {
    private Band band;

    @Before
    public void setUp() {
        this.band = new Band("name", 10, 1, 1);
        this.band.setUnit("unit");
    }

    @Test
    public void testSpectrumBandIsNotCreatedFromNullBand() {
        try {
            SpectrumBand spectrumBand = new SpectrumBand(null, true);
            Assert.fail((String)"Exception expected");
        }
        catch (NullPointerException npe) {
            Assert.assertEquals((Object)npe.getMessage(), (Object)"Assert.notNull(null) called");
        }
    }

    @Test
    public void testSpectrumBandIsCreatedCorrectlyWithFalseInitialState() {
        SpectrumBand spectrumBand = new SpectrumBand(this.band, true);
        Assert.assertNotNull((Object)spectrumBand);
        Assert.assertEquals((Object)true, (Object)spectrumBand.isSelected());
        spectrumBand.setSelected(false);
        Assert.assertEquals((Object)false, (Object)spectrumBand.isSelected());
    }

    @Test
    public void testSpectrumBandIsCreatedCorrectlyWithTrueInitialState() {
        SpectrumBand spectrumBand = new SpectrumBand(this.band, false);
        Assert.assertNotNull((Object)spectrumBand);
        Assert.assertEquals((Object)false, (Object)spectrumBand.isSelected());
        spectrumBand.setSelected(true);
        Assert.assertEquals((Object)true, (Object)spectrumBand.isSelected());
    }

    @Test
    public void testGetUnit() {
        SpectrumBand spectrumBand = new SpectrumBand(this.band, false);
        Assert.assertEquals((Object)"unit", (Object)spectrumBand.getUnit());
    }

    @Test
    public void testGetOriginalBand() {
        SpectrumBand spectrumBand = new SpectrumBand(this.band, false);
        Assert.assertEquals((Object)this.band, (Object)spectrumBand.getOriginalBand());
    }
}

