/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import org.esa.beam.framework.ui.product.SimpleFeatureFigureFactory;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;

public class SimpleFeatureFigureFactoryTest {
    private SimpleFeature simpleFeature;

    @Before
    public void setUp() throws Exception {
        SimpleFeatureTypeBuilder sftb = new SimpleFeatureTypeBuilder();
        sftb.setName("someName");
        sftb.add("style_css", String.class);
        SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(sftb.buildFeatureType());
        this.simpleFeature = sfb.buildFeature("someId");
    }

    @Test
    public void testGetStyleCss_WithAdditionalStyles() throws Exception {
        this.simpleFeature.setAttribute("style_css", (Object)"fill:120,120,120;stroke:0,10,0");
        String styleCss = SimpleFeatureFigureFactory.getStyleCss((SimpleFeature)this.simpleFeature, (String)"symbol:pin");
        Assert.assertEquals((Object)"fill:120,120,120;stroke:0,10,0;symbol:pin", (Object)styleCss);
    }

    @Test
    public void testGetStyleCss_WithOverride() throws Exception {
        this.simpleFeature.setAttribute("style_css", (Object)"symbol:cross;fill:100,100,100");
        String styleCss = SimpleFeatureFigureFactory.getStyleCss((SimpleFeature)this.simpleFeature, (String)"symbol:pin;fill:0,0,0");
        Assert.assertEquals((Object)"symbol:cross;fill:100,100,100", (Object)styleCss);
    }

    @Test
    public void testGetStyleCss_WithOverrideAndDefaultValue() throws Exception {
        this.simpleFeature.setAttribute("style_css", (Object)"fill:120,120,120;stroke:0,10,0");
        String styleCss = SimpleFeatureFigureFactory.getStyleCss((SimpleFeature)this.simpleFeature, (String)"symbol:pin;fill:0,0,0");
        Assert.assertEquals((Object)"fill:120,120,120;stroke:0,10,0;symbol:pin", (Object)styleCss);
    }

    @Test
    public void testGetStyleCss_KeepDefault() throws Exception {
        this.simpleFeature.setAttribute("style_css", (Object)"");
        String styleCss = SimpleFeatureFigureFactory.getStyleCss((SimpleFeature)this.simpleFeature, (String)"symbol:pin;fill:0,0,0");
        Assert.assertEquals((Object)"symbol:pin;fill:0,0,0", (Object)styleCss);
    }

    @Test
    public void testGetStyleCss_EmptyDefault() throws Exception {
        this.simpleFeature.setAttribute("style_css", (Object)"symbol:cross;fill:100,100,100");
        String styleCss = SimpleFeatureFigureFactory.getStyleCss((SimpleFeature)this.simpleFeature, (String)"");
        Assert.assertEquals((Object)"symbol:cross;fill:100,100,100", (Object)styleCss);
    }
}

