/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.ui.product.BandSorter;
import org.junit.Assert;
import org.junit.Test;

public class BandSorterTest {
    @Test
    public void testSort_With_Wavelengths_and_Digits() throws Exception {
        ArrayList<Band> bands = new ArrayList<Band>();
        bands.add(BandSorterTest.createBand("spec_1", 200));
        bands.add(BandSorterTest.createBand("spec_2", 300));
        bands.add(BandSorterTest.createBand("spec_3", 400));
        bands.add(BandSorterTest.createBand("spec_4", 500));
        bands.add(BandSorterTest.createBand("spec_5", 600));
        bands.add(BandSorterTest.createBand("spec_6", 700));
        Collections.shuffle(bands);
        Band[] bandsArray = bands.toArray(new Band[bands.size()]);
        Arrays.sort(bandsArray, BandSorter.createComparator());
        Assert.assertEquals((Object)"spec_1", (Object)bandsArray[0].getName());
        Assert.assertEquals((Object)"spec_2", (Object)bandsArray[1].getName());
        Assert.assertEquals((Object)"spec_3", (Object)bandsArray[2].getName());
        Assert.assertEquals((Object)"spec_4", (Object)bandsArray[3].getName());
        Assert.assertEquals((Object)"spec_5", (Object)bandsArray[4].getName());
        Assert.assertEquals((Object)"spec_6", (Object)bandsArray[5].getName());
    }

    @Test
    public void testSort_Without_Digits() throws Exception {
        ArrayList<Band> bands = new ArrayList<Band>();
        bands.add(BandSorterTest.createBand("spec_a", 200));
        bands.add(BandSorterTest.createBand("spec_b", 300));
        bands.add(BandSorterTest.createBand("spec_c", 400));
        bands.add(BandSorterTest.createBand("spec_d", 500));
        bands.add(BandSorterTest.createBand("spec_e", 600));
        bands.add(BandSorterTest.createBand("spec_f", 700));
        Collections.shuffle(bands);
        Band[] bandsArray = bands.toArray(new Band[bands.size()]);
        BandSorter.sort((Band[])bandsArray);
        Assert.assertEquals((Object)"spec_a", (Object)bandsArray[0].getName());
        Assert.assertEquals((Object)"spec_b", (Object)bandsArray[1].getName());
        Assert.assertEquals((Object)"spec_c", (Object)bandsArray[2].getName());
        Assert.assertEquals((Object)"spec_d", (Object)bandsArray[3].getName());
        Assert.assertEquals((Object)"spec_e", (Object)bandsArray[4].getName());
        Assert.assertEquals((Object)"spec_f", (Object)bandsArray[5].getName());
    }

    @Test
    public void testSort_Without_Wavelengths() throws Exception {
        ArrayList<Band> bands = new ArrayList<Band>();
        bands.add(BandSorterTest.createBand("spec_1", 0));
        bands.add(BandSorterTest.createBand("spec_2", 0));
        bands.add(BandSorterTest.createBand("spec_3", 0));
        bands.add(BandSorterTest.createBand("spec_4", 0));
        bands.add(BandSorterTest.createBand("spec_5", 0));
        bands.add(BandSorterTest.createBand("spec_6", 0));
        Collections.shuffle(bands);
        Band[] bandsArray = bands.toArray(new Band[bands.size()]);
        BandSorter.sort((Band[])bandsArray);
        Assert.assertEquals((Object)"spec_1", (Object)bandsArray[0].getName());
        Assert.assertEquals((Object)"spec_2", (Object)bandsArray[1].getName());
        Assert.assertEquals((Object)"spec_3", (Object)bandsArray[2].getName());
        Assert.assertEquals((Object)"spec_4", (Object)bandsArray[3].getName());
        Assert.assertEquals((Object)"spec_5", (Object)bandsArray[4].getName());
        Assert.assertEquals((Object)"spec_6", (Object)bandsArray[5].getName());
    }

    @Test
    public void testSort_Without_Wavelengths_And_Digits() throws Exception {
        ArrayList<Band> bands = new ArrayList<Band>();
        bands.add(BandSorterTest.createBand("spec_a", 0));
        bands.add(BandSorterTest.createBand("spec_b", 0));
        bands.add(BandSorterTest.createBand("spec_c", 0));
        bands.add(BandSorterTest.createBand("spec_d", 0));
        bands.add(BandSorterTest.createBand("spec_e", 0));
        bands.add(BandSorterTest.createBand("spec_f", 0));
        Collections.shuffle(bands);
        Band[] bandsArray = bands.toArray(new Band[bands.size()]);
        BandSorter.sort((Band[])bandsArray);
        Assert.assertEquals((Object)"spec_a", (Object)bandsArray[0].getName());
        Assert.assertEquals((Object)"spec_b", (Object)bandsArray[1].getName());
        Assert.assertEquals((Object)"spec_c", (Object)bandsArray[2].getName());
        Assert.assertEquals((Object)"spec_d", (Object)bandsArray[3].getName());
        Assert.assertEquals((Object)"spec_e", (Object)bandsArray[4].getName());
        Assert.assertEquals((Object)"spec_f", (Object)bandsArray[5].getName());
    }

    public static Band createBand(String name, int wavelength) {
        Band a = new Band(name, 11, 10, 10);
        a.setSpectralWavelength((float)wavelength);
        return a;
    }
}

