/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.layer;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.ExtensionFactory;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerType;
import javax.swing.JComponent;
import org.esa.beam.framework.ui.layer.AbstractLayerEditor;
import org.esa.beam.framework.ui.layer.DefaultLayerEditorDescriptor;
import org.esa.beam.framework.ui.layer.LayerEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultLayerEditorDescriptorTest {
    private DefaultLayerEditorDescriptor descriptor;

    @Before
    public void setUp() throws Exception {
        this.descriptor = new DefaultLayerEditorDescriptor();
    }

    @Test
    public void testWithLayerTypeAndEditor() {
        this.descriptor.setLayerTypeClass(TestLayerType.class);
        this.descriptor.setLayerEditorClass(TestLayerEditor1.class);
        ExtensionFactory factory = this.descriptor.createExtensionFactory();
        Assert.assertNotNull((Object)factory);
        Object extension = factory.getExtension((Object)new TestLayerType(), LayerEditor.class);
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((boolean)(extension instanceof TestLayerEditor1));
    }

    @Test
    public void testWithLayerAndEditor() {
        this.descriptor.setLayerClass(TestLayer.class);
        this.descriptor.setLayerEditorClass(TestLayerEditor1.class);
        ExtensionFactory factory = this.descriptor.createExtensionFactory();
        Assert.assertNotNull((Object)factory);
        Object extension = factory.getExtension((Object)new TestLayer(), LayerEditor.class);
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((boolean)(extension instanceof TestLayerEditor1));
    }

    @Test
    public void testWithLayerTypeAndEditorFactory() {
        this.descriptor.setLayerTypeClass(TestLayerType.class);
        this.descriptor.setLayerEditorFactoryClass(TestLayerEditorFactory.class);
        ExtensionFactory factory = this.descriptor.createExtensionFactory();
        Assert.assertNotNull((Object)factory);
        Object extension = factory.getExtension((Object)new TestLayerType(), LayerEditor.class);
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((boolean)(extension instanceof TestLayerEditor2));
    }

    @Test
    public void testWithLayerAndEditorFactory() {
        this.descriptor.setLayerClass(TestLayer.class);
        this.descriptor.setLayerEditorFactoryClass(TestLayerEditorFactory.class);
        ExtensionFactory factory = this.descriptor.createExtensionFactory();
        Assert.assertNotNull((Object)factory);
        Object extension = factory.getExtension((Object)new TestLayer(), LayerEditor.class);
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((boolean)(extension instanceof TestLayerEditor3));
    }

    @Test
    public void testWithLayerTypeAndLayerAndEditorFactory() {
        this.descriptor.setLayerClass(TestLayer.class);
        this.descriptor.setLayerTypeClass(TestLayerType.class);
        this.descriptor.setLayerEditorFactoryClass(TestLayerEditorFactory.class);
        ExtensionFactory factory = this.descriptor.createExtensionFactory();
        Assert.assertNotNull((Object)factory);
        Object extension = factory.getExtension((Object)new TestLayerType(), LayerEditor.class);
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((boolean)(extension instanceof TestLayerEditor2));
        extension = factory.getExtension((Object)new TestLayer(), LayerEditor.class);
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((boolean)(extension instanceof TestLayerEditor3));
    }

    public static class TestLayerEditorFactory
    implements ExtensionFactory {
        public Object getExtension(Object object, Class<?> extensionType) {
            if (object instanceof TestLayerType) {
                return new TestLayerEditor2();
            }
            if (object instanceof TestLayer) {
                return new TestLayerEditor3();
            }
            return null;
        }

        public Class<?>[] getExtensionTypes() {
            return new Class[]{TestLayerType.class, TestLayer.class};
        }
    }

    public static class TestLayerEditor3
    extends AbstractLayerEditor {
        protected JComponent createControl() {
            return null;
        }
    }

    public static class TestLayerEditor2
    extends AbstractLayerEditor {
        protected JComponent createControl() {
            return null;
        }
    }

    public static class TestLayerEditor1
    extends AbstractLayerEditor {
        protected JComponent createControl() {
            return null;
        }
    }

    public static class TestLayer
    extends Layer {
        public TestLayer() {
            super((LayerType)new TestLayerType());
        }
    }

    public static class TestLayerType
    extends LayerType {
        public Layer createLayer(LayerContext ctx, PropertySet layerConfig) {
            return new TestLayer();
        }

        public boolean isValidFor(LayerContext ctx) {
            return false;
        }

        public PropertySet createLayerConfig(LayerContext ctx) {
            return new PropertyContainer();
        }
    }
}

