/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.diagram;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import junit.framework.TestCase;
import org.esa.beam.framework.ui.diagram.Diagram;
import org.esa.beam.framework.ui.diagram.DiagramAxis;
import org.esa.beam.framework.ui.diagram.DiagramChangeListener;

public class DiagramAxisTest
extends TestCase {
    DiagramAxis diagramAxis;
    private EventCounter eventCounter;

    public DiagramAxisTest(String s) {
        super(s);
    }

    public void setUp() {
        Diagram diagram = new Diagram();
        this.diagramAxis = new DiagramAxis();
        diagram.setXAxis(this.diagramAxis);
        this.eventCounter = new EventCounter();
        diagram.addChangeListener((DiagramChangeListener)this.eventCounter);
    }

    public void testProperties() {
        this.eventCounter.reset();
        this.diagramAxis.setName("bibo");
        DiagramAxisTest.assertEquals((String)"bibo", (String)this.diagramAxis.getName());
        DiagramAxisTest.assertEquals((int)1, (int)this.eventCounter.counts);
        this.diagramAxis.setName(null);
        DiagramAxisTest.assertEquals(null, (String)this.diagramAxis.getName());
        DiagramAxisTest.assertEquals((int)2, (int)this.eventCounter.counts);
        this.diagramAxis.setUnit("bibo");
        DiagramAxisTest.assertEquals((String)"bibo", (String)this.diagramAxis.getUnit());
        DiagramAxisTest.assertEquals((int)3, (int)this.eventCounter.counts);
        this.diagramAxis.setUnit(null);
        DiagramAxisTest.assertEquals(null, (String)this.diagramAxis.getUnit());
        DiagramAxisTest.assertEquals((int)4, (int)this.eventCounter.counts);
        DiagramAxisTest.assertEquals((double)1.0, (double)this.diagramAxis.getUnitFactor(), (double)1.0E-10);
        this.diagramAxis.setUnitFactor(0.5);
        DiagramAxisTest.assertEquals((double)0.5, (double)this.diagramAxis.getUnitFactor(), (double)1.0E-10);
        DiagramAxisTest.assertEquals((int)5, (int)this.eventCounter.counts);
        this.diagramAxis.setNumMajorTicks(5);
        DiagramAxisTest.assertEquals((int)5, (int)this.diagramAxis.getNumMajorTicks());
        DiagramAxisTest.assertEquals((int)6, (int)this.eventCounter.counts);
        this.diagramAxis.setNumMinorTicks(3);
        DiagramAxisTest.assertEquals((int)3, (int)this.diagramAxis.getNumMinorTicks());
        DiagramAxisTest.assertEquals((int)7, (int)this.eventCounter.counts);
        this.diagramAxis.setValueRange(13.1, 16.2);
        DiagramAxisTest.assertEquals((double)16.2, (double)this.diagramAxis.getMaxValue(), (double)1.0E-9);
        DiagramAxisTest.assertEquals((double)13.1, (double)this.diagramAxis.getMinValue(), (double)1.0E-9);
        DiagramAxisTest.assertEquals((int)8, (int)this.eventCounter.counts);
        try {
            this.diagramAxis.setValueRange(14.1, 11.2);
            DiagramAxisTest.fail();
        }
        catch (Exception e) {
            DiagramAxisTest.assertEquals((String)"java.lang.IllegalArgumentException", (String)e.getClass().getName());
        }
        DiagramAxisTest.assertEquals((int)8, (int)this.eventCounter.counts);
    }

    public void testSetSubDivision() {
        this.diagramAxis.setSubDivision(12.4, 83.6, 7, 4);
        DiagramAxisTest.assertEquals((double)12.4, (double)this.diagramAxis.getMinValue(), (double)1.0E-9);
        DiagramAxisTest.assertEquals((double)83.6, (double)this.diagramAxis.getMaxValue(), (double)1.0E-9);
        DiagramAxisTest.assertEquals((int)7, (int)this.diagramAxis.getNumMajorTicks());
        DiagramAxisTest.assertEquals((int)4, (int)this.diagramAxis.getNumMinorTicks());
        DiagramAxisTest.assertEquals((int)3, (int)this.eventCounter.counts);
    }

    public void testSetOptimalSubDivision() {
        this.diagramAxis.setValueRange(13.1, 16.2);
        DiagramAxisTest.assertEquals((int)1, (int)this.eventCounter.counts);
        this.diagramAxis.setOptimalSubDivision(4, 6, 8);
        DiagramAxisTest.assertEquals((double)16.5, (double)this.diagramAxis.getMaxValue(), (double)1.0E-9);
        DiagramAxisTest.assertEquals((double)12.75, (double)this.diagramAxis.getMinValue(), (double)1.0E-9);
        DiagramAxisTest.assertEquals((int)6, (int)this.diagramAxis.getNumMajorTicks());
        DiagramAxisTest.assertEquals((int)8, (int)this.diagramAxis.getNumMinorTicks());
        DiagramAxisTest.assertEquals((int)4, (int)this.eventCounter.counts);
    }

    public void testGetOptimalTickDistance() {
        DiagramAxisTest.assertEquals((double)10.0, (double)DiagramAxis.getOptimalTickDistance((double)12.0, (double)31.0, (int)3), (double)1.0E-6);
        DiagramAxisTest.assertEquals((double)0.1, (double)DiagramAxis.getOptimalTickDistance((double)0.12, (double)0.31, (int)3), (double)1.0E-9);
        DiagramAxisTest.assertEquals((double)2.5, (double)DiagramAxis.getOptimalTickDistance((double)52.0, (double)57.0, (int)3), (double)1.0E-6);
        DiagramAxisTest.assertEquals((double)2.5, (double)DiagramAxis.getOptimalTickDistance((double)15.0, (double)20.0, (int)3), (double)1.0E-6);
        DiagramAxisTest.assertEquals((double)4.0, (double)DiagramAxis.getOptimalTickDistance((double)14.8, (double)20.3, (int)3), (double)1.0E-6);
        DiagramAxisTest.assertEquals((double)5.0, (double)DiagramAxis.getOptimalTickDistance((double)14.8, (double)24.8, (int)3), (double)1.0E-6);
        DiagramAxisTest.assertEquals((double)2.0, (double)DiagramAxis.getOptimalTickDistance((double)14.8, (double)18.8, (int)3), (double)1.0E-6);
        DiagramAxisTest.assertEquals((double)2.0, (double)DiagramAxis.getOptimalTickDistance((double)10.2, (double)13.8, (int)3), (double)1.0E-6);
        DiagramAxisTest.assertEquals((double)2.0, (double)DiagramAxis.getOptimalTickDistance((double)10.2, (double)13.8, (int)3), (double)1.0E-6);
        DiagramAxisTest.assertEquals((double)7500.0, (double)DiagramAxis.getOptimalTickDistance((double)-10200.0, (double)5.0, (int)3), (double)1.0E-6);
    }

    private static class EventCounter
    implements DiagramChangeListener {
        int counts = 0;

        private EventCounter() {
        }

        public void reset() {
            this.counts = 0;
        }

        public void diagramChanged(Diagram diagram) {
            ++this.counts;
        }
    }

    static class DiagramAxisPropertyChangeListener
    implements PropertyChangeListener {
        Vector _events;

        DiagramAxisPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this._events == null) {
                this._events = new Vector();
            }
            this._events.add(evt);
        }

        public PropertyChangeEvent[] getEvents() {
            if (this._events == null || this._events.size() == 0) {
                return null;
            }
            return this._events.toArray(new PropertyChangeEvent[this._events.size()]);
        }

        public void reset() {
            if (this._events != null) {
                this._events.clear();
            }
        }
    }
}

