/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.command;

import javax.swing.JPopupMenu;
import org.esa.beam.framework.ui.command.Command;
import org.esa.beam.framework.ui.command.CommandManager;
import org.esa.beam.framework.ui.command.DefaultCommandManager;
import org.esa.beam.framework.ui.command.DefaultCommandUIFactory;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.junit.Assert;
import org.junit.Test;

public class DefaultCommandUIFactoryTest {
    @Test
    public void testAddContextDependingMenuItems() {
        DefaultCommandManager manager = new DefaultCommandManager();
        DefaultCommandUIFactoryTest.createCommand("com1", manager);
        DefaultCommandUIFactoryTest.createCommand("com2", manager);
        DefaultCommandUIFactoryTest.createCommand("com3", manager);
        manager.getCommandAt(0).setProperty("_context", (Object)"image");
        manager.getCommandAt(1).setProperty("_context", (Object)"notImage");
        manager.getCommandAt(2).setProperty("_context", (Object)"image");
        manager.getCommandAt(2).setEnabled(false);
        DefaultCommandUIFactory uiFactory = new DefaultCommandUIFactory();
        uiFactory.setCommandManager((CommandManager)manager);
        JPopupMenu menu = uiFactory.addContextDependentMenuItems("image", new JPopupMenu());
        Assert.assertEquals((long)2L, (long)menu.getComponentCount());
        menu = uiFactory.addContextDependentMenuItems("notImage", new JPopupMenu());
        Assert.assertEquals((long)1L, (long)menu.getComponentCount());
    }

    @Test
    public void testAddContextDependingMenuItemsOnlyOneTime() {
        DefaultCommandManager manager = new DefaultCommandManager();
        DefaultCommandUIFactoryTest.createCommand("com1", manager);
        DefaultCommandUIFactoryTest.createCommand("com2", manager);
        DefaultCommandUIFactoryTest.createCommand("com3", manager);
        manager.getCommandAt(0).setProperty("_context", (Object)"band");
        manager.getCommandAt(1).setProperty("_context", (Object)new String[]{"band", "virtualBand"});
        manager.getCommandAt(2).setProperty("_context", (Object)"virtualBand");
        DefaultCommandUIFactory uiFactory = new DefaultCommandUIFactory();
        uiFactory.setCommandManager((CommandManager)manager);
        JPopupMenu bandMenu = new JPopupMenu();
        uiFactory.addContextDependentMenuItems("virtualBand", bandMenu);
        Assert.assertEquals((long)2L, (long)bandMenu.getComponentCount());
        JPopupMenu virtualBandMenu = new JPopupMenu();
        uiFactory.addContextDependentMenuItems("band", virtualBandMenu);
        Assert.assertEquals((long)2L, (long)virtualBandMenu.getComponentCount());
        JPopupMenu bandAndVbMenu = new JPopupMenu();
        uiFactory.addContextDependentMenuItems("band", bandAndVbMenu);
        uiFactory.addContextDependentMenuItems("virtualBand", bandAndVbMenu);
        Assert.assertEquals((long)3L, (long)bandAndVbMenu.getComponentCount());
    }

    @Test
    public void testPlaceAtContextTop() {
        DefaultCommandManager manager = new DefaultCommandManager();
        ExecCommand standardCommand1 = DefaultCommandUIFactoryTest.createCommand("com1", manager);
        ExecCommand standardCommand2 = DefaultCommandUIFactoryTest.createCommand("com2", manager);
        ExecCommand topCommand = DefaultCommandUIFactoryTest.createCommand("com3", manager);
        standardCommand1.setProperty("_context", (Object)"band");
        standardCommand2.setProperty("_context", (Object)"band");
        topCommand.setProperty("_context", (Object)"band");
        topCommand.setPlaceAtContextTop(true);
        DefaultCommandUIFactory uiFactory = new DefaultCommandUIFactory();
        uiFactory.setCommandManager((CommandManager)manager);
        JPopupMenu popup = new JPopupMenu();
        uiFactory.addContextDependentMenuItems("band", popup);
        Assert.assertEquals((long)3L, (long)popup.getComponentCount());
        String[] expectedOrder = new String[]{"com3", "com1", "com2"};
        Assert.assertEquals((Object)expectedOrder[0], (Object)popup.getComponent(0).getName());
        Assert.assertEquals((Object)expectedOrder[1], (Object)popup.getComponent(1).getName());
        Assert.assertEquals((Object)expectedOrder[2], (Object)popup.getComponent(2).getName());
    }

    private static ExecCommand createCommand(String commandId, DefaultCommandManager manager) {
        ExecCommand command = new ExecCommand();
        command.setCommandID(commandId);
        manager.addCommand((Command)command);
        return command;
    }
}

