/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.command;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.beam.framework.ui.command.Command;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.CommandListener;
import org.esa.beam.framework.ui.command.DefaultCommandManager;
import org.esa.beam.framework.ui.command.ExecCommand;

public class DefaultCommandManagerTest
extends TestCase {
    private DefaultCommandManager _manager;

    public DefaultCommandManagerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(DefaultCommandManagerTest.class);
    }

    public void setUp() {
        this._manager = new DefaultCommandManager();
    }

    public void tearDown() {
        this._manager = null;
    }

    public void testCreateOneCommand() {
        DefaultCommandManagerTest.assertEquals((int)0, (int)this._manager.getNumCommands());
        this.addCommand("test");
        DefaultCommandManagerTest.assertEquals((int)1, (int)this._manager.getNumCommands());
        ExecCommand command = this._manager.getExecCommand("test");
        DefaultCommandManagerTest.assertNotNull((Object)command);
        Command commandAt = this._manager.getCommandAt(0);
        DefaultCommandManagerTest.assertSame((Object)command, (Object)commandAt);
    }

    public void testCreateMoreCommands() {
        DefaultCommandManagerTest.assertEquals((int)0, (int)this._manager.getNumCommands());
        this.addCommand("test1");
        this.addCommand("test2");
        this.addCommand("test3");
        this.addCommand("test4");
        DefaultCommandManagerTest.assertEquals((int)4, (int)this._manager.getNumCommands());
        ExecCommand command = null;
        command = this._manager.getExecCommand("test2");
        DefaultCommandManagerTest.assertNotNull((Object)command);
        Command commandAt = null;
        commandAt = this._manager.getCommandAt(1);
        DefaultCommandManagerTest.assertSame((Object)command, (Object)commandAt);
        command = null;
        command = this._manager.getExecCommand("test1");
        DefaultCommandManagerTest.assertNotNull((Object)command);
        commandAt = null;
        commandAt = this._manager.getCommandAt(0);
        DefaultCommandManagerTest.assertSame((Object)command, (Object)commandAt);
        command = null;
        command = this._manager.getExecCommand("test3");
        DefaultCommandManagerTest.assertNotNull((Object)command);
        commandAt = null;
        commandAt = this._manager.getCommandAt(2);
        DefaultCommandManagerTest.assertSame((Object)command, (Object)commandAt);
        command = null;
        command = this._manager.getExecCommand("test4");
        DefaultCommandManagerTest.assertNotNull((Object)command);
        commandAt = null;
        commandAt = this._manager.getCommandAt(3);
        DefaultCommandManagerTest.assertSame((Object)command, (Object)commandAt);
    }

    private void addCommand(String commandId) {
        ExecCommand command1 = new ExecCommand();
        command1.setCommandID(commandId);
        this._manager.addCommand((Command)command1);
    }

    public void testCreateCommandWithConstraintsAndListener() {
        CommandListener listener = new CommandListener(){

            public void actionPerformed(CommandEvent event) {
            }

            public void updateState(CommandEvent event) {
            }
        };
        ExecCommand command = DefaultCommandManagerTest.createCommand("test");
        command.addCommandListener(listener);
        this._manager.addCommand((Command)command);
        Command commandAt = this._manager.getCommandAt(0);
        CommandListener[] listeners = (CommandListener[])commandAt.getEventListenerList().getListeners(CommandListener.class);
        DefaultCommandManagerTest.assertEquals((int)1, (int)listeners.length);
        DefaultCommandManagerTest.assertSame((Object)listener, (Object)listeners[0]);
    }

    public void testGetCommandAt_IndexOutOfBoundsException() {
        this.addCommand("test");
        DefaultCommandManagerTest.assertNotNull((Object)this._manager.getCommandAt(0));
        try {
            this._manager.getCommandAt(1);
            DefaultCommandManagerTest.fail((String)"IndexOutOfBoundsException not expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static ExecCommand createCommand(String commandId) {
        ExecCommand command = new ExecCommand();
        command.setCommandID(commandId);
        return command;
    }
}

