/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.application.support;

import com.thoughtworks.xstream.XStream;
import junit.framework.TestCase;
import org.esa.beam.framework.ui.application.support.DefaultApplicationDescriptor;

public class DefaultApplicationDescriptorTest
extends TestCase {
    private static final String XML = "<applicationDescriptor>\n  <applicationId>DatMain</applicationId>\n  <displayName>DAT</displayName>\n  <frameIcons>/org/esa/nest/dat/images/frame-icon.png</frameIcons>\n  <aboutImage>/org/esa/nest/dat/images/about.jpg</aboutImage>\n  <excludedActions>\n      <id>a1</id>\n      <id>a2</id>\n  </excludedActions>\n  <excludedToolViews>\n      <id>tv1</id>\n      <id>tv2</id>\n      <id>tv3</id>\n  </excludedToolViews>\n</applicationDescriptor>";

    public void testUnmarshalling() {
        XStream xStream = new XStream();
        xStream.autodetectAnnotations(true);
        xStream.alias("applicationDescriptor", DefaultApplicationDescriptor.class);
        Object o = null;
        try {
            o = xStream.fromXML(XML);
        }
        catch (Exception e) {
            DefaultApplicationDescriptorTest.fail((String)e.getMessage());
            e.printStackTrace();
        }
        DefaultApplicationDescriptorTest.assertNotNull((Object)o);
        DefaultApplicationDescriptorTest.assertSame(DefaultApplicationDescriptor.class, o.getClass());
        DefaultApplicationDescriptor defaultApplicationDescriptor = (DefaultApplicationDescriptor)o;
        DefaultApplicationDescriptorTest.assertEquals((String)"DatMain", (String)defaultApplicationDescriptor.getApplicationId());
        DefaultApplicationDescriptorTest.assertEquals((String)"DAT", (String)defaultApplicationDescriptor.getDisplayName());
        DefaultApplicationDescriptorTest.assertEquals((String)"/org/esa/nest/dat/images/frame-icon.png", (String)defaultApplicationDescriptor.getFrameIconPaths());
        DefaultApplicationDescriptorTest.assertEquals((String)"/org/esa/nest/dat/images/about.jpg", (String)defaultApplicationDescriptor.getAboutImagePath());
        DefaultApplicationDescriptorTest.assertNotNull((Object)defaultApplicationDescriptor.getExcludedActions());
        DefaultApplicationDescriptorTest.assertEquals((int)2, (int)defaultApplicationDescriptor.getExcludedActions().length);
        DefaultApplicationDescriptorTest.assertEquals((String)"a1", (String)defaultApplicationDescriptor.getExcludedActions()[0]);
        DefaultApplicationDescriptorTest.assertEquals((String)"a2", (String)defaultApplicationDescriptor.getExcludedActions()[1]);
        DefaultApplicationDescriptorTest.assertNotNull((Object)defaultApplicationDescriptor.getExcludedToolViews());
        DefaultApplicationDescriptorTest.assertEquals((int)3, (int)defaultApplicationDescriptor.getExcludedToolViews().length);
        DefaultApplicationDescriptorTest.assertEquals((String)"tv1", (String)defaultApplicationDescriptor.getExcludedToolViews()[0]);
        DefaultApplicationDescriptorTest.assertEquals((String)"tv2", (String)defaultApplicationDescriptor.getExcludedToolViews()[1]);
        DefaultApplicationDescriptorTest.assertEquals((String)"tv3", (String)defaultApplicationDescriptor.getExcludedToolViews()[2]);
    }
}

