/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RGBImageProfile;
import org.esa.beam.framework.ui.RGBImageProfilePane;
import org.junit.Assert;
import org.junit.Test;

public class RGBImageProfilePaneTest {
    @Test
    public void testSelectProfile_1() throws Exception {
        RGBImageProfile[] rgbImageProfiles = new RGBImageProfile[]{new RGBImageProfile("p1", new String[]{"", "", ""}, new String[]{"matches", "not at", "all"}), new RGBImageProfile("p2", new String[]{"", "", ""}, new String[]{"some_different_type", "*name_*3", null}), new RGBImageProfile("p3", new String[]{"", "", ""}, new String[]{"*me_ty*", "*name_*3", null}), new RGBImageProfile("p4", new String[]{"", "", ""}, new String[]{"*me_ty*", "*name_*3", "*s some*"})};
        Product product = new Product("some_name_123", "some_type_123", 1, 1);
        product.setDescription("This is some description text.");
        RGBImageProfile profile = RGBImageProfilePane.findProfileForProductPattern((RGBImageProfile[])rgbImageProfiles, (Product)product);
        Assert.assertNotNull((Object)profile);
        Assert.assertSame((Object)rgbImageProfiles[3], (Object)profile);
    }

    @Test
    public void testSelectProfile_2() throws Exception {
        RGBImageProfile[] rgbImageProfiles = new RGBImageProfile[]{new RGBImageProfile("p1", new String[]{"", "", ""}, new String[]{"matches", "not at", "all"}), new RGBImageProfile("p2", new String[]{"", "", ""}, new String[]{"some_different_type", "*name_*3", null}), new RGBImageProfile("p3", new String[]{"", "", ""}, new String[]{"*me_ty*", null, null}), new RGBImageProfile("p4", new String[]{"", "", ""}, new String[]{null, "*name_*3", "*s some*"})};
        Product product = new Product("some_name_123", "some_type_123", 1, 1);
        product.setDescription("This is some description text.");
        RGBImageProfile profile = RGBImageProfilePane.findProfileForProductPattern((RGBImageProfile[])rgbImageProfiles, (Product)product);
        Assert.assertNotNull((Object)profile);
        Assert.assertSame((Object)rgbImageProfiles[2], (Object)profile);
    }

    @Test
    public void testSelectProfile_3() throws Exception {
        RGBImageProfile[] rgbImageProfiles = new RGBImageProfile[]{new RGBImageProfile("p1", new String[]{"", "", ""}, new String[]{"matches", "not at", "all"}), new RGBImageProfile("p2", new String[]{"", "", ""}, new String[]{"some_different_type", "*name_*3", null}), new RGBImageProfile("p3", new String[]{"", "", ""}, new String[]{null, "*name_*3", null}), new RGBImageProfile("p4", new String[]{"", "", ""}, new String[]{null, "*name_*3", "*s some*"})};
        Product product = new Product("some_name_123", "some_type_123", 1, 1);
        product.setDescription("This is some description text.");
        RGBImageProfile profile = RGBImageProfilePane.findProfileForProductPattern((RGBImageProfile[])rgbImageProfiles, (Product)product);
        Assert.assertNotNull((Object)profile);
        Assert.assertSame((Object)rgbImageProfiles[3], (Object)profile);
    }

    @Test
    public void testSelectProfile_4() throws Exception {
        RGBImageProfile[] rgbImageProfiles = new RGBImageProfile[]{new RGBImageProfile("p1", new String[]{"", "", ""}, new String[]{"matches", "not at", "all"}), new RGBImageProfile("p2", new String[]{"", "", ""}, new String[]{"some_different_type", "*name_*3", null}), new RGBImageProfile("p3", new String[]{"", "", ""}, new String[]{"strange type", "*name_*3", null}), new RGBImageProfile("p4", new String[]{"", "", ""}, new String[]{"strange type", "*name_*3", "*s some*"})};
        Product product = new Product("some_name_123", "some_type_123", 1, 1);
        product.setDescription("This is some description text.");
        RGBImageProfile profile = RGBImageProfilePane.findProfileForProductPattern((RGBImageProfile[])rgbImageProfiles, (Product)product);
        Assert.assertNotNull((Object)profile);
        Assert.assertSame((Object)rgbImageProfiles[3], (Object)profile);
    }

    @Test
    public void testSelectProfile_5() throws Exception {
        RGBImageProfile[] rgbImageProfiles = new RGBImageProfile[]{new RGBImageProfile("p1", new String[]{"", "", ""}, new String[]{"matches", "not at", "all"}), new RGBImageProfile("p2", new String[]{"", "", ""}, new String[]{"some_different_type", "*name_*3", null}), new RGBImageProfile("p3", new String[]{"", "", ""}, new String[]{"*me_ty*", "*name_*3", null}), new RGBImageProfile("p4", new String[]{"", "", ""}, new String[]{"*me_ty*", "*name_*3", null})};
        Product product = new Product("some_name_123", "some_type_123", 1, 1);
        product.setDescription("This is some description text.");
        RGBImageProfile profile = RGBImageProfilePane.findProfileForProductPattern((RGBImageProfile[])rgbImageProfiles, (Product)product);
        Assert.assertNotNull((Object)profile);
        Assert.assertSame((Object)rgbImageProfiles[2], (Object)profile);
    }

    @Test
    public void testSelectProfile_6() throws Exception {
        RGBImageProfile[] rgbImageProfiles = new RGBImageProfile[]{};
        Product product = new Product("some_name_123", "some_type_123", 1, 1);
        product.setDescription("This is some description text.");
        RGBImageProfile profile = RGBImageProfilePane.findProfileForProductPattern((RGBImageProfile[])rgbImageProfiles, (Product)product);
        Assert.assertNull((Object)profile);
    }
}

