/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.beam.framework.ui.BorderLayoutUtils;
import org.esa.beam.framework.ui.GridBagUtils;

public class GUIElementFactoryTest
extends TestCase {
    public GUIElementFactoryTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(GUIElementFactoryTest.class);
    }

    public void testAddComponentsToBorderPanel() {
        BorderLayout bl = new BorderLayout();
        JPanel panel = new JPanel(bl);
        JTextArea centerComp = new JTextArea("textArea");
        JLabel westComp = new JLabel("text");
        String place = "West";
        BorderLayoutUtils.addToPanel((JPanel)panel, (JComponent)centerComp, (JComponent)westComp, (String)place);
        GUIElementFactoryTest.assertEquals((int)2, (int)panel.getComponentCount());
        GUIElementFactoryTest.assertEquals((boolean)true, (boolean)panel.isAncestorOf(centerComp));
        GUIElementFactoryTest.assertEquals((boolean)true, (boolean)panel.isAncestorOf(westComp));
    }

    public void testGridBagPanel_fourParams() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        JLabel comp = new JLabel("text");
        GridBagConstraints gbconstr = GridBagUtils.createDefaultConstraints();
        GridBagUtils.setAttributes((GridBagConstraints)gbconstr, (String)"gridx=2, gridy=4");
        GridBagUtils.addToPanel((JPanel)panel, (Component)comp, (GridBagConstraints)gbconstr);
        GridBagConstraints gbc = gbl.getConstraints(comp);
        GUIElementFactoryTest.assertEquals((int)17, (int)gbc.anchor);
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.insets.top);
        GUIElementFactoryTest.assertEquals((int)3, (int)gbc.insets.left);
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.insets.bottom);
        GUIElementFactoryTest.assertEquals((int)3, (int)gbc.insets.right);
        GUIElementFactoryTest.assertEquals((int)2, (int)gbc.gridx);
        GUIElementFactoryTest.assertEquals((int)4, (int)gbc.gridy);
        GUIElementFactoryTest.assertEquals((double)0.0, (double)gbc.weightx, (double)0.01);
        GUIElementFactoryTest.assertEquals((double)0.0, (double)gbc.weighty, (double)0.01);
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.ipadx);
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.ipady);
        GUIElementFactoryTest.assertEquals((int)1, (int)gbc.gridheight);
        GUIElementFactoryTest.assertEquals((int)1, (int)gbc.gridwidth);
    }

    public void testGridBagPanel_sevenParams() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        JLabel comp = new JLabel("text");
        GridBagConstraints gbconstraints = GridBagUtils.createDefaultConstraints();
        GridBagUtils.setAttributes((GridBagConstraints)gbconstraints, (String)"gridx=2, gridy=4, anchor=SOUTHEAST, weighty=1.3, insets.top=5");
        GridBagUtils.addToPanel((JPanel)panel, (Component)comp, (GridBagConstraints)gbconstraints);
        GridBagConstraints gbc = gbl.getConstraints(comp);
        GUIElementFactoryTest.assertEquals((int)14, (int)gbc.anchor);
        GUIElementFactoryTest.assertEquals((int)5, (int)gbc.insets.top);
        GUIElementFactoryTest.assertEquals((int)3, (int)gbc.insets.left);
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.insets.bottom);
        GUIElementFactoryTest.assertEquals((int)3, (int)gbc.insets.right);
        GUIElementFactoryTest.assertEquals((int)2, (int)gbc.gridx);
        GUIElementFactoryTest.assertEquals((int)4, (int)gbc.gridy);
        GUIElementFactoryTest.assertEquals((double)0.0, (double)gbc.weightx, (double)0.01);
        GUIElementFactoryTest.assertEquals((double)1.3, (double)gbc.weighty, (double)0.01);
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.ipadx);
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.ipady);
        GUIElementFactoryTest.assertEquals((int)1, (int)gbc.gridheight);
        GUIElementFactoryTest.assertEquals((int)1, (int)gbc.gridwidth);
    }

    public void testGridBagPanel_eightParams() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panel = new JPanel(gbl);
        JLabel comp = new JLabel("text");
        GridBagConstraints gbconstraints = GridBagUtils.createDefaultConstraints();
        GridBagUtils.setAttributes((GridBagConstraints)gbconstraints, (String)"gridx=2, gridy=4, anchor=SOUTHEAST, weighty=1.3, insets.top=5, gridwidth=3");
        GridBagUtils.addToPanel((JPanel)panel, (Component)comp, (GridBagConstraints)gbconstraints);
        GridBagConstraints gbc = gbl.getConstraints(comp);
        GUIElementFactoryTest.assertEquals((int)14, (int)gbc.anchor);
        GUIElementFactoryTest.assertEquals((int)5, (int)gbc.insets.top);
        GUIElementFactoryTest.assertEquals((int)3, (int)gbc.insets.left);
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.insets.bottom);
        GUIElementFactoryTest.assertEquals((int)3, (int)gbc.insets.right);
        GUIElementFactoryTest.assertEquals((int)2, (int)gbc.gridx);
        GUIElementFactoryTest.assertEquals((int)4, (int)gbc.gridy);
        GUIElementFactoryTest.assertEquals((double)0.0, (double)gbc.weightx, (double)0.01);
        GUIElementFactoryTest.assertEquals((double)1.3, (double)gbc.weighty, (double)0.01);
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.ipadx);
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.ipady);
        GUIElementFactoryTest.assertEquals((int)1, (int)gbc.gridheight);
        GUIElementFactoryTest.assertEquals((int)3, (int)gbc.gridwidth);
    }

    public void testSetAttributes() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"gridx=RELATIVE,gridy=RELATIVE");
        GUIElementFactoryTest.assertEquals((int)-1, (int)gbc.gridx);
        GUIElementFactoryTest.assertEquals((int)-1, (int)gbc.gridy);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"gridx=12, gridy=34");
        GUIElementFactoryTest.assertEquals((int)12, (int)gbc.gridx);
        GUIElementFactoryTest.assertEquals((int)34, (int)gbc.gridy);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"gridwidth=REMAINDER,gridheight=REMAINDER");
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.gridwidth);
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.gridheight);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"gridwidth=RELATIVE,gridheight=RELATIVE");
        GUIElementFactoryTest.assertEquals((int)-1, (int)gbc.gridwidth);
        GUIElementFactoryTest.assertEquals((int)-1, (int)gbc.gridheight);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"gridwidth=56, gridheight=78");
        GUIElementFactoryTest.assertEquals((int)56, (int)gbc.gridwidth);
        GUIElementFactoryTest.assertEquals((int)78, (int)gbc.gridheight);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"weightx=0.4, weighty=0.6");
        GUIElementFactoryTest.assertEquals((double)0.4, (double)gbc.weightx, (double)1.0E-12);
        GUIElementFactoryTest.assertEquals((double)0.6, (double)gbc.weighty, (double)1.0E-12);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"anchor=CENTER");
        GUIElementFactoryTest.assertEquals((int)10, (int)gbc.anchor);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"anchor=NORTH");
        GUIElementFactoryTest.assertEquals((int)11, (int)gbc.anchor);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"anchor=NORTHEAST");
        GUIElementFactoryTest.assertEquals((int)12, (int)gbc.anchor);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"anchor=EAST");
        GUIElementFactoryTest.assertEquals((int)13, (int)gbc.anchor);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"anchor=SOUTHEAST");
        GUIElementFactoryTest.assertEquals((int)14, (int)gbc.anchor);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"anchor=SOUTH");
        GUIElementFactoryTest.assertEquals((int)15, (int)gbc.anchor);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"anchor=SOUTHWEST");
        GUIElementFactoryTest.assertEquals((int)16, (int)gbc.anchor);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"anchor=WEST");
        GUIElementFactoryTest.assertEquals((int)17, (int)gbc.anchor);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"anchor=NORTHWEST");
        GUIElementFactoryTest.assertEquals((int)18, (int)gbc.anchor);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"anchor=10");
        GUIElementFactoryTest.assertEquals((int)10, (int)gbc.anchor);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"fill=NONE");
        GUIElementFactoryTest.assertEquals((int)0, (int)gbc.fill);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"fill=HORIZONTAL");
        GUIElementFactoryTest.assertEquals((int)2, (int)gbc.fill);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"fill=VERTICAL");
        GUIElementFactoryTest.assertEquals((int)3, (int)gbc.fill);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"fill=BOTH");
        GUIElementFactoryTest.assertEquals((int)1, (int)gbc.fill);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"fill=1");
        GUIElementFactoryTest.assertEquals((int)1, (int)gbc.fill);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"insets.bottom=10,insets.left=11,insets.right=12,insets.top=13");
        GUIElementFactoryTest.assertEquals((int)10, (int)gbc.insets.bottom);
        GUIElementFactoryTest.assertEquals((int)11, (int)gbc.insets.left);
        GUIElementFactoryTest.assertEquals((int)12, (int)gbc.insets.right);
        GUIElementFactoryTest.assertEquals((int)13, (int)gbc.insets.top);
        gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"ipadx=6,ipady=7");
        GUIElementFactoryTest.assertEquals((int)6, (int)gbc.ipadx);
        GUIElementFactoryTest.assertEquals((int)7, (int)gbc.ipady);
        GUIElementFactoryTest.assertEquals((int)12, (int)gbc.gridx);
        GUIElementFactoryTest.assertEquals((int)34, (int)gbc.gridy);
        GUIElementFactoryTest.assertEquals((int)56, (int)gbc.gridwidth);
        GUIElementFactoryTest.assertEquals((int)78, (int)gbc.gridheight);
        GUIElementFactoryTest.assertEquals((double)0.4, (double)gbc.weightx, (double)1.0E-12);
        GUIElementFactoryTest.assertEquals((double)0.6, (double)gbc.weighty, (double)1.0E-12);
        GUIElementFactoryTest.assertEquals((int)10, (int)gbc.anchor);
        GUIElementFactoryTest.assertEquals((int)1, (int)gbc.fill);
        GUIElementFactoryTest.assertEquals((int)10, (int)gbc.insets.bottom);
        GUIElementFactoryTest.assertEquals((int)11, (int)gbc.insets.left);
        GUIElementFactoryTest.assertEquals((int)12, (int)gbc.insets.right);
        GUIElementFactoryTest.assertEquals((int)13, (int)gbc.insets.top);
        GUIElementFactoryTest.assertEquals((int)6, (int)gbc.ipadx);
        GUIElementFactoryTest.assertEquals((int)7, (int)gbc.ipady);
        try {
            gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, null);
        }
        catch (IllegalArgumentException e) {
            GUIElementFactoryTest.fail((String)"IllegalArgumentException not expected");
        }
        try {
            gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"");
        }
        catch (IllegalArgumentException e) {
            GUIElementFactoryTest.fail((String)"IllegalArgumentException not expected");
        }
        try {
            gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"ipadx");
            GUIElementFactoryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"ipadx=");
            GUIElementFactoryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"ipadx=,");
            GUIElementFactoryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"=9");
            GUIElementFactoryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            gbc = GridBagUtils.setAttributes((GridBagConstraints)gbc, (String)"=");
            GUIElementFactoryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

