/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.esa.beam.GlobalTestConfig;
import org.esa.beam.GlobalTestTools;
import org.esa.beam.framework.ui.FileHistory;
import org.esa.beam.util.PropertyMap;

public class FileHistoryTest
extends TestCase {
    private File _a;
    private File _b;
    private File _c;
    private File _d;
    private File _e;

    public FileHistoryTest(String name) {
        super(name);
    }

    public void setUp() {
        GlobalTestTools.deleteTestDataOutputDirectory();
        this._a = new File(GlobalTestConfig.getBeamTestDataOutputDirectory(), "A.dim");
        this._b = new File(GlobalTestConfig.getBeamTestDataOutputDirectory(), "B.dim");
        this._c = new File(GlobalTestConfig.getBeamTestDataOutputDirectory(), "C.dim");
        this._d = new File(GlobalTestConfig.getBeamTestDataOutputDirectory(), "D.dim");
        this._e = new File(GlobalTestConfig.getBeamTestDataOutputDirectory(), "E.dim");
        try {
            this._a.getParentFile().mkdirs();
            this._a.createNewFile();
            this._b.createNewFile();
            this._d.createNewFile();
            this._e.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void tearDown() {
        GlobalTestTools.deleteTestDataOutputDirectory();
    }

    public void testFileHistory() {
        FileHistoryTest.assertTrue((String)(this._a.getAbsolutePath() + " does not exist"), (boolean)this._a.exists());
        FileHistoryTest.assertTrue((String)(this._b.getAbsolutePath() + " does not exist"), (boolean)this._b.exists());
        FileHistoryTest.assertTrue((String)(this._c.getAbsolutePath() + " does exist"), (!this._c.exists() ? 1 : 0) != 0);
        FileHistoryTest.assertTrue((String)(this._d.getAbsolutePath() + " deos not exist"), (boolean)this._d.exists());
        FileHistoryTest.assertTrue((String)(this._e.getAbsolutePath() + " deos not exist"), (boolean)this._e.exists());
        String propertyKey = "recent.files.";
        PropertyMap properties = new PropertyMap();
        properties.setPropertyInt("recent.files..length", 3);
        properties.setPropertyString("recent.files..0", this._a.getAbsolutePath());
        properties.setPropertyString("recent.files..1", this._b.getAbsolutePath());
        properties.setPropertyString("recent.files..2", this._c.getAbsolutePath());
        properties.setPropertyString("recent.files..3", this._d.getAbsolutePath());
        properties.setPropertyString("recent.files..4", this._e.getAbsolutePath());
        FileHistory history = new FileHistory(9, "recent.files.");
        FileHistoryTest.assertEquals((int)9, (int)history.getMaxNumEntries());
        FileHistoryTest.assertEquals((int)0, (int)history.getNumEntries());
        FileHistoryTest.assertNull((Object)history.getEntries());
        history.initBy(properties);
        FileHistoryTest.assertEquals((int)3, (int)history.getMaxNumEntries());
        FileHistoryTest.assertEquals((int)2, (int)history.getNumEntries());
        String[] files = history.getEntries();
        FileHistoryTest.assertEquals((int)2, (int)files.length);
        FileHistoryTest.assertEquals((String)this._a.getAbsolutePath(), (String)files[0]);
        FileHistoryTest.assertEquals((String)this._b.getAbsolutePath(), (String)files[1]);
        history.push(this._d.getAbsolutePath());
        FileHistoryTest.assertEquals((int)3, (int)history.getNumEntries());
        files = history.getEntries();
        FileHistoryTest.assertEquals((int)3, (int)files.length);
        FileHistoryTest.assertEquals((String)this._d.getAbsolutePath(), (String)files[0]);
        FileHistoryTest.assertEquals((String)this._a.getAbsolutePath(), (String)files[1]);
        FileHistoryTest.assertEquals((String)this._b.getAbsolutePath(), (String)files[2]);
        history.push(this._e.getAbsolutePath());
        FileHistoryTest.assertEquals((int)3, (int)history.getNumEntries());
        files = history.getEntries();
        FileHistoryTest.assertEquals((int)3, (int)files.length);
        FileHistoryTest.assertEquals((String)this._e.getAbsolutePath(), (String)files[0]);
        FileHistoryTest.assertEquals((String)this._d.getAbsolutePath(), (String)files[1]);
        FileHistoryTest.assertEquals((String)this._a.getAbsolutePath(), (String)files[2]);
        history.setMaxNumEntries(2);
        FileHistoryTest.assertEquals((int)2, (int)history.getNumEntries());
        files = history.getEntries();
        FileHistoryTest.assertEquals((int)2, (int)files.length);
        FileHistoryTest.assertEquals((String)this._e.getAbsolutePath(), (String)files[0]);
        FileHistoryTest.assertEquals((String)this._d.getAbsolutePath(), (String)files[1]);
        history.copyInto(properties);
        FileHistoryTest.assertEquals((int)2, (int)properties.getPropertyInt("recent.files..length"));
        FileHistoryTest.assertEquals((String)this._e.getAbsolutePath(), (String)properties.getPropertyString("recent.files..0"));
        FileHistoryTest.assertEquals((String)this._d.getAbsolutePath(), (String)properties.getPropertyString("recent.files..1"));
        FileHistoryTest.assertNull((Object)properties.getPropertyString("recent.files..2", null));
        FileHistoryTest.assertNull((Object)properties.getPropertyString("recent.files..3", null));
        FileHistoryTest.assertNull((Object)properties.getPropertyString("recent.files..4", null));
    }
}

