/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param.editors;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import junit.framework.TestCase;
import org.esa.beam.framework.param.ParamEditor;
import org.esa.beam.framework.param.ParamProperties;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.framework.param.editors.BooleanExpressionEditor;
import org.esa.beam.framework.param.validators.BooleanExpressionValidator;

public class ExParamEditorsTest
extends TestCase {
    private static final String LABEL_NAME = "This is the label";
    private static final String UNIT_NAME = "This is the unit";
    private static final String PARAM_NAME = "theParamName";

    public void testGetComponentNames_BitmaskExprEditor() {
        ParamProperties properties = new ParamProperties(String.class);
        properties.setLabel(LABEL_NAME);
        properties.setPhysicalUnit(UNIT_NAME);
        properties.setDefaultValue((Object)Color.red);
        properties.setEditorClass(BooleanExpressionEditor.class);
        properties.setValidatorClass(BooleanExpressionValidator.class);
        Parameter parameter = new Parameter(PARAM_NAME, properties);
        ParamEditor editor = parameter.getEditor();
        ExParamEditorsTest.assertTrue((boolean)(editor instanceof BooleanExpressionEditor));
        BooleanExpressionEditor bitmaskExprEditor = (BooleanExpressionEditor)editor;
        JComponent editorComponent = bitmaskExprEditor.getEditorComponent();
        ExParamEditorsTest.assertEquals((String)"theParamName.XEditor", (String)editorComponent.getName());
        Component[] components = editorComponent.getComponents();
        ExParamEditorsTest.assertEquals((int)2, (int)components.length);
        ExParamEditorsTest.assertEquals((String)"theParamName.Editor", (String)components[0].getName());
        ExParamEditorsTest.assertEquals((String)"theParamName.ButtonPanel", (String)components[1].getName());
        ExParamEditorsTest.assertEquals((String)JTextField.class.getName(), (String)components[0].getClass().getName());
        ExParamEditorsTest.assertEquals((String)JPanel.class.getName(), (String)components[1].getClass().getName());
        JPanel buttonPanel = (JPanel)components[1];
        ExParamEditorsTest.assertEquals((int)1, (int)buttonPanel.getComponentCount());
        ExParamEditorsTest.assertEquals((String)JButton.class.getName(), (String)buttonPanel.getComponents()[0].getClass().getName());
        ExParamEditorsTest.assertEquals((String)"theParamName.Label", (String)bitmaskExprEditor.getLabelComponent().getName());
        ExParamEditorsTest.assertEquals((String)"This is the label: ", (String)bitmaskExprEditor.getLabelComponent().getText());
        ExParamEditorsTest.assertEquals((String)"theParamName.Unit", (String)bitmaskExprEditor.getPhysUnitLabelComponent().getName());
        ExParamEditorsTest.assertEquals((String)" This is the unit", (String)bitmaskExprEditor.getPhysUnitLabelComponent().getText());
    }
}

