/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import com.bc.ceres.swing.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.esa.snap.framework.ui.ModalDialog;
import org.esa.snap.framework.ui.UIUtils;
import org.esa.snap.framework.ui.tool.ToolButtonFactory;
import org.esa.snap.rcp.SnapApp;

public class NamesAssociationDialog
extends ModalDialog {
    private final AssociationModel associationModel;
    private final NameProvider nameProvider;
    private JTable aliasNames;
    private JScrollPane aliasNameScrollPane;
    private JList<String> centerNames;
    private JList<String> rightNames;
    private AbstractButton removeButton;
    private boolean shown = false;

    public static void show(AssociationModel associationModel, NameProvider nameProvider, String helpId) {
        new NamesAssociationDialog(associationModel, nameProvider, helpId).show();
    }

    private NamesAssociationDialog(AssociationModel associationModel, NameProvider nameProvider, String helpId) {
        super((Window)SnapApp.getDefault().getMainFrame(), nameProvider.windowTitle, 1, helpId);
        this.associationModel = associationModel;
        this.nameProvider = nameProvider;
        this.init();
    }

    public int show() {
        this.setButtonID(0);
        JDialog dialog = this.getJDialog();
        if (!this.shown) {
            dialog.pack();
            this.center();
        }
        dialog.setMinimumSize(dialog.getSize());
        dialog.setVisible(true);
        this.shown = true;
        return this.getButtonID();
    }

    private void init() {
        TableLayout layout = this.createLayout();
        JPanel mainPanel = new JPanel((LayoutManager)layout);
        mainPanel.add(new JLabel(this.nameProvider.aliasHeaderName));
        mainPanel.add(new JLabel(""));
        mainPanel.add(new JLabel(this.nameProvider.centerHeaderName));
        mainPanel.add(new JLabel(this.nameProvider.rightHeaderName));
        mainPanel.add(this.createAliasList());
        mainPanel.add(this.createButtonsPanel());
        mainPanel.add(this.createCenterList());
        mainPanel.add(this.createRightList());
        this.setContent(mainPanel);
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 1));
        AbstractButton addButton = ToolButtonFactory.createButton((Action)new AddAliasAction(), (boolean)false);
        this.removeButton = ToolButtonFactory.createButton((Action)new RemoveAliasAction(), (boolean)false);
        this.removeButton.setEnabled(false);
        buttonsPanel.add((Component)addButton, "North");
        buttonsPanel.add((Component)this.removeButton, "South");
        return buttonsPanel;
    }

    private TableLayout createLayout() {
        TableLayout layout = new TableLayout(4);
        layout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        layout.setTablePadding(new Insets(4, 4, 4, 4));
        layout.setColumnFill(0, TableLayout.Fill.BOTH);
        layout.setColumnFill(1, TableLayout.Fill.VERTICAL);
        layout.setColumnFill(2, TableLayout.Fill.BOTH);
        layout.setColumnFill(3, TableLayout.Fill.BOTH);
        layout.setRowFill(0, TableLayout.Fill.NONE);
        layout.setRowAnchor(0, TableLayout.Anchor.SOUTHWEST);
        layout.setRowWeightY(1, Double.valueOf(100.0));
        layout.setColumnWeightX(0, Double.valueOf(100.0));
        layout.setColumnWeightX(2, Double.valueOf(100.0));
        layout.setColumnWeightX(3, Double.valueOf(100.0));
        layout.setCellFill(0, 0, TableLayout.Fill.NONE);
        layout.setCellFill(0, 1, TableLayout.Fill.NONE);
        layout.setCellFill(0, 2, TableLayout.Fill.NONE);
        layout.setCellFill(0, 3, TableLayout.Fill.NONE);
        return layout;
    }

    private JComponent createAliasList() {
        this.aliasNames = new JTable();
        AbstractTableModel tableModel = new AbstractTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public int getRowCount() {
                return NamesAssociationDialog.this.associationModel.getAliasNames().size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                String beforeName = NamesAssociationDialog.this.getAliasNameAt(rowIndex);
                String changedName = aValue.toString();
                NamesAssociationDialog.this.associationModel.replaceAlias(beforeName, changedName);
                NamesAssociationDialog.this.aliasNameScrollPane.repaint();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return NamesAssociationDialog.this.getAliasNameAt(rowIndex);
            }
        };
        this.aliasNames.setModel(tableModel);
        this.aliasNames.setSelectionMode(1);
        this.aliasNames.setColumnSelectionAllowed(true);
        this.aliasNames.setRowSelectionAllowed(true);
        this.aliasNames.setTableHeader(null);
        this.aliasNames.getSelectionModel().addListSelectionListener(new AliasNamesSelectionListener());
        this.aliasNameScrollPane = new JScrollPane(this.aliasNames);
        this.aliasNameScrollPane.setPreferredSize(new Dimension(160, 200));
        this.aliasNameScrollPane.setMinimumSize(new Dimension(160, 200));
        return this.aliasNameScrollPane;
    }

    private String getAliasNameAt(int rowIndex) {
        Set<String> names = this.associationModel.getAliasNames();
        return names.toArray(new String[names.size()])[rowIndex];
    }

    private JComponent createCenterList() {
        this.centerNames = new JList<String>(new AbstractListModel<String>(){

            @Override
            public int getSize() {
                return NamesAssociationDialog.this.nameProvider.getCenterNames().length;
            }

            @Override
            public String getElementAt(int index) {
                return NamesAssociationDialog.this.nameProvider.getCenterNames()[index];
            }
        });
        this.centerNames.setSelectionMode(2);
        this.centerNames.addListSelectionListener(new CenterListSelectionListener(this.centerNames));
        this.centerNames.setEnabled(false);
        JScrollPane scrollPane = new JScrollPane(this.centerNames);
        scrollPane.setPreferredSize(new Dimension(160, 200));
        return scrollPane;
    }

    private JComponent createRightList() {
        this.rightNames = new JList<String>(new AbstractListModel<String>(){

            @Override
            public int getSize() {
                return NamesAssociationDialog.this.nameProvider.getRightNames().length;
            }

            @Override
            public String getElementAt(int index) {
                return NamesAssociationDialog.this.nameProvider.getRightNames()[index];
            }
        });
        this.rightNames.setSelectionMode(2);
        this.rightNames.addListSelectionListener(new RightListSelectionListener(this.rightNames));
        this.rightNames.setEnabled(false);
        JScrollPane scrollPane = new JScrollPane(this.rightNames);
        scrollPane.setPreferredSize(new Dimension(160, 200));
        return scrollPane;
    }

    private class AliasNamesSelectionListener
    implements ListSelectionListener {
        private AliasNamesSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean isSomeAliasSelected = NamesAssociationDialog.this.aliasNames.getSelectionModel().getMinSelectionIndex() != -1;
            NamesAssociationDialog.this.centerNames.setEnabled(isSomeAliasSelected);
            NamesAssociationDialog.this.rightNames.setEnabled(isSomeAliasSelected);
            NamesAssociationDialog.this.removeButton.setEnabled(isSomeAliasSelected);
            if (isSomeAliasSelected) {
                int[] selectedCenterIndices = this.getSelectedCenterIndices();
                int[] selectedRightIndices = this.getSelectedRightIndices();
                NamesAssociationDialog.this.centerNames.setSelectedIndices(selectedCenterIndices);
                NamesAssociationDialog.this.rightNames.setSelectedIndices(selectedRightIndices);
            } else {
                NamesAssociationDialog.this.centerNames.clearSelection();
                NamesAssociationDialog.this.rightNames.clearSelection();
            }
        }

        private int[] getSelectedCenterIndices() {
            String currentAlias = this.getCurrentAlias();
            List<String> selectedCenterNames = NamesAssociationDialog.this.associationModel.getCenterListNames(currentAlias);
            return this.getSelectedIndices(selectedCenterNames, NamesAssociationDialog.this.centerNames);
        }

        private int[] getSelectedRightIndices() {
            String currentAlias = this.getCurrentAlias();
            List<String> selectedRightNames = NamesAssociationDialog.this.associationModel.getRightListNames(currentAlias);
            return this.getSelectedIndices(selectedRightNames, NamesAssociationDialog.this.rightNames);
        }

        private String getCurrentAlias() {
            int minSelectionIndex = NamesAssociationDialog.this.aliasNames.getSelectionModel().getMinSelectionIndex();
            return NamesAssociationDialog.this.aliasNames.getModel().getValueAt(minSelectionIndex, 0).toString();
        }

        private int[] getSelectedIndices(List<String> selectedVariableNames, JList variableNames) {
            ArrayList<Integer> selectedIndices = new ArrayList<Integer>(selectedVariableNames.size());
            ListModel variableNamesModel = variableNames.getModel();
            for (int i = 0; i < variableNamesModel.getSize(); ++i) {
                String name = variableNamesModel.getElementAt(i).toString();
                if (!selectedVariableNames.contains(name)) continue;
                selectedIndices.add(i);
            }
            int[] selectedIndicesArray = new int[selectedIndices.size()];
            int i = 0;
            for (Integer index : selectedIndices) {
                selectedIndicesArray[i] = index;
                ++i;
            }
            return selectedIndicesArray;
        }
    }

    private class RightListSelectionListener
    extends VariableNamesSelectionListener {
        private RightListSelectionListener(JList variableNames) {
            super(variableNames);
        }

        @Override
        void addVariableName(String currentAlias, String variableName) {
            NamesAssociationDialog.this.associationModel.addFromRightList(currentAlias, variableName);
        }

        @Override
        void removeVariableName(String currentAlias, String variableName) {
            NamesAssociationDialog.this.associationModel.removeFromRightList(currentAlias, variableName);
        }
    }

    private class CenterListSelectionListener
    extends VariableNamesSelectionListener {
        private CenterListSelectionListener(JList variableNames) {
            super(variableNames);
        }

        @Override
        void addVariableName(String currentAlias, String variableName) {
            NamesAssociationDialog.this.associationModel.addFromCenterList(currentAlias, variableName);
        }

        @Override
        void removeVariableName(String currentAlias, String variableName) {
            NamesAssociationDialog.this.associationModel.removeFromCenterList(currentAlias, variableName);
        }
    }

    private abstract class VariableNamesSelectionListener
    implements ListSelectionListener {
        private final JList variableNames;

        private VariableNamesSelectionListener(JList variableNames) {
            this.variableNames = variableNames;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
            for (int index : this.variableNames.getSelectedIndices()) {
                selectedIndices.add(index);
            }
            int selectedAliasRow = NamesAssociationDialog.this.aliasNames.getSelectedRow();
            if (selectedAliasRow != -1) {
                String currentAlias = NamesAssociationDialog.this.aliasNames.getModel().getValueAt(selectedAliasRow, 0).toString();
                for (int i = 0; i < this.variableNames.getModel().getSize(); ++i) {
                    String variableName = this.variableNames.getModel().getElementAt(i).toString();
                    if (selectedIndices.contains(i)) {
                        this.addVariableName(currentAlias, variableName);
                        continue;
                    }
                    this.removeVariableName(currentAlias, variableName);
                }
            }
        }

        abstract void addVariableName(String var1, String var2);

        abstract void removeVariableName(String var1, String var2);
    }

    private class RemoveAliasAction
    extends AbstractAction {
        private RemoveAliasAction() {
            super("Remove alias", UIUtils.loadImageIcon((String)"icons/Minus16.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListSelectionModel selectionModel = NamesAssociationDialog.this.aliasNames.getSelectionModel();
            int minSelectionIndex = selectionModel.getMinSelectionIndex();
            int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
            selectionModel.clearSelection();
            if (minSelectionIndex != -1) {
                for (int i = maxSelectionIndex; i >= minSelectionIndex; --i) {
                    NamesAssociationDialog.this.associationModel.removeAlias(NamesAssociationDialog.this.getAliasNameAt(i));
                }
            }
            NamesAssociationDialog.this.removeButton.setEnabled(NamesAssociationDialog.this.associationModel.getAliasNames().size() > 0);
            NamesAssociationDialog.this.aliasNameScrollPane.repaint();
        }
    }

    private class AddAliasAction
    extends AbstractAction {
        private AddAliasAction() {
            super("Add alias", UIUtils.loadImageIcon((String)"icons/Plus16.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NamesAssociationDialog.this.associationModel.addAlias("...");
            NamesAssociationDialog.this.removeButton.setEnabled(true);
            NamesAssociationDialog.this.aliasNameScrollPane.repaint();
            int rowIndex = 0;
            for (String aliasName : NamesAssociationDialog.this.associationModel.getAliasNames()) {
                if (aliasName.equals("...")) break;
                ++rowIndex;
            }
            DefaultCellEditor editor = (DefaultCellEditor)NamesAssociationDialog.this.aliasNames.getCellEditor(rowIndex, 0);
            NamesAssociationDialog.this.aliasNames.editCellAt(rowIndex, 0);
            JTextField textField = (JTextField)editor.getComponent();
            textField.requestFocus();
            textField.selectAll();
        }
    }

    public static abstract class NameProvider {
        final String windowTitle;
        final String aliasHeaderName;
        final String centerHeaderName;
        final String rightHeaderName;

        public NameProvider(String windowTitle, String aliasHeaderName, String centerHeaderName, String rightHeaderName) {
            this.aliasHeaderName = aliasHeaderName;
            this.centerHeaderName = centerHeaderName;
            this.rightHeaderName = rightHeaderName;
            this.windowTitle = windowTitle;
        }

        public abstract String[] getCenterNames();

        public abstract String[] getRightNames();
    }

    public static interface AssociationModel {
        public List<String> getRightListNames(String var1);

        public List<String> getCenterListNames(String var1);

        public void addFromCenterList(String var1, String var2);

        public void addFromRightList(String var1, String var2);

        public void removeAlias(String var1);

        public void addAlias(String var1);

        public void removeFromRightList(String var1, String var2);

        public void removeFromCenterList(String var1, String var2);

        public Set<String> getAliasNames();

        public void replaceAlias(String var1, String var2);
    }
}

