/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.player;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.glevel.MultiLevelSource;
import java.awt.BorderLayout;
import java.lang.reflect.Field;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.snap.framework.datamodel.Band;
import org.esa.snap.framework.datamodel.ImageInfo;
import org.esa.snap.framework.datamodel.Mask;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductNode;
import org.esa.snap.framework.datamodel.ProductNodeEvent;
import org.esa.snap.framework.datamodel.RasterDataNode;
import org.esa.snap.framework.ui.product.ProductSceneImage;
import org.esa.snap.framework.ui.product.ProductSceneView;
import org.esa.snap.glevel.BandImageMultiLevelSource;
import org.esa.snap.netbeans.docwin.WindowUtilities;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.timeseries.core.TimeSeriesMapper;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesChangeEvent;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesListener;
import org.esa.snap.timeseries.ui.player.BlendImageLayer;
import org.esa.snap.timeseries.ui.player.Bundle;
import org.esa.snap.timeseries.ui.player.TimeSeriesPlayerForm;
import org.esa.snap.util.math.MathUtils;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="TimeSeriesPlayerTopComponent", iconBase="org/esa/snap/timeseries/ui/icons/timeseries-player.png", persistenceType=0)
public class TimeSeriesPlayerTopComponent
extends TopComponent {
    private static final String HELP_ID = "timeSeriesPlayer";
    private final TimeSeriesListener timeSeriesPlayerTSL;
    private ProductSceneView currentView;
    private TimeSeriesPlayerForm form;

    public TimeSeriesPlayerTopComponent() {
        this.initComponent();
        this.timeSeriesPlayerTSL = new TimeSeriesPlayerTSL();
        SnapApp.getDefault().getSelectionSupport(ProductSceneView.class).addHandler((SelectionSupport.Handler)new SceneViewSelectionChangeHandler());
    }

    private void initComponent() {
        this.form = new TimeSeriesPlayerForm(HELP_ID);
        this.form.getTimeSlider().addChangeListener(new SliderChangeListener());
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        if (view != null) {
            this.maybeUpdateCurrentView(view, view.getProduct().getProductType());
        }
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add(this.form, "Center");
        this.setDisplayName(Bundle.CTL_TimeSeriesPlayerTopComponentName());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    private void setCurrentView(ProductSceneView newView) {
        if (this.currentView != newView) {
            AbstractTimeSeries timeSeries;
            TimeSeriesMapper timeSeriesMapper = TimeSeriesMapper.getInstance();
            if (this.currentView != null && (timeSeries = timeSeriesMapper.getTimeSeries(this.currentView.getProduct())) != null) {
                timeSeries.removeTimeSeriesListener(this.timeSeriesPlayerTSL);
            }
            this.currentView = newView;
            this.form.setView(this.currentView);
            if (this.currentView != null) {
                Product currentProduct = this.currentView.getProduct();
                AbstractTimeSeries timeSeries2 = timeSeriesMapper.getTimeSeries(currentProduct);
                timeSeries2.addTimeSeriesListener(this.timeSeriesPlayerTSL);
                this.form.setTimeSeries(timeSeries2);
                this.exchangeRasterInProductSceneView(this.currentView.getRaster());
                this.reconfigureBaseImageLayer(this.currentView);
                this.form.configureTimeSlider(this.currentView.getRaster());
            } else {
                this.form.setTimeSeries(null);
                this.form.configureTimeSlider(null);
                this.form.getTimer().stop();
            }
        }
    }

    private void exchangeRasterInProductSceneView(RasterDataNode nextRaster) {
        RasterDataNode currentRaster = this.currentView.getRaster();
        ImageInfo imageInfoClone = currentRaster.getImageInfo(ProgressMonitor.NULL).createDeepCopy();
        nextRaster.setImageInfo(imageInfoClone);
        this.currentView.setRasters(new RasterDataNode[]{nextRaster});
        this.currentView.setImageInfo(imageInfoClone.createDeepCopy());
        this.getTCForView(this.currentView).setDisplayName(nextRaster.getDisplayName());
    }

    private TopComponent getTCForView(ProductSceneView view) {
        return WindowUtilities.getOpened(ProductSceneViewTopComponent.class).filter(topComponent -> view == topComponent.getView()).findFirst().orElse(null);
    }

    private void reconfigureBaseImageLayer(ProductSceneView sceneView) {
        Band band;
        Layer rootLayer = this.currentView.getRootLayer();
        ImageLayer baseImageLayer = (ImageLayer)LayerUtils.getChildLayerById((Layer)rootLayer, (String)"org.esa.snap.layers.baseImage");
        List<Band> bandList = this.form.getBandList(this.currentView.getRaster().getName());
        int nextIndex = bandList.indexOf(band = (Band)sceneView.getRaster()) + 1;
        if (nextIndex >= bandList.size()) {
            nextIndex = 0;
        }
        if (!(baseImageLayer instanceof BlendImageLayer)) {
            Band nextBand = bandList.get(nextIndex);
            BandImageMultiLevelSource nextLevelSource = BandImageMultiLevelSource.create((RasterDataNode)nextBand, (ProgressMonitor)ProgressMonitor.NULL);
            BlendImageLayer blendLayer = new BlendImageLayer(baseImageLayer.getMultiLevelSource(), (MultiLevelSource)nextLevelSource);
            List children = rootLayer.getChildren();
            int baseIndex = children.indexOf(baseImageLayer);
            children.remove(baseIndex);
            blendLayer.setId("org.esa.snap.layers.baseImage");
            blendLayer.setName(band.getDisplayName());
            blendLayer.setTransparency(0.0);
            children.add(baseIndex, blendLayer);
            this.configureSceneView(sceneView, (MultiLevelSource)blendLayer.getBaseMultiLevelSource());
        }
    }

    private void configureSceneView(ProductSceneView sceneView, MultiLevelSource multiLevelSource) {
        try {
            Field sceneImageField = ProductSceneView.class.getDeclaredField("sceneImage");
            sceneImageField.setAccessible(true);
            Object sceneImage = sceneImageField.get(sceneView);
            Field multiLevelSourceField = ProductSceneImage.class.getDeclaredField("bandImageMultiLevelSource");
            multiLevelSourceField.setAccessible(true);
            multiLevelSourceField.set(sceneImage, multiLevelSource);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private void maybeUpdateCurrentView(ProductSceneView view, String viewProductType) {
        if (!view.isRGB() && viewProductType.equals("org.esa.snap.glob.timeseries") && TimeSeriesMapper.getInstance().getTimeSeries(view.getProduct()) != null) {
            this.setCurrentView(view);
        }
    }

    private class TimeSeriesPlayerTSL
    extends TimeSeriesListener {
        private TimeSeriesPlayerTSL() {
        }

        @Override
        public void timeSeriesChanged(TimeSeriesChangeEvent event) {
            if (event.getType() == 8 || event.getType() == 16) {
                TimeSeriesPlayerTopComponent.this.form.configureTimeSlider(TimeSeriesPlayerTopComponent.this.currentView.getRaster());
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
            ProductNode productNode = event.getSourceNode();
            if (this.isValidProductNode(productNode) && TimeSeriesPlayerTopComponent.this.currentView != null) {
                TimeSeriesPlayerTopComponent.this.form.configureTimeSlider((RasterDataNode)productNode);
            }
        }

        public void nodeRemoved(ProductNodeEvent event) {
            ProductNode productNode = event.getSourceNode();
            if (this.isValidProductNode(productNode) && TimeSeriesPlayerTopComponent.this.currentView != null && TimeSeriesPlayerTopComponent.this.currentView.getRaster() == productNode) {
                TimeSeriesPlayerTopComponent.this.form.configureTimeSlider((RasterDataNode)productNode);
            }
        }

        public void nodeChanged(ProductNodeEvent event) {
            String propertyName = event.getPropertyName();
            if (propertyName.equals("imageInfo")) {
                this.adjustImageInfos(event);
            }
        }

        private boolean isValidProductNode(ProductNode productNode) {
            return productNode instanceof RasterDataNode && !(productNode instanceof Mask);
        }

        private void adjustImageInfos(ProductNodeEvent event) {
            ProductNode node = event.getSourceNode();
            if (this.isValidProductNode(node)) {
                RasterDataNode raster = (RasterDataNode)node;
                ImageLayer baseImageLayer = TimeSeriesPlayerTopComponent.this.currentView.getBaseImageLayer();
                ImageInfo imageInfo = raster.getImageInfo();
                if (baseImageLayer instanceof BlendImageLayer) {
                    BlendImageLayer blendLayer = (BlendImageLayer)baseImageLayer;
                    blendLayer.getBlendMultiLevelSource().setImageInfo(imageInfo.createDeepCopy());
                }
            }
        }
    }

    private class SliderChangeListener
    implements ChangeListener {
        private int value;

        private SliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (TimeSeriesPlayerTopComponent.this.currentView == null) {
                return;
            }
            int currentValue = TimeSeriesPlayerTopComponent.this.form.getTimeSlider().getValue();
            if (currentValue == this.value || currentValue == -1) {
                return;
            }
            if (TimeSeriesPlayerTopComponent.this.currentView.getBaseImageLayer() instanceof BlendImageLayer) {
                BlendImageLayer blendLayer = (BlendImageLayer)TimeSeriesPlayerTopComponent.this.currentView.getBaseImageLayer();
                int stepsPerTimespan = TimeSeriesPlayerTopComponent.this.form.getStepsPerTimespan();
                float transparency = (float)(currentValue % stepsPerTimespan) / (float)stepsPerTimespan;
                blendLayer.setBlendFactor(transparency);
                List<Band> bandList = TimeSeriesPlayerTopComponent.this.form.getBandList(TimeSeriesPlayerTopComponent.this.currentView.getRaster().getName());
                this.value = currentValue;
                int firstBandIndex = MathUtils.floorInt((double)((float)currentValue / (float)stepsPerTimespan));
                int secondBandIndex = MathUtils.ceilInt((double)((float)currentValue / (float)stepsPerTimespan));
                BandImageMultiLevelSource newSource = BandImageMultiLevelSource.create((RasterDataNode)((RasterDataNode)bandList.get(secondBandIndex)), (ProgressMonitor)ProgressMonitor.NULL);
                if (secondBandIndex == firstBandIndex) {
                    TimeSeriesPlayerTopComponent.this.exchangeRasterInProductSceneView((RasterDataNode)bandList.get(firstBandIndex));
                    blendLayer.setBaseLayer(newSource);
                    TimeSeriesPlayerTopComponent.this.configureSceneView(TimeSeriesPlayerTopComponent.this.currentView, (MultiLevelSource)blendLayer.getBaseMultiLevelSource());
                    blendLayer.setName(TimeSeriesPlayerTopComponent.this.currentView.getRaster().getDisplayName());
                    TimeSeriesPlayerTopComponent.this.currentView.firePropertyChange("timeProperty", -1, firstBandIndex);
                } else {
                    if (transparency == 1.0f / (float)stepsPerTimespan) {
                        blendLayer.setBlendLayer(newSource);
                    }
                    TimeSeriesPlayerTopComponent.this.currentView.getLayerCanvas().repaint();
                }
            }
        }
    }

    private class SceneViewSelectionChangeHandler
    implements SelectionSupport.Handler<ProductSceneView> {
        private SceneViewSelectionChangeHandler() {
        }

        public void selectionChange(ProductSceneView oldValue, ProductSceneView newValue) {
            if (TimeSeriesPlayerTopComponent.this.currentView == oldValue) {
                TimeSeriesPlayerTopComponent.this.setCurrentView(null);
            }
            if (TimeSeriesPlayerTopComponent.this.currentView != newValue) {
                if (newValue != null) {
                    RasterDataNode viewRaster = newValue.getRaster();
                    String viewProductType = viewRaster.getProduct().getProductType();
                    TimeSeriesPlayerTopComponent.this.maybeUpdateCurrentView(newValue, viewProductType);
                } else {
                    TimeSeriesPlayerTopComponent.this.setCurrentView(null);
                }
            }
        }
    }
}

