/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.player;

import com.bc.ceres.swing.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.Timer;
import org.esa.snap.framework.datamodel.Band;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.framework.datamodel.RasterDataNode;
import org.esa.snap.framework.ui.UIUtils;
import org.esa.snap.framework.ui.product.ProductSceneView;
import org.esa.snap.framework.ui.tool.ToolButtonFactory;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeCoding;
import org.esa.snap.timeseries.export.animations.AnimatedGifExport;
import org.openide.util.HelpCtx;

class TimeSeriesPlayerForm
extends JPanel {
    private final ImageIcon playIcon = new ImageIcon(this.getClass().getResource("icons/timeseries-play24.png"));
    private final ImageIcon stopIcon = new ImageIcon(this.getClass().getResource("icons/timeseries-stop24.png"));
    private final ImageIcon pauseIcon = UIUtils.loadImageIcon((String)"icons/Pause24.png");
    private final ImageIcon blendIcon = new ImageIcon(this.getClass().getResource("icons/timeseries-blend24.png"));
    private final ImageIcon repeatIcon = new ImageIcon(this.getClass().getResource("icons/timeseries-repeat24.png"));
    private final ImageIcon minusIcon = UIUtils.loadImageIcon((String)"icons/Remove16.png");
    private final ImageIcon plusIcon = UIUtils.loadImageIcon((String)"icons/Add16.png");
    private final ImageIcon exportIcon = UIUtils.loadImageIcon((String)"icons/Export24.gif");
    private final JSlider timeSlider;
    private final AbstractButton playButton;
    private final AbstractButton stopButton;
    private final JLabel dateLabel;
    private final JSlider speedSlider;
    private final JLabel speedLabel;
    private final JLabel speedUnit;
    private final AbstractButton blendButton;
    private Timer timer;
    private final AbstractButton repeatButton;
    private final AbstractButton minusButton;
    private final AbstractButton plusButton;
    private final AbstractButton exportButton;
    private int stepsPerTimespan = 1;
    private int timerDelay = 1250;
    private AbstractTimeSeries timeSeries;
    private ProductSceneView currentView;
    private static final String DATE_SEPARATOR = " ";

    TimeSeriesPlayerForm(String helpId) {
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setPreferredSize(new Dimension(350, 200));
        JPanel firstPanel = new JPanel((LayoutManager)TimeSeriesPlayerForm.createLayout());
        firstPanel.setPreferredSize(new Dimension(300, 150));
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        JPanel secondPanel = new JPanel(new BorderLayout());
        this.dateLabel = new JLabel("Date: ");
        this.timeSlider = this.createTimeSlider();
        this.playButton = this.createPlayButton();
        this.stopButton = this.createStopButton();
        this.repeatButton = this.createRepeatButton();
        this.blendButton = this.createBlendButton();
        this.speedLabel = new JLabel("Speed:");
        this.minusButton = this.createMinusButton();
        this.speedSlider = this.createSpeedSlider();
        this.speedUnit = new JLabel();
        this.plusButton = this.createPlusButton();
        this.exportButton = this.createExportButton();
        AbstractButton helpButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Help22.png"), (boolean)false);
        helpButton.setToolTipText("Help");
        helpButton.addActionListener(e -> new HelpCtx(helpId).display());
        this.updateSpeedUnit();
        this.setUIEnabled(false);
        buttonsPanel.add(this.playButton);
        buttonsPanel.add(this.stopButton);
        buttonsPanel.add(this.repeatButton);
        buttonsPanel.add(new JSeparator(1));
        buttonsPanel.add(this.blendButton);
        buttonsPanel.add(new JSeparator(1));
        buttonsPanel.add(this.speedLabel);
        buttonsPanel.add(this.minusButton);
        buttonsPanel.add(this.speedSlider);
        buttonsPanel.add(this.plusButton);
        buttonsPanel.add(this.speedUnit);
        buttonsPanel.add(new JLabel("           "));
        secondPanel.add((Component)this.exportButton, "North");
        secondPanel.add((Component)helpButton, "South");
        firstPanel.add(this.dateLabel);
        firstPanel.add(this.timeSlider);
        firstPanel.add(buttonsPanel);
        this.add("Center", firstPanel);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add("East", secondPanel);
    }

    List<Band> getBandList(String rasterName) {
        String variableName = AbstractTimeSeries.rasterToVariableName(rasterName);
        return this.timeSeries.getBandsForVariable(variableName);
    }

    void setTimeSeries(AbstractTimeSeries timeSeries) {
        this.timeSeries = timeSeries;
    }

    Timer getTimer() {
        return this.timer;
    }

    void setView(ProductSceneView view) {
        this.currentView = view;
    }

    int getStepsPerTimespan() {
        return this.stepsPerTimespan;
    }

    JSlider getTimeSlider() {
        return this.timeSlider;
    }

    void configureTimeSlider(RasterDataNode raster) {
        if (this.timeSeries != null) {
            List<Band> bandList = this.getBandList(raster.getName());
            this.timeSlider.setMinimum(0);
            int nodeCount = bandList.size();
            int maximum = (nodeCount - 1) * this.stepsPerTimespan;
            this.timeSlider.setMaximum(maximum);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            if (nodeCount > 1) {
                this.setUIEnabled(true);
                labelTable.put(0, new JLabel(this.createSliderLabelFormattedText(bandList, 0)));
                labelTable.put(maximum, new JLabel(this.createSliderLabelFormattedText(bandList, maximum / this.stepsPerTimespan)));
                this.timeSlider.setLabelTable(labelTable);
            } else {
                this.timeSlider.setLabelTable(null);
                this.setUIEnabled(false);
            }
            int index = bandList.indexOf(raster);
            if (index != -1) {
                this.timeSlider.setValue(index * this.stepsPerTimespan);
            }
        } else {
            this.timeSlider.setLabelTable(null);
            this.setUIEnabled(false);
        }
    }

    private String createSliderLabelText(List<Band> bandList, int index) {
        Band band = bandList.get(index);
        TimeCoding timeCoding = this.timeSeries.getRasterTimeMap().get(band);
        if (timeCoding != null) {
            ProductData.UTC utcStartTime = timeCoding.getStartTime();
            DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"dd-MMM-yyyy");
            DateFormat timeFormat = ProductData.UTC.createDateFormat((String)"HH:mm:ss");
            String dateText = dateFormat.format(utcStartTime.getAsCalendar().getTime());
            String timeText = timeFormat.format(utcStartTime.getAsCalendar().getTime());
            return dateText + DATE_SEPARATOR + timeText;
        }
        return "";
    }

    private String createSliderLabelFormattedText(List<Band> bandList, int index) {
        String labelText = this.createSliderLabelText(bandList, index);
        String[] strings = labelText.split(DATE_SEPARATOR);
        return String.format("<html><p align=\"center\"> <font size=\"2\">%s<br>%s</font></p>", strings[0], strings[1]);
    }

    private JSlider createTimeSlider() {
        JSlider timeSlider = new JSlider(0, 0, 0, 0);
        timeSlider.setMajorTickSpacing(this.stepsPerTimespan);
        timeSlider.setMinorTickSpacing(1);
        timeSlider.setPaintTrack(true);
        timeSlider.setSnapToTicks(true);
        timeSlider.setPaintTicks(true);
        timeSlider.addChangeListener(e -> {
            int index = timeSlider.getValue() / this.stepsPerTimespan;
            List<Band> bandList = this.getBandList(this.currentView.getRaster().getName());
            String labelText = this.createSliderLabelText(bandList, index);
            this.dateLabel.setText("Date: " + labelText);
        });
        timeSlider.setPreferredSize(new Dimension(320, 60));
        return timeSlider;
    }

    private AbstractButton createPlayButton() {
        ActionListener playAction = e -> {
            int currentValue = this.timeSlider.getValue();
            if (currentValue == this.timeSlider.getMaximum()) {
                if (this.repeatButton.isSelected()) {
                    currentValue = 0;
                } else {
                    this.playButton.setSelected(false);
                    this.timer.stop();
                    this.playButton.setIcon(this.playIcon);
                    this.playButton.setRolloverIcon(this.playIcon);
                    currentValue = 0;
                }
            } else {
                ++currentValue;
            }
            this.timeSlider.setValue(currentValue);
        };
        this.timer = new Timer(this.timerDelay, playAction);
        AbstractButton playButton = ToolButtonFactory.createButton((Icon)this.playIcon, (boolean)false);
        playButton.setToolTipText("Play the time series");
        playButton.setRolloverIcon(this.playIcon);
        playButton.addActionListener(e -> {
            if (playButton.getIcon() == this.playIcon) {
                this.timer.start();
                playButton.setIcon(this.pauseIcon);
                playButton.setRolloverIcon(this.pauseIcon);
            } else {
                this.timer.stop();
                int newValue = this.timeSlider.getValue() / this.stepsPerTimespan * this.stepsPerTimespan;
                this.timeSlider.setValue(newValue);
                playButton.setIcon(this.playIcon);
                playButton.setRolloverIcon(this.playIcon);
            }
        });
        return playButton;
    }

    private AbstractButton createStopButton() {
        AbstractButton stopButton = ToolButtonFactory.createButton((Icon)this.stopIcon, (boolean)false);
        stopButton.setToolTipText("Stop playing the time series");
        stopButton.addActionListener(e -> {
            this.timer.stop();
            this.timeSlider.setValue(0);
            this.playButton.setIcon(this.playIcon);
            this.playButton.setRolloverIcon(this.playIcon);
            this.playButton.setSelected(false);
        });
        return stopButton;
    }

    private AbstractButton createRepeatButton() {
        AbstractButton repeatButton = ToolButtonFactory.createButton((Icon)this.repeatIcon, (boolean)true);
        repeatButton.setToolTipText("Toggle repeat");
        return repeatButton;
    }

    private AbstractButton createBlendButton() {
        AbstractButton blendButton = ToolButtonFactory.createButton((Icon)this.blendIcon, (boolean)true);
        blendButton.setToolTipText("Toggle blending mode");
        blendButton.addActionListener(e -> {
            if (blendButton.isSelected()) {
                this.stepsPerTimespan = 8;
                this.timeSlider.setValue(0);
                this.timer.setDelay(this.calculateTimerDelay());
                this.configureTimeSlider(this.currentView.getRaster());
            } else {
                this.stepsPerTimespan = 1;
                this.timeSlider.setValue(0);
                this.timer.setDelay(this.calculateTimerDelay());
                this.configureTimeSlider(this.currentView.getRaster());
            }
        });
        return blendButton;
    }

    private AbstractButton createMinusButton() {
        AbstractButton minusButton = ToolButtonFactory.createButton((Icon)this.minusIcon, (boolean)false);
        minusButton.setToolTipText("Decrease playing speed");
        minusButton.addActionListener(e -> {
            if (this.speedSlider.getValue() > this.speedSlider.getMinimum()) {
                this.speedSlider.setValue(this.speedSlider.getValue() - 1);
            }
        });
        return minusButton;
    }

    private JSlider createSpeedSlider() {
        JSlider speedSlider = new JSlider(1, 10);
        speedSlider.setToolTipText("Choose the playing speed");
        speedSlider.setSnapToTicks(true);
        speedSlider.setPaintTrack(true);
        speedSlider.setPaintTicks(true);
        speedSlider.setPaintLabels(true);
        speedSlider.setValue(6);
        speedSlider.setPreferredSize(new Dimension(80, speedSlider.getPreferredSize().height));
        speedSlider.addChangeListener(e -> {
            this.timerDelay = this.calculateTimerDelay();
            this.timer.setDelay(this.timerDelay);
            this.updateSpeedUnit();
        });
        return speedSlider;
    }

    private AbstractButton createPlusButton() {
        AbstractButton plusButton = ToolButtonFactory.createButton((Icon)this.plusIcon, (boolean)false);
        plusButton.setToolTipText("Increase playing speed");
        plusButton.addActionListener(e -> {
            if (this.speedSlider.getValue() < this.speedSlider.getMaximum()) {
                this.speedSlider.setValue(this.speedSlider.getValue() + 1);
            }
        });
        return plusButton;
    }

    private AbstractButton createExportButton() {
        AbstractButton exportButton = ToolButtonFactory.createButton((Icon)this.exportIcon, (boolean)false);
        exportButton.setToolTipText("Export as animated gif");
        exportButton.addActionListener(e -> {
            AnimatedGifExport export = new AnimatedGifExport(this, "Export time series as animated gif");
            String varName = AbstractTimeSeries.rasterToVariableName(this.currentView.getRaster().getName());
            export.createFrames(this.timeSeries.getBandsForVariable(varName));
            export.executeWithBlocking();
        });
        return exportButton;
    }

    private void setUIEnabled(boolean enable) {
        this.dateLabel.setEnabled(enable);
        this.timeSlider.setPaintLabels(enable);
        this.timeSlider.setEnabled(enable);
        this.playButton.setEnabled(enable);
        this.stopButton.setEnabled(enable);
        this.repeatButton.setEnabled(enable);
        this.blendButton.setEnabled(enable);
        this.speedLabel.setEnabled(enable);
        this.minusButton.setEnabled(enable);
        this.speedSlider.setEnabled(enable);
        this.speedUnit.setEnabled(enable);
        this.plusButton.setEnabled(enable);
        this.exportButton.setEnabled(enable);
    }

    private int calculateTimerDelay() {
        return 250 / this.stepsPerTimespan * (11 - this.speedSlider.getValue());
    }

    private void updateSpeedUnit() {
        double fps = 1.0 / ((double)(this.timerDelay * this.stepsPerTimespan) / 1000.0);
        DecimalFormat formatter = new DecimalFormat("0.00");
        this.speedUnit.setText(formatter.format(fps) + " FPS");
        this.speedUnit.setToolTipText(formatter.format(fps) + " Frames per second");
    }

    private static TableLayout createLayout() {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setRowPadding(0, new Insets(4, 4, 4, 0));
        tableLayout.setColumnWeightX(0, Double.valueOf(1.0));
        tableLayout.setRowWeightY(1, Double.valueOf(1.0));
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setRowFill(1, TableLayout.Fill.BOTH);
        return tableLayout;
    }
}

