/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.player;

import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import org.esa.snap.glevel.BandImageMultiLevelSource;

class BlendImageLayer
extends ImageLayer {
    private ImageLayer baseLayer;
    private ImageLayer blendLayer;
    private float blendFactor = 0.0f;

    BlendImageLayer(MultiLevelSource baseMultiLevelSource, MultiLevelSource blendMultiLevelSource) {
        super(DefaultMultiLevelSource.NULL);
        this.baseLayer = new ImageLayer(baseMultiLevelSource);
        this.blendLayer = new ImageLayer(blendMultiLevelSource);
    }

    void setBlendFactor(float factor) {
        this.blendFactor = factor;
    }

    public MultiLevelSource getMultiLevelSource() {
        return this.getBaseMultiLevelSource();
    }

    public BandImageMultiLevelSource getBaseMultiLevelSource() {
        return (BandImageMultiLevelSource)this.baseLayer.getMultiLevelSource();
    }

    public BandImageMultiLevelSource getBlendMultiLevelSource() {
        return (BandImageMultiLevelSource)this.blendLayer.getMultiLevelSource();
    }

    public AffineTransform getImageToModelTransform(int level) {
        return this.baseLayer.getImageToModelTransform(level);
    }

    public AffineTransform getModelToImageTransform(int level) {
        return this.baseLayer.getModelToImageTransform(level);
    }

    public RenderedImage getImage(int level) {
        return this.baseLayer.getImage(level);
    }

    public int getLevel(Viewport vp) {
        return BlendImageLayer.getLevel((MultiLevelModel)this.getBaseMultiLevelSource().getModel(), (Viewport)vp);
    }

    protected Rectangle2D getLayerModelBounds() {
        return this.getBaseMultiLevelSource().getModel().getModelBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderLayer(Rendering rendering) {
        Graphics2D graphics = rendering.getGraphics();
        Composite oldComposite = graphics.getComposite();
        try {
            float layerAlpha = 1.0f - (float)this.getTransparency();
            float baseLayerAlpha = (1.0f - this.blendFactor) * layerAlpha;
            graphics.setComposite(AlphaComposite.getInstance(3, baseLayerAlpha));
            if (baseLayerAlpha != 0.0f) {
                this.baseLayer.render(rendering);
            }
            float blendLayerAlpha = this.blendFactor * layerAlpha;
            graphics.setComposite(AlphaComposite.getInstance(3, blendLayerAlpha));
            if (blendLayerAlpha != 0.0f) {
                this.blendLayer.render(rendering);
            }
        }
        finally {
            graphics.setComposite(oldComposite);
        }
    }

    public void regenerate() {
        this.baseLayer.regenerate();
        this.blendLayer.regenerate();
    }

    protected synchronized void disposeLayer() {
        super.disposeLayer();
        this.baseLayer.dispose();
        this.blendLayer.dispose();
    }

    void setBaseLayer(BandImageMultiLevelSource multiLevelSource) {
        this.baseLayer = new ImageLayer((MultiLevelSource)multiLevelSource);
    }

    void setBlendLayer(BandImageMultiLevelSource multiLevelSource) {
        this.blendLayer = new ImageLayer((MultiLevelSource)multiLevelSource);
    }
}

