/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.matrix;

import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.swing.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import org.esa.snap.framework.datamodel.Band;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.framework.datamodel.ProductNode;
import org.esa.snap.framework.datamodel.ProductNodeEvent;
import org.esa.snap.framework.datamodel.RasterDataNode;
import org.esa.snap.framework.ui.PixelPositionListener;
import org.esa.snap.framework.ui.UIUtils;
import org.esa.snap.framework.ui.product.ProductSceneView;
import org.esa.snap.framework.ui.tool.ToolButtonFactory;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.timeseries.core.TimeSeriesMapper;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeCoding;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesListener;
import org.esa.snap.timeseries.ui.matrix.Bundle;
import org.esa.snap.timeseries.ui.matrix.MatrixCellRenderer;
import org.esa.snap.timeseries.ui.matrix.MatrixTableModel;
import org.esa.snap.util.math.MathUtils;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="TimeSeriesMatrixTopComponent", iconBase="org/esa/snap/timeseries/ui/icons/timeseries-matrix.png", persistenceType=0)
public class TimeSeriesMatrixTopComponent
extends TopComponent {
    private static final String HELP_ID = "timeSeriesMatrix";
    private static final int MATRIX_MINIMUM = 3;
    private static final int MATRIX_DEFAULT_VALUE = 3;
    private static final int MATRIX_MAXIMUM = 15;
    private static final int MATRIX_STEP_SIZE = 2;
    private JSpinner matrixSizeSpinner;
    private JLabel dateLabel;
    private ProductSceneView currentView;
    private AbstractTimeSeries timeSeries;
    private final SceneViewHandler sceneViewListener;
    private final TimeSeriesPPL pixelPosListener = new TimeSeriesPPL();
    private final MatrixMouseWheelListener mouseWheelListener;
    private final TimeSeriesListener timeSeriesMatrixTSL;
    private static final String DATE_PREFIX = "Date: ";
    private MatrixTableModel matrixModel;
    private final DateFormat dateFormat;
    private MatrixCellRenderer matrixCellRenderer;

    public TimeSeriesMatrixTopComponent() {
        this.sceneViewListener = new SceneViewHandler();
        this.mouseWheelListener = new MatrixMouseWheelListener();
        this.timeSeriesMatrixTSL = new TimeSeriesMatrixTSL();
        this.dateFormat = ProductData.UTC.createDateFormat((String)"dd-MMM-yyyy HH:mm:ss");
        this.initUI();
    }

    private void initUI() {
        SnapApp.getDefault().getSelectionSupport(ProductSceneView.class).addHandler((SelectionSupport.Handler)this.sceneViewListener);
        this.dateLabel = new JLabel(String.format("Date:  %s", this.getStartDateString()));
        this.matrixSizeSpinner = new JSpinner(new SpinnerNumberModel(3, 3, 15, 2));
        JComponent editor = this.matrixSizeSpinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            ((JSpinner.DefaultEditor)editor).getTextField().setEditable(false);
        }
        this.matrixSizeSpinner.addChangeListener(e -> this.matrixModel.setMatrixSize((Integer)this.matrixSizeSpinner.getModel().getValue()));
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableWeightX(Double.valueOf(0.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setColumnWeightX(0, Double.valueOf(1.0));
        tableLayout.setRowWeightY(1, Double.valueOf(1.0));
        tableLayout.setCellColspan(0, 0, Integer.valueOf(2));
        this.setLayout((LayoutManager)tableLayout);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel buttonPanel = this.createButtonPanel();
        JPanel tablePanel = this.createTablePanel();
        this.add(this.dateLabel);
        this.add(tablePanel);
        this.add(buttonPanel);
        this.setCurrentView(SnapApp.getDefault().getSelectedProductSceneView());
        this.setDisplayName(Bundle.CTL_TimeSeriesMatrixTopComponentName());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    protected void componentShowing() {
        this.addMouseWheelListener();
    }

    public void componentOpened() {
        this.addMouseWheelListener();
    }

    public void componentClosed() {
        this.removeMouseWheelListener();
    }

    public void componentHidden() {
        this.removeMouseWheelListener();
    }

    private JPanel createTablePanel() {
        JPanel mainPanel = new JPanel(new BorderLayout(4, 4));
        this.matrixModel = new MatrixTableModel();
        JTable matrixTable = new JTable(this.matrixModel);
        this.matrixCellRenderer = new MatrixCellRenderer(this.matrixModel);
        matrixTable.setDefaultRenderer(Double.class, this.matrixCellRenderer);
        matrixTable.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        mainPanel.add("Center", matrixTable);
        return mainPanel;
    }

    private String getStartDateString() {
        String startDateString = "";
        if (this.currentView != null && this.timeSeries != null) {
            TimeCoding timeCoding = this.timeSeries.getRasterTimeMap().get(this.currentView.getRaster());
            Date startDate = timeCoding.getStartTime().getAsDate();
            startDateString = this.dateFormat.format(startDate);
        }
        return startDateString;
    }

    private JPanel createButtonPanel() {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setRowPadding(0, new Insets(0, 4, 4, 4));
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        JPanel buttonPanel = new JPanel((LayoutManager)tableLayout);
        AbstractButton helpButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Help22.png"), (boolean)false);
        helpButton.addActionListener(e -> new HelpCtx(HELP_ID).display());
        helpButton.setToolTipText("Help");
        buttonPanel.add(this.matrixSizeSpinner);
        buttonPanel.add(tableLayout.createVerticalSpacer());
        buttonPanel.add(helpButton);
        return buttonPanel;
    }

    private void setCurrentView(ProductSceneView newView) {
        if (this.currentView == newView) {
            return;
        }
        if (this.currentView != null) {
            this.currentView.removePixelPositionListener((PixelPositionListener)this.pixelPosListener);
            this.removeMouseWheelListener();
            if (this.timeSeries != null) {
                this.timeSeries.removeTimeSeriesListener(this.timeSeriesMatrixTSL);
            }
        }
        this.currentView = newView;
        if (this.isTimeSeriesView(this.currentView)) {
            this.currentView.addPixelPositionListener((PixelPositionListener)this.pixelPosListener);
            this.timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(this.currentView.getProduct());
            this.timeSeries.addTimeSeriesListener(this.timeSeriesMatrixTSL);
            this.addMouseWheelListener();
            RasterDataNode raster = this.currentView.getRaster();
            if (raster instanceof Band) {
                this.matrixModel.setBand((Band)raster);
                this.matrixModel.setMatrixSize((Integer)this.matrixSizeSpinner.getValue());
                this.matrixCellRenderer.setInvalidColor(this.currentView.getLayerCanvas().getBackground());
                this.updateDateLabel((Band)this.currentView.getRaster());
            }
        } else {
            this.timeSeries = null;
            this.matrixModel.setMatrixSize(0);
        }
    }

    private void updateDateLabel(Band band) {
        String dateString = "";
        if (band != null) {
            TimeCoding timeCoding = this.timeSeries.getRasterTimeMap().get(band);
            Date startTime = timeCoding.getStartTime().getAsDate();
            dateString = this.dateFormat.format(startTime);
        }
        this.dateLabel.setText(String.format("Date:  %s", dateString));
    }

    private Band getNextBand(Band currentBand, int direction) {
        String varName = AbstractTimeSeries.rasterToVariableName(currentBand.getName());
        List<Band> bandList = this.timeSeries.getBandsForVariable(varName);
        int currentIndex = bandList.indexOf(currentBand);
        if (direction < 0) {
            if (currentIndex > 0) {
                return bandList.get(currentIndex - 1);
            }
        } else if (currentIndex + 1 < bandList.size()) {
            return bandList.get(currentIndex + 1);
        }
        return currentBand;
    }

    private boolean isTimeSeriesView(ProductSceneView view) {
        if (view != null) {
            RasterDataNode viewRaster = view.getRaster();
            String viewProductType = viewRaster.getProduct().getProductType();
            return !view.isRGB() && viewProductType.equals("org.esa.snap.glob.timeseries") && TimeSeriesMapper.getInstance().getTimeSeries(view.getProduct()) != null;
        }
        return false;
    }

    private void addMouseWheelListener() {
        LayerCanvas layerCanvas;
        List<MouseWheelListener> listeners;
        if (this.currentView != null && !(listeners = Arrays.asList((layerCanvas = this.currentView.getLayerCanvas()).getMouseWheelListeners())).contains(this.mouseWheelListener)) {
            layerCanvas.addMouseWheelListener((MouseWheelListener)this.mouseWheelListener);
        }
    }

    private void removeMouseWheelListener() {
        if (this.currentView != null) {
            this.currentView.getLayerCanvas().removeMouseWheelListener((MouseWheelListener)this.mouseWheelListener);
        }
    }

    private class TimeSeriesMatrixTSL
    extends TimeSeriesListener {
        private TimeSeriesMatrixTSL() {
        }

        public void nodeRemoved(ProductNodeEvent event) {
            ProductNode node = event.getSourceNode();
            if (node == TimeSeriesMatrixTopComponent.this.matrixModel.getBand()) {
                Band band = TimeSeriesMatrixTopComponent.this.matrixModel.getBand();
                Band nextBand = TimeSeriesMatrixTopComponent.this.getNextBand(band, 1);
                if (nextBand == band) {
                    nextBand = TimeSeriesMatrixTopComponent.this.getNextBand(band, -1);
                }
                if (nextBand == band) {
                    nextBand = null;
                }
                TimeSeriesMatrixTopComponent.this.updateDateLabel(nextBand);
            }
        }
    }

    private class MatrixMouseWheelListener
    implements MouseWheelListener {
        private MatrixMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Band nextBand;
            if (e.isAltDown() && (nextBand = TimeSeriesMatrixTopComponent.this.getNextBand(TimeSeriesMatrixTopComponent.this.matrixModel.getBand(), e.getWheelRotation())) != null) {
                TimeSeriesMatrixTopComponent.this.matrixModel.setBand(nextBand);
                TimeSeriesMatrixTopComponent.this.updateDateLabel(nextBand);
            }
        }
    }

    private class TimeSeriesPPL
    implements PixelPositionListener {
        private TimeSeriesPPL() {
        }

        public void pixelPosChanged(ImageLayer imageLayer, int pixelX, int pixelY, int currentLevel, boolean pixelPosValid, MouseEvent e) {
            if (TimeSeriesMatrixTopComponent.this.isVisible() && TimeSeriesMatrixTopComponent.this.currentView != null) {
                AffineTransform i2mTransform = imageLayer.getImageToModelTransform(currentLevel);
                Point2D modelP = i2mTransform.transform(new Point2D.Double((double)pixelX + 0.5, (double)pixelY + 0.5), null);
                AffineTransform m2iTransform = imageLayer.getModelToImageTransform();
                Point2D levelZeroP = m2iTransform.transform(modelP, null);
                TimeSeriesMatrixTopComponent.this.matrixModel.setCenterPixel(MathUtils.floorInt((double)levelZeroP.getX()), MathUtils.floorInt((double)levelZeroP.getY()));
            }
        }

        public void pixelPosNotAvailable() {
            TimeSeriesMatrixTopComponent.this.matrixModel.clearMatrix();
        }
    }

    private class SceneViewHandler
    implements SelectionSupport.Handler<ProductSceneView> {
        private SceneViewHandler() {
        }

        public void selectionChange(ProductSceneView oldValue, ProductSceneView newValue) {
            if (TimeSeriesMatrixTopComponent.this.currentView == oldValue) {
                TimeSeriesMatrixTopComponent.this.setCurrentView(null);
            }
            TimeSeriesMatrixTopComponent.this.setCurrentView(newValue);
        }
    }
}

