/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.matrix;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.esa.snap.framework.datamodel.Band;
import org.esa.snap.framework.datamodel.ImageInfo;
import org.esa.snap.jai.ImageManager;
import org.esa.snap.timeseries.ui.matrix.MatrixTableModel;

class MatrixCellRenderer
extends DefaultTableCellRenderer {
    private final MatrixTableModel tableModel;
    private final DecimalFormat valueFormatter;
    private final Font boldFont;
    private Color invalidColor;

    MatrixCellRenderer(MatrixTableModel tableModel) {
        this.tableModel = tableModel;
        this.valueFormatter = new DecimalFormat("0.0000");
        this.boldFont = this.getFont().deriveFont(1);
    }

    public void setInvalidColor(Color invalidColor) {
        this.invalidColor = invalidColor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String labelText;
        Color bgColor;
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Double rasterValue = (Double)value;
        Band raster = this.tableModel.getBand();
        if (raster != null && rasterValue != null) {
            if (Double.isNaN(rasterValue)) {
                bgColor = this.invalidColor;
                labelText = "NaN";
            } else {
                ImageInfo imageInfo = raster.getImageInfo();
                bgColor = ImageManager.computeColor((ImageInfo)imageInfo, (Double)rasterValue);
                labelText = this.valueFormatter.format(rasterValue);
            }
        } else {
            bgColor = Color.WHITE;
            labelText = "";
        }
        label.setBackground(bgColor);
        label.setForeground(this.findForegroundColor(bgColor));
        label.setText(labelText);
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setFont(this.boldFont);
        return label;
    }

    private Color findForegroundColor(Color bgColor) {
        boolean colorBrightDiffBlackGood;
        int colorDiffWhite = MatrixCellRenderer.getColorDifference(Color.WHITE, bgColor);
        int colorBrightDiffWhite = this.getColorBrightnessDifference(Color.WHITE, bgColor);
        int colorDiffBlack = MatrixCellRenderer.getColorDifference(Color.BLACK, bgColor);
        int colorBrightDiffBlack = this.getColorBrightnessDifference(Color.BLACK, bgColor);
        boolean colorDiffWhiteGood = colorDiffWhite >= 500;
        boolean colorDiffBlackGood = colorDiffBlack >= 500;
        boolean colorBrightDiffWhiteGood = colorBrightDiffWhite >= 125;
        boolean bl = colorBrightDiffBlackGood = colorBrightDiffBlack >= 125;
        if (colorDiffWhiteGood && colorBrightDiffWhiteGood) {
            return Color.WHITE;
        }
        if (colorDiffBlackGood && colorBrightDiffBlackGood) {
            return Color.BLACK;
        }
        if (colorDiffWhiteGood || colorBrightDiffWhiteGood) {
            return Color.WHITE;
        }
        if (colorDiffBlackGood || colorBrightDiffBlackGood) {
            return Color.BLACK;
        }
        if (colorDiffWhite + colorBrightDiffWhite > colorDiffBlack + colorBrightDiffBlack) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    private int getColorBrightnessDifference(Color color1, Color color2) {
        int colorBright1 = (color1.getRed() * 299 + color1.getGreen() * 587 + color1.getBlue() * 114) / 1000;
        int colorBright2 = (color2.getRed() * 299 + color2.getGreen() * 587 + color2.getBlue() * 114) / 1000;
        return Math.abs(colorBright1 - colorBright2);
    }

    private static int getColorDifference(Color color1, Color color2) {
        return Math.max(color1.getRed(), color2.getRed()) - Math.min(color1.getRed(), color2.getRed()) + Math.max(color1.getGreen(), color2.getGreen()) - Math.min(color1.getGreen(), color2.getGreen()) + Math.max(color1.getBlue(), color2.getBlue()) - Math.min(color1.getBlue(), color2.getBlue());
    }
}

