/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.manager;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.swing.border.EmptyBorder;
import org.esa.snap.framework.datamodel.GeoCoding;
import org.esa.snap.framework.datamodel.GeoPos;
import org.esa.snap.framework.datamodel.PinDescriptor;
import org.esa.snap.framework.datamodel.PixelPos;
import org.esa.snap.framework.datamodel.Placemark;
import org.esa.snap.framework.datamodel.PlacemarkDescriptor;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductManager;
import org.esa.snap.framework.datamodel.ProductNode;
import org.esa.snap.framework.datamodel.ProductNodeEvent;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.timeseries.core.TimeSeriesMapper;
import org.esa.snap.timeseries.core.insitu.InsituSource;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesChangeEvent;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesListener;
import org.esa.snap.timeseries.ui.manager.Bundle;
import org.esa.snap.timeseries.ui.manager.TimeSeriesManagerForm;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="TimeSeriesManagerTopComponent", iconBase="org/esa/snap/timeseries/ui/icons/timeseries-manager.png", persistenceType=0)
public class TimeSeriesManagerTopComponent
extends TopComponent {
    private static final String HELP_ID = "timeSeriesManager";
    private Product selectedProduct;
    private String prefixTitle;
    private final WeakHashMap<Product, TimeSeriesManagerForm> formMap;
    private TimeSeriesManagerForm activeForm;
    private final TimeSeriesManagerTSL timeSeriesManagerTSL;

    public TimeSeriesManagerTopComponent() {
        this.setName(Bundle.CTL_TimeSeriesManagerTopComponent_ComponentName());
        this.formMap = new WeakHashMap();
        this.timeSeriesManagerTSL = new TimeSeriesManagerTSL();
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.prefixTitle = Bundle.CTL_TimeSeriesManagerTopComponent_Name();
        this.setSelectedProduct(SnapApp.getDefault().getSelectedProduct());
        this.realizeActiveForm();
        this.updateTitle();
        SnapApp.getDefault().getSelectionSupport(ProductNode.class).addHandler((oldValue, newValue) -> {
            if (newValue != null) {
                this.setSelectedProduct(newValue.getProduct());
            } else {
                this.setSelectedProduct(null);
            }
        });
        SnapApp.getDefault().getProductManager().addListener(new ProductManager.Listener(){

            public void productAdded(ProductManager.Event event) {
            }

            public void productRemoved(ProductManager.Event event) {
                TimeSeriesManagerTopComponent.this.productClosed(event.getProduct());
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    Product getSelectedProduct() {
        return this.selectedProduct;
    }

    private void productClosed(Product product) {
        this.formMap.remove(product);
        this.setSelectedProduct(null);
    }

    private void updateTitle() {
        Product product = this.getSelectedProduct();
        String suffix = product != null ? " - " + product.getDisplayName() : "";
        this.setDisplayName(this.prefixTitle + suffix);
    }

    private void setSelectedProduct(Product newProduct) {
        Product oldProduct = this.selectedProduct;
        if (newProduct != oldProduct) {
            AbstractTimeSeries timeSeries;
            if (oldProduct != null && (timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(oldProduct)) != null) {
                timeSeries.removeTimeSeriesListener(this.timeSeriesManagerTSL);
            }
            this.selectedProduct = newProduct;
            this.realizeActiveForm();
            this.updateTitle();
            if (newProduct != null && (timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(newProduct)) != null) {
                timeSeries.addTimeSeriesListener(this.timeSeriesManagerTSL);
            }
        }
    }

    private void realizeActiveForm() {
        if (this.getComponentCount() > 0) {
            this.remove(0);
        }
        this.activeForm = this.getOrCreateActiveForm(this.getSelectedProduct());
        this.add(this.activeForm.getControl(), "Center");
        this.validate();
        this.repaint();
    }

    private TimeSeriesManagerForm getOrCreateActiveForm(Product product) {
        if (this.formMap.containsKey(product)) {
            this.activeForm = this.formMap.get(product);
        } else {
            this.activeForm = new TimeSeriesManagerForm(HELP_ID);
            this.formMap.put(product, this.activeForm);
        }
        this.activeForm.updateFormControl(product);
        return this.activeForm;
    }

    private void updateInsituPins() {
        AbstractTimeSeries timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(this.selectedProduct);
        timeSeries.clearInsituPlacemarks();
        this.addPlacemarks(timeSeries);
    }

    private void addPlacemarks(AbstractTimeSeries timeSeries) {
        InsituSource insituSource = timeSeries.getInsituSource();
        List<String> selectedInsituVariables = this.getSelectedInsituVariables(timeSeries, insituSource);
        TreeSet<GeoPos> geoPoses = new TreeSet<GeoPos>(this.createGeoPosComparator());
        for (String selectedInsituVariable : selectedInsituVariables) {
            geoPoses.addAll(insituSource.getInsituPositionsFor(selectedInsituVariable));
        }
        Product tsProduct = timeSeries.getTsProduct();
        GeoCoding geoCoding = tsProduct.getGeoCoding();
        PixelPos pixelPos = new PixelPos();
        for (GeoPos geoPos : geoPoses) {
            geoCoding.getPixelPos(geoPos, pixelPos);
            if (!AbstractTimeSeries.isPixelValid(tsProduct, pixelPos)) continue;
            String name = insituSource.hasStationNames() ? insituSource.getNameFor(geoPos) : geoPos.getLatString() + "_" + geoPos.getLonString();
            String pinName = "Insitu_" + name;
            String pinLabel = name;
            String pinDescription = name;
            Placemark placemark = Placemark.createPointPlacemark((PlacemarkDescriptor)PinDescriptor.getInstance(), (String)pinName, (String)pinLabel, (String)pinDescription, null, (GeoPos)new GeoPos(geoPos), (GeoCoding)geoCoding);
            timeSeries.registerRelation(placemark, geoPos);
        }
    }

    private Comparator<GeoPos> createGeoPosComparator() {
        return (o1, o2) -> o1.toString().compareTo(o2.toString());
    }

    private List<String> getSelectedInsituVariables(AbstractTimeSeries timeSeries, InsituSource insituSource) {
        String[] parameterNames = insituSource.getParameterNames();
        ArrayList<String> selectedInsituVariables = new ArrayList<String>();
        for (String parameterName : parameterNames) {
            if (!timeSeries.isInsituVariableSelected(parameterName)) continue;
            selectedInsituVariables.add(parameterName);
        }
        return selectedInsituVariables;
    }

    private class TimeSeriesManagerTSL
    extends TimeSeriesListener {
        private TimeSeriesManagerTSL() {
        }

        @Override
        public void timeSeriesChanged(TimeSeriesChangeEvent event) {
            int type = event.getType();
            if (type == 2 || type == 4) {
                TimeSeriesManagerTopComponent.this.activeForm.updateFormControl(TimeSeriesManagerTopComponent.this.getSelectedProduct());
            } else if (type == 64) {
                TimeSeriesManagerTopComponent.this.updateInsituPins();
            }
        }

        public void nodeChanged(ProductNodeEvent event) {
            TimeSeriesManagerTopComponent.this.activeForm.updateFormControl(TimeSeriesManagerTopComponent.this.getSelectedProduct());
        }
    }
}

