/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.manager;

import com.bc.ceres.swing.TableLayout;
import com.jidesoft.swing.TitledSeparator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.esa.snap.framework.datamodel.Band;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.framework.datamodel.RasterDataNode;
import org.esa.snap.framework.ui.UIUtils;
import org.esa.snap.framework.ui.tool.ToolButtonFactory;
import org.esa.snap.netbeans.docwin.WindowUtilities;
import org.esa.snap.rcp.actions.file.OpenImageViewAction;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.timeseries.core.TimeSeriesMapper;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.AxisMapping;
import org.esa.snap.timeseries.core.timeseries.datamodel.ProductLocation;
import org.esa.snap.timeseries.core.timeseries.datamodel.ProductLocationType;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesChangeEvent;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesListener;
import org.esa.snap.timeseries.ui.DefaultProductLocationsPaneModel;
import org.esa.snap.timeseries.ui.DefaultVariableSelectionPaneModel;
import org.esa.snap.timeseries.ui.ProductLocationsPane;
import org.esa.snap.timeseries.ui.ProductLocationsPaneModel;
import org.esa.snap.timeseries.ui.Variable;
import org.esa.snap.timeseries.ui.VariableSelectionPane;
import org.esa.snap.timeseries.ui.VariableSelectionPaneModel;
import org.esa.snap.timeseries.ui.assistant.TimeSeriesAssistantAction;
import org.esa.snap.timeseries.ui.manager.EditTimeSpanAction;
import org.esa.snap.timeseries.ui.manager.LoadInsituAction;
import org.esa.snap.ui.NamesAssociationDialog;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

class TimeSeriesManagerForm {
    private final String helpId;
    private final DateFormat dateFormat;
    private final JComponent control;
    private final FrameClosingTimeSeriesListener frameClosingTimeSeriesListener;
    private JLabel nameField;
    private JLabel crsField;
    private JLabel startField;
    private JLabel endField;
    private JLabel dimensionField;
    private VariableSelectionPane eoVariablePane;
    private VariableSelectionPane insituVariablePane;
    private ProductLocationsPane locationsPane;
    private AbstractButton loadInsituButton;
    private AbstractButton timeSpanButton;
    private AbstractButton viewButton;
    private AbstractTimeSeries currentTimeSeries;
    private AbstractButton editNamesAssociationButton;

    TimeSeriesManagerForm(String helpId) {
        this.helpId = helpId;
        this.dateFormat = ProductData.UTC.createDateFormat((String)"dd-MMM-yyyy HH:mm:ss");
        this.control = this.createControl();
        this.frameClosingTimeSeriesListener = new FrameClosingTimeSeriesListener();
    }

    private JComponent createControl() {
        TableLayout layout = new TableLayout(4);
        layout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        layout.setTablePadding(4, 4);
        layout.setTableFill(TableLayout.Fill.BOTH);
        layout.setColumnFill(3, TableLayout.Fill.BOTH);
        layout.setRowWeightY(0, Double.valueOf(1.0));
        layout.setCellWeightY(0, 3, Double.valueOf(1.0));
        layout.setColumnWeightX(0, Double.valueOf(1.0));
        layout.setColumnWeightX(1, Double.valueOf(2.0));
        layout.setColumnWeightX(2, Double.valueOf(2.0));
        layout.setColumnWeightX(3, Double.valueOf(0.0));
        layout.setRowWeightY(1, Double.valueOf(2.0));
        layout.setCellFill(0, 0, TableLayout.Fill.HORIZONTAL);
        layout.setCellRowspan(0, 3, Integer.valueOf(2));
        layout.setCellColspan(1, 0, Integer.valueOf(3));
        this.eoVariablePane = new VariableSelectionPane();
        this.insituVariablePane = new VariableSelectionPane();
        JPanel infoPanel = this.createInfoPanel();
        JPanel variablePanel = this.createVariablePanel("Variables", this.eoVariablePane);
        JPanel insituVariablePanel = this.createVariablePanel("In-situ variables", this.insituVariablePane);
        JPanel buttonPanel = this.createButtonPanel();
        JPanel productsPanel = this.createProductsPanel();
        JPanel control = new JPanel((LayoutManager)layout);
        control.add(infoPanel);
        control.add(variablePanel);
        control.add(insituVariablePanel);
        control.add(buttonPanel);
        control.add(productsPanel);
        return control;
    }

    public JComponent getControl() {
        return this.control;
    }

    public void updateFormControl(Product product) {
        this.currentTimeSeries = TimeSeriesMapper.getInstance().getTimeSeries(product);
        if (this.currentTimeSeries != null) {
            this.currentTimeSeries.addTimeSeriesListener(this.frameClosingTimeSeriesListener);
        }
        this.loadInsituButton.setAction(new LoadInsituAction(this.currentTimeSeries));
        this.timeSpanButton.setAction(new EditTimeSpanAction(this.currentTimeSeries));
        this.updateInfoPanel(this.currentTimeSeries);
        this.updateButtonPanel(this.currentTimeSeries);
        this.updateVariablePanel(this.currentTimeSeries);
        this.updateProductsPanel(this.currentTimeSeries);
    }

    private JPanel createInfoPanel() {
        TableLayout layout = new TableLayout(2);
        layout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        layout.setTablePadding(4, 4);
        layout.setColumnWeightX(0, Double.valueOf(0.1));
        layout.setColumnWeightX(1, Double.valueOf(1.0));
        layout.setTableWeightY(Double.valueOf(0.0));
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setCellColspan(0, 0, Integer.valueOf(2));
        JLabel nameLabel = new JLabel("Name:");
        this.nameField = new JLabel();
        JLabel crsLabel = new JLabel("CRS:");
        this.crsField = new JLabel();
        JLabel startLabel = new JLabel("Start time:");
        this.startField = new JLabel();
        JLabel endLabel = new JLabel("End time:");
        this.endField = new JLabel();
        JLabel dimensionLabel = new JLabel("Dimension:");
        this.dimensionField = new JLabel("Dimension:");
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.add((Component)new TitledSeparator("Information"));
        panel.add(nameLabel);
        panel.add(this.nameField);
        panel.add(crsLabel);
        panel.add(this.crsField);
        panel.add(startLabel);
        panel.add(this.startField);
        panel.add(endLabel);
        panel.add(this.endField);
        panel.add(dimensionLabel);
        panel.add(this.dimensionField);
        return panel;
    }

    private void updateInfoPanel(AbstractTimeSeries timeSeries) {
        if (timeSeries == null) {
            this.nameField.setVisible(false);
            this.crsField.setVisible(false);
            this.startField.setVisible(false);
            this.endField.setVisible(false);
            this.dimensionField.setVisible(false);
            return;
        }
        Product tsProduct = timeSeries.getTsProduct();
        this.nameField.setText(tsProduct.getDisplayName());
        this.crsField.setText(tsProduct.getGeoCoding().getMapCRS().getName().getCode());
        String startTime = this.dateFormat.format(tsProduct.getStartTime().getAsDate());
        this.startField.setText(startTime);
        String endTime = this.dateFormat.format(tsProduct.getEndTime().getAsDate());
        this.endField.setText(endTime);
        String dimensionString = tsProduct.getSceneRasterWidth() + " x " + tsProduct.getSceneRasterHeight();
        this.dimensionField.setText(dimensionString);
    }

    private JPanel createButtonPanel() {
        TableLayout layout = new TableLayout(1);
        layout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setTableWeightY(Double.valueOf(0.0));
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.add(ToolButtonFactory.createButton((Action)((Object)new TimeSeriesAssistantAction()), (boolean)false));
        this.loadInsituButton = ToolButtonFactory.createButton((Action)new LoadInsituAction(this.currentTimeSeries), (boolean)false);
        panel.add(this.loadInsituButton);
        this.editNamesAssociationButton = ToolButtonFactory.createButton((Action)new EditNameAssociationAction(), (boolean)false);
        panel.add(this.editNamesAssociationButton);
        this.timeSpanButton = ToolButtonFactory.createButton((Action)new EditTimeSpanAction(this.currentTimeSeries), (boolean)false);
        panel.add(this.timeSpanButton);
        this.viewButton = ToolButtonFactory.createButton((Action)new ViewTimeSeriesButtonAction(), (boolean)false);
        panel.add(this.viewButton);
        panel.add(layout.createVerticalSpacer());
        AbstractButton helpButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Help22.png"), (boolean)false);
        helpButton.addActionListener(e -> new HelpCtx(this.helpId).display());
        helpButton.setToolTipText("Help");
        panel.add(helpButton);
        return panel;
    }

    private void showTimeSeriesView(String variableName) {
        List<Band> bandList = this.currentTimeSeries.getBandsForVariable(variableName);
        for (Band band : bandList) {
            TopComponent topComponent = this.getProductSceneViewTC((RasterDataNode)band);
            if (topComponent == null) continue;
            return;
        }
        if (!bandList.isEmpty()) {
            new OpenImageViewAction((RasterDataNode)bandList.get(0)).openProductSceneView();
        }
    }

    private TopComponent getProductSceneViewTC(RasterDataNode raster) {
        return WindowUtilities.getOpened(ProductSceneViewTopComponent.class).filter(topComponent -> raster == topComponent.getView().getRaster()).findFirst().orElse(null);
    }

    private void updateButtonPanel(AbstractTimeSeries timeSeries) {
        boolean enabled = timeSeries != null;
        this.viewButton.setEnabled(enabled);
        this.loadInsituButton.setEnabled(enabled);
        this.editNamesAssociationButton.setEnabled(enabled);
    }

    private JPanel createVariablePanel(String title, VariableSelectionPane variablePane) {
        TableLayout layout = new TableLayout(1);
        layout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setRowWeightY(0, Double.valueOf(0.0));
        layout.setRowWeightY(1, Double.valueOf(1.0));
        layout.setRowFill(1, TableLayout.Fill.BOTH);
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.add((Component)new TitledSeparator(title));
        variablePane.setPreferredSize(new Dimension(150, 80));
        panel.add(variablePane);
        return panel;
    }

    private void updateVariablePanel(AbstractTimeSeries timeSeries) {
        AbstractListModel model = timeSeries != null ? new TimeSeriesEoVariableSelectionPaneModel(timeSeries) : new DefaultVariableSelectionPaneModel();
        this.eoVariablePane.setModel((VariableSelectionPaneModel)((Object)model));
    }

    private void updateInsituVariablePanel() {
        AbstractListModel model = this.currentTimeSeries != null ? new TimeSeriesInsituVariableSelectionPaneModel(this.currentTimeSeries) : new DefaultVariableSelectionPaneModel();
        this.insituVariablePane.setModel((VariableSelectionPaneModel)((Object)model));
    }

    private JPanel createProductsPanel() {
        TableLayout layout = new TableLayout(1);
        layout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setRowWeightY(0, Double.valueOf(0.0));
        layout.setRowWeightY(1, Double.valueOf(1.0));
        layout.setRowFill(1, TableLayout.Fill.BOTH);
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.add((Component)new TitledSeparator("Product Sources"));
        this.locationsPane = new ProductLocationsPane();
        this.locationsPane.setPreferredSize(new Dimension(150, 80));
        panel.add(this.locationsPane);
        return panel;
    }

    private void updateProductsPanel(AbstractTimeSeries timeSeries) {
        AbstractListModel locationsModel = timeSeries != null ? new TimeSeriesProductLocationsPaneModel(timeSeries) : new DefaultProductLocationsPaneModel();
        this.locationsPane.setModel((ProductLocationsPaneModel)((Object)locationsModel), timeSeries != null);
    }

    private void closeAssociatedViews(List<Band> bands) {
        for (Band band : bands) {
            TopComponent topComponent = this.getProductSceneViewTC((RasterDataNode)band);
            if (topComponent == null) continue;
            topComponent.close();
        }
    }

    private NamesAssociationDialog.AssociationModel getAssociationModel() {
        final AxisMapping axisMapping = this.currentTimeSeries.getAxisMapping();
        return new NamesAssociationDialog.AssociationModel(){

            @Override
            public List<String> getRightListNames(String alias) {
                return axisMapping.getInsituNames(alias);
            }

            @Override
            public List<String> getCenterListNames(String alias) {
                return axisMapping.getRasterNames(alias);
            }

            @Override
            public void addFromCenterList(String alias, String name) {
                axisMapping.addRasterName(alias, name);
            }

            @Override
            public void addFromRightList(String alias, String name) {
                axisMapping.addInsituName(alias, name);
            }

            @Override
            public void removeAlias(String alias) {
                axisMapping.removeAlias(alias);
            }

            @Override
            public void addAlias(String alias) {
                axisMapping.addAlias(alias);
            }

            @Override
            public void removeFromRightList(String alias, String name) {
                axisMapping.removeInsituName(alias, name);
            }

            @Override
            public void removeFromCenterList(String alias, String name) {
                axisMapping.removeRasterName(alias, name);
            }

            @Override
            public Set<String> getAliasNames() {
                return axisMapping.getAliasNames();
            }

            @Override
            public void replaceAlias(String beforeName, String changedName) {
                axisMapping.replaceAlias(beforeName, changedName);
            }
        };
    }

    private NamesAssociationDialog.NameProvider getNameProvider() {
        String windowTitle = "Names Association";
        String aliasHeaderName = "Association name:";
        String centerHeaderName = "Names from time series:";
        String rightHeaderName = "Names from insitu file:";
        return new NamesAssociationDialog.NameProvider("Names Association", "Association name:", "Names from time series:", "Names from insitu file:"){

            @Override
            public String[] getCenterNames() {
                List<String> eoVariables = TimeSeriesManagerForm.this.currentTimeSeries.getEoVariables();
                return eoVariables.toArray(new String[eoVariables.size()]);
            }

            @Override
            public String[] getRightNames() {
                if (TimeSeriesManagerForm.this.currentTimeSeries.getInsituSource() != null) {
                    return TimeSeriesManagerForm.this.currentTimeSeries.getInsituSource().getParameterNames();
                }
                return new String[0];
            }
        };
    }

    private class FrameClosingTimeSeriesListener
    extends TimeSeriesListener {
        private FrameClosingTimeSeriesListener() {
        }

        @Override
        public void timeSeriesChanged(TimeSeriesChangeEvent event) {
            if (event.getType() == 1) {
                Band band = (Band)event.getValue();
                TimeSeriesManagerForm.this.closeAssociatedViews(Collections.singletonList(band));
            } else if (event.getType() == 32) {
                TimeSeriesManagerForm.this.updateInsituVariablePanel();
            }
        }
    }

    private class ViewTimeSeriesAction
    extends AbstractAction {
        private final String variableName;

        private ViewTimeSeriesAction(String variableName) {
            super("View " + variableName);
            this.variableName = variableName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeSeriesManagerForm.this.showTimeSeriesView(this.variableName);
        }
    }

    private class ViewTimeSeriesButtonAction
    extends AbstractAction {
        private ViewTimeSeriesButtonAction() {
            URL viewIconImageURL = UIUtils.getImageURL((String)"/org/esa/snap/timeseries/ui/icons/timeseries-view24.png", TimeSeriesManagerForm.class);
            this.putValue("SwingLargeIconKey", new ImageIcon(viewIconImageURL));
            this.putValue("ShortDescription", "View Time Series");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariableSelectionPaneModel variableModel = TimeSeriesManagerForm.this.eoVariablePane.getModel();
            List<String> variableNames = variableModel.getSelectedVariableNames();
            if (!variableNames.isEmpty() && TimeSeriesManagerForm.this.currentTimeSeries != null) {
                if (variableNames.size() == 1) {
                    TimeSeriesManagerForm.this.showTimeSeriesView(variableNames.get(0));
                } else {
                    JPopupMenu viewPopup = new JPopupMenu("View variable");
                    for (String varName : variableNames) {
                        viewPopup.add(new ViewTimeSeriesAction(varName));
                    }
                    Rectangle buttonBounds = TimeSeriesManagerForm.this.viewButton.getBounds();
                    viewPopup.show(TimeSeriesManagerForm.this.viewButton, 1, buttonBounds.height + 1);
                }
            }
        }
    }

    private class EditNameAssociationAction
    extends AbstractAction {
        private EditNameAssociationAction() {
            URL viewIconImageURL = UIUtils.getImageURL((String)"/org/esa/snap/timeseries/ui/icons/timeseries-combvar24.png", TimeSeriesManagerForm.class);
            this.putValue("SwingLargeIconKey", new ImageIcon(viewIconImageURL));
            this.putValue("ShortDescription", "Edit names association");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NamesAssociationDialog.AssociationModel associationModel = TimeSeriesManagerForm.this.getAssociationModel();
            NamesAssociationDialog.NameProvider nameProvider = TimeSeriesManagerForm.this.getNameProvider();
            String helpId = "associations";
            NamesAssociationDialog.show(associationModel, nameProvider, "associations");
        }
    }

    private class TimeSeriesProductLocationsPaneModel
    extends AbstractListModel
    implements ProductLocationsPaneModel {
        private final AbstractTimeSeries timeSeries;

        private TimeSeriesProductLocationsPaneModel(AbstractTimeSeries timeSeries) {
            this.timeSeries = timeSeries;
        }

        @Override
        public int getSize() {
            return this.timeSeries.getProductLocations().size();
        }

        @Override
        public ProductLocation getElementAt(int index) {
            return this.timeSeries.getProductLocations().get(index);
        }

        @Override
        public List<ProductLocation> getProductLocations() {
            return this.timeSeries.getProductLocations();
        }

        @Override
        public void addFiles(File ... files) {
            int startIndex = this.timeSeries.getProductLocations().size();
            for (File file : files) {
                this.timeSeries.addProductLocation(new ProductLocation(ProductLocationType.FILE, file.getAbsolutePath()));
            }
            int stopIndex = this.timeSeries.getProductLocations().size() - 1;
            this.fireIntervalAdded(this, startIndex, stopIndex);
        }

        @Override
        public void addDirectory(File directory, boolean recursive) {
            this.timeSeries.addProductLocation(new ProductLocation(recursive ? ProductLocationType.DIRECTORY_REC : ProductLocationType.DIRECTORY, directory.getAbsolutePath()));
            int index = this.timeSeries.getProductLocations().size() - 1;
            this.fireIntervalAdded(this, index, index);
        }

        @Override
        public void remove(int ... indices) {
            List<ProductLocation> locationList = this.timeSeries.getProductLocations();
            ArrayList<ProductLocation> toRemove = new ArrayList<ProductLocation>();
            for (int index : indices) {
                toRemove.add(locationList.get(index));
            }
            Object object = toRemove.iterator();
            while (object.hasNext()) {
                ProductLocation location = (ProductLocation)object.next();
                TimeSeriesManagerForm.this.closeAssociatedViews(this.timeSeries.getBandsForProductLocation(location));
                this.timeSeries.removeProductLocation(location);
            }
            if (!toRemove.isEmpty()) {
                this.fireContentsChanged(this, indices[0], indices[indices.length - 1]);
            }
        }
    }

    private static class TimeSeriesInsituVariableSelectionPaneModel
    extends AbstractListModel
    implements VariableSelectionPaneModel {
        private final AbstractTimeSeries timeSeries;

        private TimeSeriesInsituVariableSelectionPaneModel(AbstractTimeSeries timeSeries) {
            this.timeSeries = timeSeries;
        }

        @Override
        public int getSize() {
            return this.timeSeries.getInsituSource().getParameterNames().length;
        }

        @Override
        public Variable getElementAt(int index) {
            String variableName = this.timeSeries.getInsituSource().getParameterNames()[index];
            return new Variable(variableName, this.timeSeries.isInsituVariableSelected(variableName));
        }

        @Override
        public void set(Variable ... variables) {
        }

        @Override
        public void add(Variable ... variables) {
        }

        @Override
        public void setSelectedVariableAt(int index, boolean selected) {
            String variableName = this.timeSeries.getInsituSource().getParameterNames()[index];
            if (this.timeSeries.isInsituVariableSelected(variableName) != selected) {
                this.timeSeries.setInsituVariableSelected(variableName, selected);
                this.fireContentsChanged(this, index, index);
            }
        }

        @Override
        public List<String> getSelectedVariableNames() {
            String[] allVars = this.timeSeries.getInsituSource().getParameterNames();
            ArrayList<String> selectedVars = new ArrayList<String>(allVars.length);
            for (String varName : allVars) {
                if (!this.timeSeries.isInsituVariableSelected(varName)) continue;
                selectedVars.add(varName);
            }
            return selectedVars;
        }
    }

    private class TimeSeriesEoVariableSelectionPaneModel
    extends AbstractListModel
    implements VariableSelectionPaneModel {
        private final AbstractTimeSeries timeSeries;

        private TimeSeriesEoVariableSelectionPaneModel(AbstractTimeSeries timeSeries) {
            this.timeSeries = timeSeries;
        }

        @Override
        public int getSize() {
            return this.timeSeries.getEoVariables().size();
        }

        @Override
        public Variable getElementAt(int index) {
            String varName = this.timeSeries.getEoVariables().get(index);
            return new Variable(varName, this.timeSeries.isEoVariableSelected(varName));
        }

        @Override
        public void set(Variable ... variables) {
        }

        @Override
        public void add(Variable ... variables) {
        }

        @Override
        public void setSelectedVariableAt(int index, boolean selected) {
            String varName = this.timeSeries.getEoVariables().get(index);
            if (this.timeSeries.isEoVariableSelected(varName) != selected) {
                if (!selected) {
                    TimeSeriesManagerForm.this.closeAssociatedViews(this.timeSeries.getBandsForVariable(varName));
                }
                this.timeSeries.setEoVariableSelected(varName, selected);
                this.fireContentsChanged(this, index, index);
            }
        }

        @Override
        public List<String> getSelectedVariableNames() {
            List<String> allVars = this.timeSeries.getEoVariables();
            ArrayList<String> selectedVars = new ArrayList<String>(allVars.size());
            selectedVars.addAll(allVars.stream().filter(this.timeSeries::isEoVariableSelected).collect(Collectors.toList()));
            return selectedVars;
        }
    }
}

