/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.manager;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.framework.ui.UIUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.timeseries.core.insitu.InsituLoader;
import org.esa.snap.timeseries.core.insitu.InsituLoaderFactory;
import org.esa.snap.timeseries.core.insitu.InsituSource;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.util.SystemUtils;
import org.esa.snap.util.io.BeamFileChooser;

class LoadInsituAction
extends AbstractAction {
    private static final String PROPERTY_KEY_LAST_OPEN_INSITU_DIR = "timeseries.file.lastInsituOpenDir";
    private final AbstractTimeSeries currentTimeSeries;
    private InsituSource insituSource;

    public LoadInsituAction(AbstractTimeSeries currentTimeSeries) {
        this.putValue("ShortDescription", "Import in-situ source file");
        this.putValue("SwingLargeIconKey", UIUtils.loadImageIcon((String)"icons/Import24.gif"));
        this.currentTimeSeries = currentTimeSeries;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Preferences preferences = SnapApp.getDefault().getPreferences();
        String lastDir = preferences.get(PROPERTY_KEY_LAST_OPEN_INSITU_DIR, SystemUtils.getUserHomeDir().getPath());
        BeamFileChooser fileChooser = new BeamFileChooser(new File(lastDir));
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setDialogTitle("Select in-situ source file");
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter actualFileFilter = fileChooser.getAcceptAllFileFilter();
        fileChooser.setFileFilter(actualFileFilter);
        int result = fileChooser.showDialog((Component)SnapApp.getDefault().getMainFrame(), "Select in-situ source file");
        if (result != 0) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        try {
            InsituLoader insituLoader = InsituLoaderFactory.createInsituLoader(selectedFile);
            if (this.insituSource != null) {
                this.insituSource.close();
            }
            this.insituSource = new InsituSource(insituLoader.loadSource());
            this.currentTimeSeries.setInsituSource(this.insituSource);
        }
        catch (IOException exception) {
            SystemUtils.LOG.log(Level.WARNING, "Unable to load in-situ data from '" + selectedFile + "'.", exception);
            return;
        }
        File currentDirectory = fileChooser.getCurrentDirectory();
        if (currentDirectory != null) {
            preferences.put(PROPERTY_KEY_LAST_OPEN_INSITU_DIR, currentDirectory.getAbsolutePath());
        }
    }
}

