/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.manager;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.framework.ui.ModalDialog;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.GridTimeCoding;
import org.esa.snap.timeseries.core.timeseries.datamodel.ProductLocation;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeCoding;
import org.jdesktop.swingx.JXDatePicker;
import org.openide.util.ImageUtilities;

class EditTimeSpanAction
extends AbstractAction {
    private final AbstractTimeSeries timeSeries;

    EditTimeSpanAction(AbstractTimeSeries timeSeries) {
        this.timeSeries = timeSeries;
        this.setEnabled(timeSeries != null);
        ImageIcon editTimeSpanIcon = ImageUtilities.loadImageIcon((String)"org/esa/snap/timeseries/ui/icons/timeseries-rangeedit24.png", (boolean)false);
        this.putValue("SwingLargeIconKey", editTimeSpanIcon);
        this.putValue("ActionCommandKey", this.getClass().getName());
        this.putValue("ShortDescription", "Edit time span");
        this.putValue("componentName", "EditTimeSpan");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Window window = null;
        if (source instanceof Component) {
            window = SwingUtilities.getWindowAncestor((Component)source);
        }
        EditTimeSpanDialog dialog = new EditTimeSpanDialog(window, this.timeSeries);
        dialog.show();
    }

    private static class EditTimeSpanDialog
    extends ModalDialog {
        private final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"dd-MMM-yyyy HH:mm:ss");
        private AbstractTimeSeries timeSeries;
        private JXDatePicker startTimeBox;
        private JXDatePicker endTimeBox;
        private JLabel startTimeLabel;
        private JLabel endTimeLabel;
        private JCheckBox autoAdjustBox;

        private EditTimeSpanDialog(Window window, AbstractTimeSeries timeSeries) {
            super(window, "Edit Time Span", 33, null);
            this.timeSeries = timeSeries;
            this.createUserInterface();
        }

        protected void onOK() {
            this.timeSeries.setAutoAdjustingTimeCoding(this.autoAdjustBox.isSelected());
            ProductData.UTC startTime = ProductData.UTC.create((Date)this.startTimeBox.getDate(), (long)0L);
            ProductData.UTC endTime = ProductData.UTC.create((Date)this.endTimeBox.getDate(), (long)0L);
            this.timeSeries.setTimeCoding(new GridTimeCoding(startTime, endTime));
            super.onOK();
        }

        protected boolean verifyUserInput() {
            if (this.endTimeBox.getDate().compareTo(this.startTimeBox.getDate()) < 0) {
                this.showErrorDialog("End time is before start time.");
                return false;
            }
            return true;
        }

        private void createUserInterface() {
            boolean isAutoAdjustingTimeCoding = this.timeSeries.isAutoAdjustingTimeCoding();
            TableLayout tableLayout = new TableLayout(2);
            tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
            tableLayout.setTableWeightX(Double.valueOf(1.0));
            tableLayout.setTableFill(TableLayout.Fill.BOTH);
            tableLayout.setTablePadding(4, 4);
            tableLayout.setCellColspan(0, 0, Integer.valueOf(2));
            JPanel content = new JPanel((LayoutManager)tableLayout);
            this.autoAdjustBox = this.createAutoAdjustBox(isAutoAdjustingTimeCoding);
            this.startTimeLabel = new JLabel("Start time:");
            this.startTimeBox = this.createDateComboBox();
            TimeCoding timeCoding = this.timeSeries.getTimeCoding();
            this.startTimeBox.setDate(timeCoding.getStartTime().getAsDate());
            this.endTimeLabel = new JLabel("End time:");
            this.endTimeBox = this.createDateComboBox();
            this.endTimeBox.setDate(timeCoding.getEndTime().getAsDate());
            content.add(this.autoAdjustBox);
            content.add(this.startTimeLabel);
            content.add((Component)this.startTimeBox);
            content.add(this.endTimeLabel);
            content.add((Component)this.endTimeBox);
            this.setUiEnabled(!isAutoAdjustingTimeCoding);
            this.setContent(content);
        }

        private JCheckBox createAutoAdjustBox(boolean autoAdjustingTimeCoding) {
            JCheckBox autoAdjustBox = new JCheckBox("Auto adjust time information", autoAdjustingTimeCoding);
            autoAdjustBox.addActionListener(new AutoAdjustBoxListener(autoAdjustBox));
            return autoAdjustBox;
        }

        private List<Product> getCompatibleProducts() {
            ArrayList<Product> result = new ArrayList<Product>();
            for (ProductLocation productLocation : this.timeSeries.getProductLocations()) {
                for (Product product : productLocation.getProducts(ProgressMonitor.NULL).values()) {
                    result.addAll(this.timeSeries.getEoVariables().stream().filter(variable -> this.timeSeries.isProductCompatible(product, (String)variable)).filter(this.timeSeries::isEoVariableSelected).map(variable -> product).collect(Collectors.toList()));
                }
            }
            return result;
        }

        private ProductData.UTC getMaxEndTime(ProductData.UTC endTime1, ProductData.UTC endTime2) {
            ProductData.UTC endTime = endTime1.getAsDate().before(endTime2.getAsDate()) ? endTime2 : endTime1;
            return endTime;
        }

        private ProductData.UTC getMinStartTime(ProductData.UTC startTime1, ProductData.UTC startTime2) {
            ProductData.UTC startTime = startTime1.getAsDate().after(startTime2.getAsDate()) ? startTime2 : startTime1;
            return startTime;
        }

        private JXDatePicker createDateComboBox() {
            TimeZone utcZone = TimeZone.getTimeZone("UTC");
            Calendar utc = Calendar.getInstance(utcZone);
            Date date = utc.getTime();
            JXDatePicker datePicker = new JXDatePicker(date);
            datePicker.setTimeZone(utcZone);
            datePicker.setFormats(new DateFormat[]{this.dateFormat});
            return datePicker;
        }

        private void setUiEnabled(boolean enable) {
            this.startTimeBox.setEnabled(enable);
            this.startTimeLabel.setEnabled(enable);
            this.endTimeBox.setEnabled(enable);
            this.endTimeLabel.setEnabled(enable);
        }

        private class AutoAdjustBoxListener
        implements ActionListener {
            private final JCheckBox autoAdjustBox;

            private AutoAdjustBoxListener(JCheckBox autoAdjustBox) {
                this.autoAdjustBox = autoAdjustBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = this.autoAdjustBox.isSelected();
                EditTimeSpanDialog.this.setUiEnabled(!selected);
                if (!selected) {
                    return;
                }
                ProductData.UTC autoStartTime = null;
                ProductData.UTC autoEndTime = null;
                List compatibleProducts = EditTimeSpanDialog.this.getCompatibleProducts();
                for (Product product : compatibleProducts) {
                    TimeCoding varTimeCoding = GridTimeCoding.create(product);
                    if (autoStartTime == null) {
                        TimeCoding tsTimeCoding = EditTimeSpanDialog.this.timeSeries.getTimeCoding();
                        autoStartTime = tsTimeCoding.getStartTime();
                        autoEndTime = tsTimeCoding.getEndTime();
                    }
                    if (varTimeCoding == null) continue;
                    autoStartTime = EditTimeSpanDialog.this.getMinStartTime(autoStartTime, varTimeCoding.getStartTime());
                    autoEndTime = EditTimeSpanDialog.this.getMaxEndTime(autoEndTime, varTimeCoding.getEndTime());
                }
                if (autoStartTime == null) {
                    try {
                        autoEndTime = autoStartTime = ProductData.UTC.parse((String)"1970-01-01", (String)"yyyy-MM-dd");
                    }
                    catch (ParseException ignore) {
                        // empty catch block
                    }
                }
                EditTimeSpanDialog.this.startTimeBox.setDate(autoStartTime.getAsDate());
                EditTimeSpanDialog.this.endTimeBox.setDate(autoEndTime.getAsDate());
            }
        }
    }
}

